#--------------------------PYNTERFEROMETER------------------------------#
#
# The Pynterferometer was created and developed by 
# ADAM AVISON (1) and SAM GEORGE (2). 
# 
# For educational/non commercial use. If commerical use is desired please
# see www.jb.man.ac.uk/pynterferometer/download.html
#
# Version LinuxAdvanced 0.11: 20/11/2012 
#---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- -#
# (1) UK ALMA Regional Centre, Jodrell Bank Centre for Astrophysics,
#     University of Manchester.
#
# (2) Astrophysics Group, Cavendish Laboratory, University of Cambridge.
#-----------------------------------------------------------------------#

#----------------------------IMPORTED PACKAGES--------------------------#
import numpy as np
from Tkinter import *
from ttk import *
import matplotlib
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import matplotlib.image as mpimg
import pylab as pyl
import math, os, time

import Image, ImageTk #, ImageGrab, ImageWin
import cv
from time import sleep, strftime, gmtime

import subprocess, scipy
from scipy import *
from scipy import signal, ndimage
from pylab import figure, show, clf, savefig, cm
#-----------------------------------------------------------------------#

#--------------------------------CONSTANTS------------------------------#
BALLS = 30              # IN SIMULATION
WALL = 50               # FROM SIDE IN PIXELS
FRAMES_PER_SEC = 40     # SCREEN UPDATE RATE
OFFSET_START = 10       # FROM WALL IN PIXELS
dpi = 150               #dots per inch
freq=3e7                # Frequency
wavel=3e8/freq          # Wavelength
dec_ang=90.0            # Declination angle of 'source'
sin_dec=np.sin((dec_ang * np.pi)/ 180.) #sin of dec
OUT_UPDATE=2000         # ms for output update!
IN_UPDATE=4000          # ms for output update!
gif_image='output.png'
filenamein = "shed.png" #initial image; can be replaced with cam image
zoom_factor=1.0         #initial zoom factor
synthesis_type=0        #initial synthesis type, 0==snapshot 1==earth rotation.
urlpic = "URL"          #url returned by twitpic
statusmsg = "Intial"    #start point
configmsg = "Spiral with 30 ant." #initial config of antennas
balltext = '30'         #initial number of antennas
bgcolour="#a0d0d5"      #BG colour for most bits of the widget
pix_to_m=1.             #for input image
col_map=cm.gist_gray    #default
add_min=0
x_pos = [0]             #initialise - otherwise get a x_pos not defined in first 
y_pos = [0]             # calc_uvplt call. 
#-----------------------------------------------------------------------#

#-----------------------------------------------------------------------#
#-------------------FUNCTION DEFINITIONS--------------------------------#
def initialise():
    ''' Setup simulation variables.'''
    global active
    active = False

    print filenamein
    size=int(WIDTH_IMGS), int(HEIGHT_IMGS)
    im = Image.open(filenamein)
    im.resize(size, Image.ANTIALIAS)
    im.save(filenamein, "PNG")

    define_spiral()
    build_balls()
    
def update_array():
    ''' to update array canvas'''
    array_canvas.after(1000 / FRAMES_PER_SEC, update_array)
    draw()

def update_uv():
    ''' to update array canvas'''
    uv_image.after(OUT_UPDATE, update_uv)
    draw_uvplt()

def update_output():
    ''' to update array canvas '''
    output_image.after(OUT_UPDATE, update_output)
    draw_output()
    calc_uvplt()


def define_alma():
    '''ALMA configurations from CASA - configs 1,4,8,12,16,20 are used
       - 12,16,20 are rescaled so that they appear in the plotted area '''
    global balls, orig_x, orig_y, configmsg, balltext, BALLS, zoom_factor
    almaconf = int(var.get())
    configmsg = "ALMA "+ str(almaconf) + " with "
    if BALLS == 1:
        BALLS=2
    
    if almaconf == 1:
        orig_x  =  [-0.84259999997448176, 15.607399999978952, 10.657400000025518, 27.507400000002235, 57.967399999964982, 53.867399999988265, 49.03739999991376, 42.707399999955669, 23.607399999978952, 12.647400000016205, 70.607399999978952, 69.657400000025518, 34.067399999941699, 49.747399999992922, 44.197399999946356, 13.087399999960326, 26.547399999923073, -8.292600000044331, -17.222599999979138, -28.062600000062957, -10.522600000025705, -10.072600000072271, -25.942600000067614, -41.142600000021048, -51.352599999983795, -53.932600000058301, -60.312600000062957, -23.402600000030361, -37.432600000058301, -35.272600000025705, -62.632600000011735, -70.232599999988452, -72.672600000048988, -43.852599999983795, 6.8874000000068918, 17.347399999969639, -18.552600000053644, -47.842599999974482, -31.602599999983795, -9.8326000000815839, 9.3874000000068918, 34.967399999964982, 49.647400000016205, -47.542600000044331, -31.052600000053644, -4.0326000000350177, 12.687399999937043, 30.847399999969639, 62.817399999941699, 17.547399999923073]
        orig_y  =  [8.0696000000461936, 11.069600000046194, 28.7195999994874, -3.2004000004380941, -24.080400000326335, -1.1003999998793006, 19.709599999710917, 33.349600000306964, 56.739599999971688, 67.089599999599159, -15.640399999916553, -0.41040000040084124, 17.859600000083447, 46.779600000008941, 60.819600000046194, 86.7195999994874, 35.609600000083447, -5.0804000003263354, 9.7495999997481704, -1.7303999997675419, 28.709599999710917, 68.099600000306964, 53.419599999673665, 36.479600000195205, 16.349600000306964, -10.970399999991059, -24.600399999879301, 75.509599999524653, 65.24959999974817, 22.629599999636412, 26.439600000157952, 1.6396000003442168, -33.5304000005126, 3.0196000002324581, -5.4204000001773238, -25.660400000400841, -25.670400000177324, -43.840400000102818, -50.010400000028312, -56.900399999693036, -57.810399999842048, -42.720399999991059, -46.090400000102818, -59.090400000102818, -65.670400000177324, -41.270399999804795, -73.810399999842048, -68.32039999961853, -53.580400000326335, -43.620400000363588]

    if almaconf == 2:
        orig_x  =  [-3.8883999999379739, 7.6116000000620261, 24.461600000038743, 54.92160000000149, 50.821600000024773, 45.991599999950267, 39.661599999992177, 20.56160000001546, 9.6016000000527129, 67.56160000001546, 66.611600000062026, 31.021599999978207, 46.70160000002943, 41.151599999982864, 10.041599999996834, 23.501599999959581, -11.338400000007823, -31.10840000002645, -13.568399999989197, -13.118400000035763, -28.988400000031106, -44.18839999998454, -56.978400000021793, -63.35840000002645, -26.448399999993853, -40.478400000021793, -38.318399999989197, -65.678399999975227, -73.278399999951944, -75.71840000001248, -46.898399999947287, 3.8416000000433996, 14.301600000006147, -21.598400000017136, -50.888399999937974, -34.648399999947287, -12.878400000045076, 31.92160000000149, 46.601600000052713, -50.588400000007823, -34.098400000017136, -7.0783999999985099, 9.6415999999735504, 27.801600000006147, 59.771599999978207, 14.501599999959581, -50.478400000021793, 56.541599999996834, -23.868400000035763, 114.33160000003409]
        orig_y  =  [9.430400000885129, 30.080400000326335, -1.8395999995991588, -22.7195999994874, 0.26040000095963478, 21.070400000549853, 34.710400001145899, 58.100400000810623, 68.450400000438094, -14.279599999077618, 0.95040000043809414, 19.220400000922382, 48.140400000847876, 62.180400000885129, 88.080400000326335, 36.970400000922382, -3.7195999994874001, -0.36959999892860651, 30.070400000549853, 69.460400001145899, 54.7804000005126, 37.840400001034141, -9.6095999991521239, -23.239599999040365, 76.870400000363588, 66.610400000587106, 23.990400000475347, 27.800400000996888, 3.0004000011831522, -32.169599999673665, 4.3804000010713935, -4.0595999993383884, -24.299599999561906, -24.309599999338388, -42.479599999263883, -48.649599999189377, -55.539599998854101, -41.359599999152124, -44.729599999263883, -57.729599999263883, -64.309599999338388, -39.909599998965859, -72.449599999003112, -66.959599998779595, -52.2195999994874, -42.259599999524653, -106.24959999881685, -105.61959999892861, 105.57040000054985, 23.06040000077337]

    if almaconf == 3:
        orig_x  =  [0.47200000006705523, 11.972000000067055, 28.822000000043772, 59.282000000006519, 55.182000000029802, 50.351999999955297, 24.922000000020489, 13.962000000057742, 71.922000000020489, 70.972000000067055, 35.381999999983236, 51.062000000034459, 45.511999999987893, 14.402000000001863, -6.978000000002794, -26.74800000002142, -9.2079999999841675, -8.7580000000307336, -24.628000000026077, -39.827999999979511, -52.618000000016764, -58.99800000002142, -22.087999999988824, -36.118000000016764, -33.957999999984168, -61.317999999970198, -68.917999999946915, -71.358000000007451, 8.2020000000484288, 18.662000000011176, -17.238000000012107, -46.527999999932945, -30.287999999942258, -8.5180000000400469, 36.282000000006519, 50.962000000057742, -46.228000000002794, -29.738000000012107, -2.7179999999934807, 14.00199999997858, 32.162000000011176, 64.131999999983236, 27.771999999997206, -46.118000000016764, 60.902000000001863, 33.631999999983236, -19.508000000030734, 118.69200000003912, -105.50800000003073, -125.70799999998417]
        orig_y  =  [10.707599997520447, 31.357599996961653, -0.56240000296384096, -21.442400002852082, 1.5375999975949526, 22.347599997185171, 59.377599997445941, 69.727599997073412, -13.0024000024423, 2.2275999970734119, 20.4975999975577, 49.417599997483194, 63.457599997520447, 89.357599996961653, -2.4424000028520823, 0.90759999770671129, 31.347599997185171, 70.737599997781217, 56.057599997147918, 39.117599997669458, -8.3324000025168061, -21.962400002405047, 78.147599996998906, 67.887599997222424, 25.267599997110665, 29.077599997632205, 4.27759999781847, -30.892400003038347, -2.7824000027030706, -23.022400002926588, -23.032400002703071, -41.202400002628565, -47.372400002554059, -54.262400002218783, -40.082400002516806, -43.452400002628565, -56.452400002628565, -63.032400002703071, -38.632400002330542, -71.172400002367795, -65.682400002144277, -50.942400002852082, -139.48240000288934, -104.97240000218153, -104.34240000229329, 106.25759999733418, 106.84759999718517, 24.337599997408688, 73.137599997222424, -64.862400002777576]

    if almaconf == 4:
        orig_x  =  [-3.0713999998988584, 8.4286000001011416, 25.278600000077859, 55.738600000040606, 51.638600000063889, 46.808599999989383, 21.378600000054576, 10.418600000091828, 68.378600000054576, 67.428600000101142, 47.518600000068545, 41.968600000021979, 10.858600000035949, -10.521399999968708, -30.291399999987334, -12.751399999950081, -12.301399999996647, -28.171399999991991, -43.371399999945424, -56.161399999982677, -62.541399999987334, -25.631399999954738, -39.661399999982677, -64.861399999936111, -72.461399999912828, -74.901399999973364, 4.6586000000825152, 15.118600000045262, -50.071399999898858, -33.831399999908172, -12.06140000000596, 32.738600000040606, 47.418600000091828, -49.771399999968708, -33.281399999978021, 10.458600000012666, 28.618600000045262, 60.588600000017323, 24.228600000031292, -27.781399999978021, -49.661399999982677, 57.358600000035949, 30.088600000017323, -23.051399999996647, 115.1486000000732, -109.05139999999665, -129.25139999995008, 138.34860000002664, -86.851399999926798, 120.74860000004992]
        orig_y  =  [8.6879999972879887, 29.337999996729195, -2.5820000031962991, -23.46200000308454, -0.48200000263750553, 20.327999996952713, 57.357999997213483, 67.707999996840954, -15.022000002674758, 0.20799999684095383, 47.397999997250736, 61.437999997287989, 87.337999996729195, -4.4620000030845404, -1.1120000025257468, 29.327999996952713, 68.717999997548759, 54.03799999691546, 37.097999997437, -10.352000002749264, -23.982000002637506, 76.127999996766448, 65.867999996989965, 27.057999997399747, 2.2579999975860119, -32.912000003270805, -4.8020000029355288, -25.042000003159046, -43.222000002861023, -49.392000002786517, -56.282000002451241, -42.102000002749264, -45.472000002861023, -58.472000002861023, -65.052000002935529, -73.192000002600253, -67.702000002376735, -52.96200000308454, -141.50200000312179, -140.152000002563, -106.99200000241399, -106.36200000252575, 104.23799999710172, 104.82799999695271, 22.31799999717623, 71.117999996989965, -66.882000003010035, -42.582000003196299, 139.4179999968037, 120.31799999717623]

    if almaconf == 5:
        orig_x  =  [-0.37139999982900918, 11.128600000170991, 58.438600000110455, 54.338600000133738, 49.508600000059232, 24.078600000124425, 13.118600000161678, 71.078600000124425, 70.128600000170991, 50.218600000138395, 44.668600000091828, 13.558600000105798, -7.8213999998988584, -27.591399999917485, -9.601399999926798, -25.471399999922141, -53.461399999912828, -59.841399999917485, -22.931399999884889, -36.961399999912828, -62.161399999866262, -69.761399999842979, -72.201399999903515, 7.3586000001523644, 17.818600000115111, -47.371399999829009, -31.131399999838322, 35.438600000110455, 50.118600000161678, -47.071399999898858, -30.581399999908172, 13.158600000082515, 31.318600000115111, 63.288600000087172, 26.928600000101142, -25.081399999908172, -46.961399999912828, 60.058600000105798, 32.788600000087172, -20.351399999926798, 117.84860000014305, -106.3513999999268, -126.55139999988023, 141.04860000009649, -84.151399999856949, 123.44860000011977, -171.55139999988023, 135.94860000011977, -27.451399999903515, -104.05139999988023]
        orig_y  =  [10.969799996353686, 31.619799995794892, -21.180200004018843, 1.7997999964281917, 22.60979999601841, 59.63979999627918, 69.989799995906651, -12.740200003609061, 2.489799995906651, 49.679799996316433, 63.719799996353686, 89.619799995794892, -2.1802000040188432, 1.1697999965399504, 70.999799996614456, 56.319799995981157, -8.070200003683567, -21.700200003571808, 78.409799995832145, 68.149799996055663, 29.339799996465445, 4.5397999966517091, -30.630200004205108, -2.5202000038698316, -22.760200004093349, -40.940200003795326, -47.11020000372082, -39.820200003683567, -43.190200003795326, -56.190200003795326, -62.770200003869832, -70.910200003534555, -65.420200003311038, -50.680200004018843, -139.2202000040561, -137.8702000034973, -104.71020000334829, -104.08020000346005, 106.51979999616742, 107.10979999601841, 24.599799996241927, 73.399799996055663, -64.600200003944337, -40.300200004130602, 141.6997999958694, 122.59979999624193, 0.49979999661445618, -125.3002000041306, 204.6997999958694, -177.3002000041306]

    if almaconf == 6:
        orig_x  =  [-2.466599999810569, 9.033400000189431, 56.343400000128895, 52.243400000152178, 21.983400000142865, 68.983400000142865, 68.033400000189431, 48.123400000156835, 42.573400000110269, 11.463400000124238, -9.9165999998804182, -29.686599999899045, -11.696599999908358, -27.566599999903701, -55.556599999894388, -25.026599999866448, -39.056599999894388, -64.256599999847822, -71.856599999824539, -74.296599999885075, 5.2634000001708046, 15.723400000133552, -49.466599999810569, -33.226599999819882, 33.343400000128895, -49.166599999880418, -32.676599999889731, 11.063400000100955, 29.223400000133552, 61.193400000105612, 24.833400000119582, -27.176599999889731, -49.056599999894388, 57.963400000124238, 30.693400000105612, -22.446599999908358, 115.75340000016149, -108.44659999990836, -128.64659999986179, 138.95340000011493, -86.246599999838509, 121.35340000013821, -173.64659999986179, 133.85340000013821, -29.546599999885075, -106.14659999986179, 191.25340000016149, -192.84659999981523, 88.153400000184774, 62.723400000133552]
        orig_y  =  [7.7389999991282821, 28.388999998569489, -24.411000001244247, -1.4310000007972121, 56.408999999053776, -15.971000000834465, -0.74100000131875277, 46.448999999091029, 60.488999999128282, 86.388999998569489, -5.411000001244247, -2.0610000006854534, 67.768999999389052, 53.088999998755753, -11.301000000908971, 75.178999998606741, 64.918999998830259, 26.108999999240041, 1.3089999994263053, -33.861000001430511, -5.7510000010952353, -25.991000001318753, -44.17100000102073, -50.341000000946224, -43.051000000908971, -59.42100000102073, -66.001000001095235, -74.141000000759959, -68.651000000536442, -53.911000001244247, -142.4510000012815, -141.10100000072271, -107.94100000057369, -107.31100000068545, 103.28899999894202, 103.87899999879301, 21.368999999016523, 70.168999998830259, -67.831000001169741, -43.531000001356006, 138.46899999864399, 119.36899999901652, -2.7310000006109476, -128.53100000135601, 201.46899999864399, -180.53100000135601, 61.868999999016523, 95.068999999202788, -219.73100000061095, 239.11899999901652]

    if almaconf == 7:
        orig_x  =  [-0.94479999970644712, 10.555200000293553, 57.865200000233017, 23.505200000246987, 70.505200000246987, 69.555200000293553, 49.645200000260957, 44.09520000021439, 12.98520000022836, -8.3947999997762963, -28.164799999794923, -10.174799999804236, -54.034799999790266, -23.504799999762326, -37.534799999790266, -62.7347999997437, -70.334799999720417, -72.774799999780953, 6.7852000002749264, 17.245200000237674, 34.865200000233017, -47.644799999776296, -31.15479999978561, 12.585200000205077, 30.745200000237674, 62.715200000209734, 26.355200000223704, -25.65479999978561, -47.534799999790266, 59.48520000022836, 32.215200000209734, -20.924799999804236, 117.27520000026561, -106.92479999980424, -127.12479999975767, 140.47520000021905, -84.724799999734387, 122.87520000024233, -172.12479999975767, 135.37520000024233, -28.024799999780953, -104.62479999975767, 192.77520000026561, -191.3247999997111, 89.675200000288896, 64.245200000237674, -200.75479999976233, 243.24520000023767, -166.75479999976233, -3.7547999997623265]
        orig_y  =  [12.132400000467896, 32.782399999909103, -20.017599999904633, 60.802400000393391, -11.577599999494851, 3.6524000000208616, 50.842400000430644, 64.882400000467896, 90.782399999909103, -1.0175999999046326, 2.332400000654161, 72.162400000728667, -6.9075999995693564, 79.572399999946356, 69.312400000169873, 30.502400000579655, 5.7024000007659197, -29.467600000090897, -1.357599999755621, -21.597599999979138, -38.657599999569356, -55.027599999681115, -61.607599999755621, -69.747599999420345, -64.257599999196827, -49.517599999904633, -138.05759999994189, -136.70759999938309, -103.54759999923408, -102.91759999934584, 107.68240000028163, 108.27240000013262, 25.762400000356138, 74.562400000169873, -63.437599999830127, -39.137600000016391, 142.86239999998361, 123.76240000035614, 1.6624000007286668, -124.13760000001639, 205.86239999998361, -176.13760000001639, 66.262400000356138, 99.462400000542402, -215.33759999927133, 243.51240000035614, -135.48759999964386, -37.487599999643862, 218.51240000035614, -290.48759999964386]

    if almaconf == 8:
        orig_x =  [-3.4735999997938052, 8.0264000002061948, 20.976400000159629, 67.976400000159629, 67.026400000206195, 47.116400000173599, 41.566400000127032, 10.456400000141002, -10.923599999863654, -30.693599999882281, -56.563599999877624, -40.063599999877624, -65.263599999831058, -72.863599999807775, -75.303599999868311, 4.2564000001875684, 14.716400000150315, 32.336400000145659, -33.683599999872968, 10.056400000117719, 28.216400000150315, 60.186400000122376, 23.826400000136346, -28.183599999872968, -50.063599999877624, 56.956400000141002, 29.686400000122376, -23.453599999891594, 114.74640000017826, -109.45359999989159, -129.65359999984503, 137.94640000013169, -87.253599999821745, 120.34640000015497, -174.65359999984503, 132.84640000015497, -30.553599999868311, -107.15359999984503, 190.24640000017826, -193.85359999979846, 87.146400000201538, 61.716400000150315, -203.28359999984968, 240.71640000015032, -169.28359999984968, -6.2835999998496845, 181.71640000015032, -290.28359999984968, 239.71640000015032, -38.283599999849685]
        orig_y  =  [7.0252000009641051, 27.675200000405312, 55.695200000889599, -16.684799998998642, -1.4547999994829297, 45.735200000926852, 59.775200000964105, 85.675200000405312, -6.1247999994084239, -2.7747999988496304, -12.014799999073148, 64.205200000666082, 25.395200001075864, 0.59520000126212835, -34.574799999594688, -6.4647999992594123, -26.70479999948293, -43.764799999073148, -66.714799999259412, -74.854799998924136, -69.364799998700619, -54.624799999408424, -143.16479999944568, -141.81479999888688, -108.65479999873787, -108.02479999884963, 102.57520000077784, 103.16520000062883, 20.655200000852346, 69.455200000666082, -68.544799999333918, -44.244799999520183, 137.75520000047982, 118.65520000085235, -3.4447999987751245, -129.24479999952018, 200.75520000047982, -181.24479999952018, 61.155200000852346, 94.355200001038611, -220.44479999877512, 238.40520000085235, -140.59479999914765, -42.594799999147654, 213.40520000085235, -295.59479999914765, 226.40520000085235, -41.594799999147654, -165.59479999914765, 292.40520000085235]
        zoom_factor = 2.0
        orig_x = array(orig_x)/zoom_factor 
        orig_y = array(orig_y)/zoom_factor 

    if almaconf == 9:
        orig_x  =  [-3.6531999998260289, 7.8468000001739711, 20.796800000127405, 66.846800000173971, 41.386800000094809, 10.276800000108778, -11.103199999895878, -30.873199999914505, -56.743199999909848, -40.243199999909848, -73.043199999839999, -75.483199999900535, 4.0768000001553446, 14.536800000118092, 32.156800000113435, -33.863199999905191, 28.036800000118092, 60.006800000090152, 23.646800000104122, -28.363199999905191, -50.243199999909848, 56.776800000108778, 29.506800000090152, -23.633199999923818, 114.56680000014603, -109.63319999992382, -129.83319999987725, 137.76680000009947, -87.433199999853969, 120.16680000012275, -174.83319999987725, 132.66680000012275, -30.733199999900535, -107.33319999987725, 190.06680000014603, -194.03319999983069, 86.966800000169314, 61.536800000118092, -203.46319999988191, 240.53680000011809, -169.46319999988191, -6.4631999998819083, 181.53680000011809, -290.46319999988191, 239.53680000011809, -38.463199999881908, -88.463199999881908, 309.53680000011809, -339.46319999988191, 186.53680000011809]
        orig_y  =  [15.404600001871586, 36.054600001312792, 64.07460000179708, 6.924600001424551, 68.154600001871586, 94.054600001312792, 2.2546000014990568, 5.6046000020578504, -3.6353999981656671, 72.584600001573563, 8.9746000021696091, -26.195399998687208, 1.9146000016480684, -18.325399998575449, -35.385399998165667, -58.335399998351932, -60.985399997793138, -46.245399998500943, -134.7853999985382, -133.4353999979794, -100.27539999783039, -99.64539999794215, 110.95460000168532, 111.54460000153631, 29.034600001759827, 77.834600001573563, -60.165399998426437, -35.865399998612702, 146.1346000013873, 127.03460000175983, 4.9346000021323562, -120.8653999986127, 209.1346000013873, -172.8653999986127, 69.534600001759827, 102.73460000194609, -212.06539999786764, 246.78460000175983, -132.21539999824017, -34.215399998240173, 221.78460000175983, -287.21539999824017, 234.78460000175983, -33.215399998240173, -157.21539999824017, 300.78460000175983, -346.21539999824017, 153.78460000175983, 126.78460000175983, -340.21539999824017]

    if almaconf == 10:
        orig_x  =  [0.33880000002682209, 11.838800000026822, 24.788799999980256, 45.37879999994766, 14.26879999996163, -7.1112000000430271, -26.881200000061654, -52.751200000056997, -69.051199999987148, -71.491200000047684, 8.0688000000081956, 18.528799999970943, 36.148799999966286, 32.028799999970943, 27.638799999956973, -24.37120000005234, -46.251200000056997, 60.76879999996163, 33.498799999943003, -19.641200000070967, 118.55879999999888, -105.64120000007097, -125.8412000000244, 141.75879999995232, -83.441200000001118, 124.1587999999756, -170.8412000000244, 136.6587999999756, -26.741200000047684, -103.3412000000244, 194.05879999999888, -190.04119999997783, 90.958800000022165, 65.528799999970943, -199.47120000002906, 244.52879999997094, -165.47120000002906, -2.4712000000290573, 185.52879999997094, -286.47120000002906, 243.52879999997094, -34.471200000029057, -84.471200000029057, 313.52879999997094, -335.47120000002906, 190.52879999997094, 66.528799999970943, -290.47120000002906, 460.52879999997094, -367.47120000002906]
        orig_y  =  [4.5004000011831522, 25.150400000624359, 53.170400001108646, 57.250400001183152, 83.150400000624359, -8.6495999991893768, -5.2995999986305833, -14.539599998854101, -1.9295999985188246, -37.099599999375641, -8.9895999990403652, -29.229599999263883, -46.289599998854101, -71.889599998481572, -145.68959999922663, -144.33959999866784, -111.17959999851882, -110.54959999863058, 100.05040000099689, 100.64040000084788, 18.130400001071393, 66.930400000885129, -71.069599999114871, -46.769599999301136, 135.23040000069886, 116.13040000107139, -5.9695999985560775, -131.76959999930114, 198.23040000069886, -183.76959999930114, 58.630400001071393, 91.830400001257658, -222.96959999855608, 235.88040000107139, -143.11959999892861, -45.119599998928607, 210.88040000107139, -298.11959999892861, 223.88040000107139, -44.119599998928607, -168.11959999892861, 289.88040000107139, -357.11959999892861, 142.88040000107139, 115.88040000107139, -351.11959999892861, 410.88040000107139, -284.11959999892861, -28.119599998928607, 377.88040000107139]

    if almaconf == 11:
        orig_x  =  [-7.5483999999705702, 3.9516000000294298, 16.901599999982864, 37.491599999950267, -14.998400000040419, -34.768400000059046, -60.638400000054389, 0.18160000001080334, 10.64159999997355, 28.261599999968894, 19.751599999959581, -32.258400000049733, -54.138400000054389, 52.881599999964237, 25.611599999945611, -27.528400000068359, 110.67160000000149, -113.52840000006836, -133.72840000002179, 133.87159999995492, -91.32839999999851, 116.27159999997821, -178.72840000002179, 128.77159999997821, -34.628400000045076, -111.22840000002179, 186.17160000000149, -197.92839999997523, 83.071600000024773, 57.64159999997355, -207.35840000002645, 236.64159999997355, -173.35840000002645, -10.35840000002645, 177.64159999997355, -294.35840000002645, 235.64159999997355, -42.35840000002645, -92.35840000002645, 305.64159999997355, -343.35840000002645, 182.64159999997355, 58.64159999997355, -298.35840000002645, 452.64159999997355, -375.35840000002645, 39.64159999997355, 261.64159999997355, -477.35840000002645, 444.64159999997355]
        orig_y  =  [12.594600000418723, 33.244599999859929, 61.264600000344217, 65.344600000418723, -0.5553999999538064, 2.7946000006049871, -6.4453999996185303, -0.89539999980479479, -21.135400000028312, -38.19539999961853, -137.59539999999106, -136.24539999943227, -103.08539999928325, -102.45539999939501, 108.14460000023246, 108.73460000008345, 26.224600000306964, 75.024600000120699, -62.975399999879301, -38.675400000065565, 143.32459999993443, 124.22460000030696, 2.124600000679493, -123.67540000006557, 206.32459999993443, -175.67540000006557, 66.724600000306964, 99.924600000493228, -214.87539999932051, 243.97460000030696, -135.02539999969304, -37.025399999693036, 218.97460000030696, -290.02539999969304, 231.97460000030696, -36.025399999693036, -160.02539999969304, 297.97460000030696, -349.02539999969304, 150.97460000030696, 123.97460000030696, -343.02539999969304, 418.97460000030696, -276.02539999969304, -20.025399999693036, 385.97460000030696, -489.02539999969304, 425.97460000030696, -86.025399999693036, -251.02539999969304]

    if almaconf == 12:
        orig_x  =  [13.402800000039861, 26.352799999993294, -25.317200000048615, -51.187200000043958, 20.092799999983981, 37.712799999979325, 29.202799999970011, -22.807200000039302, -44.687200000043958, 62.332799999974668, 35.062799999956042, -18.077200000057928, 120.12280000001192, -104.07720000005793, -124.27720000001136, 143.32279999996535, -81.877199999988079, 125.72279999998864, -169.27720000001136, 138.22279999998864, -25.177200000034645, -101.77720000001136, 195.62280000001192, -188.4771999999648, 92.522800000035204, 67.092799999983981, -197.90720000001602, 246.09279999998398, -163.90720000001602, -0.90720000001601875, 187.09279999998398, -284.90720000001602, 245.09279999998398, -32.907200000016019, -82.907200000016019, 315.09279999998398, -333.90720000001602, 192.09279999998398, 68.092799999983981, -288.90720000001602, 462.09279999998398, -365.90720000001602, 49.092799999983981, 271.09279999998398, -467.90720000001602, 454.09279999998398, -194.90720000001602, -172.90720000001602, 499.09279999998398, -550.90720000001602]
        orig_y  =  [24.776400000788271, 52.796400001272559, -5.6735999984666705, -14.913599998690188, -29.60359999909997, -46.663599998690188, -146.06359999906272, -144.71359999850392, -111.55359999835491, -110.92359999846667, 99.6764000011608, 100.26640000101179, 17.756400001235306, 66.556400001049042, -71.443599998950958, -47.143599999137223, 134.85640000086278, 115.75640000123531, -6.3435999983921647, -132.14359999913722, 197.85640000086278, -184.14359999913722, 58.256400001235306, 91.456400001421571, -223.34359999839216, 235.50640000123531, -143.49359999876469, -45.493599998764694, 210.50640000123531, -298.49359999876469, 223.50640000123531, -44.493599998764694, -168.49359999876469, 289.50640000123531, -357.49359999876469, 142.50640000123531, 115.50640000123531, -351.49359999876469, 410.50640000123531, -284.49359999876469, -28.493599998764694, 377.50640000123531, -497.49359999876469, 417.50640000123531, -94.493599998764694, -259.49359999876469, 535.50640000123531, -587.49359999876469, 308.50640000123531, 209.50640000123531]
        zoom_factor = 4.0
        orig_x = array(orig_x)/zoom_factor 
        orig_y = array(orig_y)/zoom_factor

    if almaconf == 13:
        orig_x  =  [-1.0907999998889863, 11.859200000064448, -39.810799999977462, -65.680799999972805, 5.5992000000551343, 23.219200000050478, 14.709200000041164, -37.300799999968149, 20.569200000027195, -118.57079999998678, -138.77079999994021, 128.82920000003651, -96.370799999916926, 111.22920000005979, -183.77079999994021, 123.72920000005979, -39.670799999963492, -116.27079999994021, 181.12920000008307, -202.97079999989364, 78.029200000106357, 52.599200000055134, -212.40079999994487, 231.59920000005513, -178.40079999994487, -15.400799999944866, 172.59920000005513, -299.40079999994487, 230.59920000005513, -47.400799999944866, -97.400799999944866, 300.59920000005513, -348.40079999994487, 177.59920000005513, 53.599200000055134, -303.40079999994487, 447.59920000005513, -380.40079999994487, 34.599200000055134, 256.59920000005513, -482.40079999994487, 439.59920000005513, -209.40079999994487, -187.40079999994487, 484.59920000005513, -565.40079999994487, 458.59920000005513, 75.599200000055134, -433.40079999994487, 685.59920000005513]
        orig_y  =  [27.106800000183284, 55.126800000667572, -3.3431999990716577, -12.583199999295175, -27.273199999704957, -44.333199999295175, -143.7331999996677, -142.38319999910891, 102.00680000055581, 68.886800000444055, -69.113199999555945, -44.81319999974221, 137.18680000025779, 118.08680000063032, -4.0131999989971519, -129.81319999974221, 200.18680000025779, -181.81319999974221, 60.586800000630319, 93.786800000816584, -221.01319999899715, 237.83680000063032, -141.16319999936968, -43.163199999369681, 212.83680000063032, -296.16319999936968, 225.83680000063032, -42.163199999369681, -166.16319999936968, 291.83680000063032, -355.16319999936968, 144.83680000063032, 117.83680000063032, -349.16319999936968, 412.83680000063032, -282.16319999936968, -26.163199999369681, 379.83680000063032, -495.16319999936968, 419.83680000063032, -92.163199999369681, -257.16319999936968, 537.83680000063032, -585.16319999936968, 310.83680000063032, 211.83680000063032, -495.16319999936968, 784.83680000063032, -562.16319999936968, 60.836800000630319]

    if almaconf == 14:
        orig_x  =  [9.5600000000558794, 22.510000000009313, -29.160000000032596, -55.03000000002794, 16.25, 33.869999999995343, -26.650000000023283, 139.47999999998137, -85.71999999997206, 121.88000000000466, -173.11999999999534, 134.38000000000466, -29.020000000018626, -105.61999999999534, 191.78000000002794, -192.31999999994878, 88.680000000051223, 63.25, -201.75, 242.25, -167.75, -4.75, 183.25, -288.75, 241.25, -36.75, -86.75, 311.25, -337.75, 188.25, 64.25, -292.75, 458.25, -369.75, 45.25, 267.25, -471.75, 450.25, -198.75, -176.75, 495.25, -554.75, 469.25, 86.25, -422.75, 696.25, -526.75, 211.25, 374.25, -770.75]
        orig_y  =  [25.10080000013113, 53.120800000615418, -5.3491999991238117, -14.589199999347329, -29.279199999757111, -46.339199999347329, -144.38919999916106, -46.819199999794364, 135.18080000020564, 116.08080000057817, -6.0191999990493059, -131.81919999979436, 198.18080000020564, -183.81919999979436, 58.580800000578165, 91.78080000076443, -223.01919999904931, 235.83080000057817, -143.16919999942183, -45.169199999421835, 210.83080000057817, -298.16919999942183, 223.83080000057817, -44.169199999421835, -168.16919999942183, 289.83080000057817, -357.16919999942183, 142.83080000057817, 115.83080000057817, -351.16919999942183, 410.83080000057817, -284.16919999942183, -28.169199999421835, 377.83080000057817, -497.16919999942183, 417.83080000057817, -94.169199999421835, -259.16919999942183, 535.83080000057817, -587.16919999942183, 308.83080000057817, 209.83080000057817, -497.16919999942183, 782.83080000057817, -564.16919999942183, 58.830800000578165, 406.83080000057817, -834.16919999942183, 760.83080000057817, -283.16919999942183]

    if almaconf == 15:
        orig_x  =  [-7.4001999999163672, 5.5498000000370666, -46.120200000004843, -71.990200000000186, -0.71019999997224659, 16.909800000023097, -190.08019999996759, 117.41980000003241, -45.980199999990873, -122.58019999996759, 174.81980000005569, -209.28019999992102, 71.719800000078976, 46.289800000027753, -218.71019999997225, 225.28980000002775, -184.71019999997225, -21.710199999972247, 166.28980000002775, -305.71019999997225, 224.28980000002775, -53.710199999972247, -103.71019999997225, 294.28980000002775, -354.71019999997225, 171.28980000002775, 47.289800000027753, -309.71019999997225, 441.28980000002775, -386.71019999997225, 28.289800000027753, 250.28980000002775, -488.71019999997225, 433.28980000002775, -215.71019999997225, -193.71019999997225, 478.28980000002775, -571.71019999997225, 452.28980000002775, 69.289800000027753, -439.71019999997225, 679.28980000002775, -543.71019999997225, 194.28980000002775, 357.28980000002775, -787.71019999997225, 784.28980000002775, -444.71019999997225, -168.71019999997225, 758.28980000002775]
        orig_y  =  [21.835399999283254, 49.855399999767542, -8.6145999999716878, -17.854600000195205, -32.544600000604987, -49.604600000195205, -9.284599999897182, -135.08460000064224, 194.91539999935776, -187.08460000064224, 55.315399999730289, 88.515399999916553, -226.28459999989718, 232.56539999973029, -146.43460000026971, -48.434600000269711, 207.56539999973029, -301.43460000026971, 220.56539999973029, -47.434600000269711, -171.43460000026971, 286.56539999973029, -360.43460000026971, 139.56539999973029, 112.56539999973029, -354.43460000026971, 407.56539999973029, -287.43460000026971, -31.434600000269711, 374.56539999973029, -500.43460000026971, 414.56539999973029, -97.434600000269711, -262.43460000026971, 532.56539999973029, -590.43460000026971, 305.56539999973029, 206.56539999973029, -500.43460000026971, 779.56539999973029, -567.43460000026971, 55.565399999730289, 403.56539999973029, -837.43460000026971, 757.56539999973029, -286.43460000026971, -336.43460000026971, 853.56539999973029, -931.43460000026971, 624.56539999973029]

    if almaconf == 16:
        orig_x  =  [10.032200000016019, 22.982199999969453, -28.687800000072457, -54.5578000000678, 16.722199999960139, 34.342199999955483, 192.25219999998808, -191.84779999998864, 89.152200000011362, 63.722199999960139, -201.27780000003986, 242.72219999996014, -167.27780000003986, -4.2778000000398606, 183.72219999996014, -288.27780000003986, 241.72219999996014, -36.277800000039861, -86.277800000039861, 311.72219999996014, -337.27780000003986, 188.72219999996014, 64.722199999960139, -292.27780000003986, 458.72219999996014, -369.27780000003986, 45.722199999960139, 267.72219999996014, -471.27780000003986, 450.72219999996014, -198.27780000003986, -176.27780000003986, 495.72219999996014, -554.27780000003986, 469.72219999996014, 86.722199999960139, -422.27780000003986, 696.72219999996014, -526.27780000003986, 211.72219999996014, 374.72219999996014, -770.27780000003986, 801.72219999996014, -427.27780000003986, -151.27780000003986, 775.72219999996014, -1012.2778000000399, 779.72219999996014, -66.277800000039861, -744.27780000003986]
        orig_y  =  [31.359400000423193, 59.379400000907481, 0.90940000116825104, -8.3305999990552664, -23.020599999465048, -40.080599999055266, 64.839400000870228, 98.039400001056492, -216.76059999875724, 242.08940000087023, -136.91059999912977, -38.910599999129772, 217.08940000087023, -291.91059999912977, 230.08940000087023, -37.910599999129772, -161.91059999912977, 296.08940000087023, -350.91059999912977, 149.08940000087023, 122.08940000087023, -344.91059999912977, 417.08940000087023, -277.91059999912977, -21.910599999129772, 384.08940000087023, -490.91059999912977, 424.08940000087023, -87.910599999129772, -252.91059999912977, 542.08940000087023, -580.91059999912977, 315.08940000087023, 216.08940000087023, -490.91059999912977, 789.08940000087023, -557.91059999912977, 65.089400000870228, 413.08940000087023, -827.91059999912977, 767.08940000087023, -276.91059999912977, -326.91059999912977, 863.08940000087023, -921.91059999912977, 634.08940000087023, 127.08940000087023, -904.91059999912977, 1199.0894000008702, -995.91059999912977]
        zoom_factor = 5.0
        orig_x = array(orig_x)/zoom_factor
        orig_y = array(orig_y)/zoom_factor


    if almaconf == 17:
        orig_x  =  [-4.4451999999582767, -43.165200000046752, 2.2447999999858439, -206.32519999996293, 74.674800000037067, 49.244799999985844, -215.75520000001416, 228.24479999998584, -181.75520000001416, -18.755200000014156, 169.24479999998584, -302.75520000001416, 227.24479999998584, -50.755200000014156, -100.75520000001416, 297.24479999998584, -351.75520000001416, 174.24479999998584, 50.244799999985844, -306.75520000001416, 444.24479999998584, -383.75520000001416, 31.244799999985844, 253.24479999998584, -485.75520000001416, 436.24479999998584, -212.75520000001416, -190.75520000001416, 481.24479999998584, -568.75520000001416, 455.24479999998584, 72.244799999985844, -436.75520000001416, 682.24479999998584, -540.75520000001416, 197.24479999998584, 360.24479999998584, -784.75520000001416, 787.24479999998584, -441.75520000001416, -165.75520000001416, 761.24479999998584, -1026.7552000000142, 765.24479999998584, -80.755200000014156, -758.75520000001416, 1142.2447999999858, -120.75520000001416, 405.24479999998584, -565.75520000001416]
        orig_y  =  [25.568400000222027, -4.8815999990329146, -28.811599999666214, 92.248400000855327, -222.55159999895841, 236.29840000066906, -142.70159999933094, -44.701599999330938, 211.29840000066906, -297.70159999933094, 224.29840000066906, -43.701599999330938, -167.70159999933094, 290.29840000066906, -356.70159999933094, 143.29840000066906, 116.29840000066906, -350.70159999933094, 411.29840000066906, -283.70159999933094, -27.701599999330938, 378.29840000066906, -496.70159999933094, 418.29840000066906, -93.701599999330938, -258.70159999933094, 536.29840000066906, -586.70159999933094, 309.29840000066906, 210.29840000066906, -496.70159999933094, 783.29840000066906, -563.70159999933094, 59.298400000669062, 407.29840000066906, -833.70159999933094, 761.29840000066906, -282.70159999933094, -332.70159999933094, 857.29840000066906, -927.70159999933094, 628.29840000066906, 121.29840000066906, -910.70159999933094, 1193.2984000006691, -1001.7015999993309, 252.29840000066906, -549.70159999933094, 346.29840000066906, 293.29840000066906]

    if almaconf == 18:
        orig_x  =  [19.692000000039116, -19.02800000004936, 26.381999999983236, 252.38199999998324, -157.61800000001676, 5.3819999999832362, 193.38199999998324, -278.61800000001676, 251.38199999998324, -26.618000000016764, -76.618000000016764, 321.38199999998324, -327.61800000001676, 198.38199999998324, 74.381999999983236, -282.61800000001676, 468.38199999998324, -359.61800000001676, 55.381999999983236, 277.38199999998324, -461.61800000001676, 460.38199999998324, -188.61800000001676, -166.61800000001676, 505.38199999998324, -544.61800000001676, 479.38199999998324, 96.381999999983236, -412.61800000001676, 706.38199999998324, -516.61800000001676, 221.38199999998324, 384.38199999998324, -760.61800000001676, 811.38199999998324, -417.61800000001676, -141.61800000001676, 785.38199999998324, -1002.6180000000168, 789.38199999998324, -56.618000000016764, -734.61800000001676, 1166.3819999999832, -1088.6180000000168, 417.38199999998324, 501.38199999998324, -1238.6180000000168, -96.618000000016764, 429.38199999998324, -541.61800000001676]
        orig_y  =  [21.970399999059737, -8.4796000001952052, -32.409600000828505, -48.299600000493228, 207.70039999950677, -301.29960000049323, 220.70039999950677, -47.299600000493228, -171.29960000049323, 286.70039999950677, -360.29960000049323, 139.70039999950677, 112.70039999950677, -354.29960000049323, 407.70039999950677, -287.29960000049323, -31.299600000493228, 374.70039999950677, -500.29960000049323, 414.70039999950677, -97.299600000493228, -262.29960000049323, 532.70039999950677, -590.29960000049323, 305.70039999950677, 206.70039999950677, -500.29960000049323, 779.70039999950677, -567.29960000049323, 55.700399999506772, 403.70039999950677, -837.29960000049323, 757.70039999950677, -286.29960000049323, -336.29960000049323, 853.70039999950677, -931.29960000049323, 624.70039999950677, 117.70039999950677, -914.29960000049323, 1189.7003999995068, -1005.2996000004932, 248.70039999950677, 732.70039999950677, -1250.2996000004932, 1354.7003999995068, -708.29960000049323, -553.29960000049323, 342.70039999950677, 289.70039999950677]

    if almaconf == 19:
        orig_x  =  [-5.447999999858439, -44.167999999946915, 1.2420000000856817, -303.75799999991432, 226.24200000008568, -51.757999999914318, -101.75799999991432, 296.24200000008568, -352.75799999991432, 173.24200000008568, 49.242000000085682, -307.75799999991432, 443.24200000008568, -384.75799999991432, 30.242000000085682, 252.24200000008568, -486.75799999991432, 435.24200000008568, -213.75799999991432, -191.75799999991432, 480.24200000008568, -569.75799999991432, 454.24200000008568, 71.242000000085682, -437.75799999991432, 681.24200000008568, -541.75799999991432, 196.24200000008568, 359.24200000008568, -785.75799999991432, 786.24200000008568, -442.75799999991432, -166.75799999991432, 760.24200000008568, -1027.7579999999143, 764.24200000008568, -81.757999999914318, -759.75799999991432, 1141.2420000000857, -1113.7579999999143, 392.24200000008568, 476.24200000008568, -1263.7579999999143, 1254.2420000000857, -854.75799999991432, -120.75799999991432, 1171.2420000000857, -121.75799999991432, 404.24200000008568, -566.75799999991432]
        orig_y  =  [13.050399999134243, -17.399600000120699, -41.329600000753999, -56.219600000418723, -180.21960000041872, 277.78039999958128, -369.21960000041872, 130.78039999958128, 103.78039999958128, -363.21960000041872, 398.78039999958128, -296.21960000041872, -40.219600000418723, 365.78039999958128, -509.21960000041872, 405.78039999958128, -106.21960000041872, -271.21960000041872, 523.78039999958128, -599.21960000041872, 296.78039999958128, 197.78039999958128, -509.21960000041872, 770.78039999958128, -576.21960000041872, 46.780399999581277, 394.78039999958128, -846.21960000041872, 748.78039999958128, -295.21960000041872, -345.21960000041872, 844.78039999958128, -940.21960000041872, 615.78039999958128, 108.78039999958128, -923.21960000041872, 1180.7803999995813, -1014.2196000004187, 239.78039999958128, 723.78039999958128, -1259.2196000004187, 1345.7803999995813, -717.21960000041872, -385.21960000041872, 1250.7803999995813, -1586.2196000004187, 1209.7803999995813, -562.21960000041872, 333.78039999958128, 280.78039999958128]

    if almaconf == 20:
        orig_x  =  [27.852000000071712, -10.868000000016764, 34.542000000015832, 329.54200000001583, -319.45799999998417, 206.54200000001583, 82.542000000015832, -274.45799999998417, 476.54200000001583, -351.45799999998417, 63.542000000015832, 285.54200000001583, -453.45799999998417, 468.54200000001583, -180.45799999998417, -158.45799999998417, 513.54200000001583, -536.45799999998417, 487.54200000001583, 104.54200000001583, -404.45799999998417, 714.54200000001583, -508.45799999998417, 229.54200000001583, 392.54200000001583, -752.45799999998417, 819.54200000001583, -409.45799999998417, -133.45799999998417, 793.54200000001583, -994.45799999998417, 797.54200000001583, -48.457999999984168, -726.45799999998417, 1174.5420000000158, -1080.4579999999842, 425.54200000001583, 509.54200000001583, -1230.4579999999842, 1287.5420000000158, -821.45799999998417, -87.457999999984168, 1204.5420000000158, -1649.4579999999842, 1404.5420000000158, -384.45799999998417, -1133.4579999999842, -88.457999999984168, 437.54200000001583, -533.45799999998417]
        orig_y  =  [14.590399999171495, -15.859600000083447, -39.789600000716746, 132.32039999961853, 105.32039999961853, -361.67960000038147, 400.32039999961853, -294.67960000038147, -38.67960000038147, 367.32039999961853, -507.67960000038147, 407.32039999961853, -104.67960000038147, -269.67960000038147, 525.32039999961853, -597.67960000038147, 298.32039999961853, 199.32039999961853, -507.67960000038147, 772.32039999961853, -574.67960000038147, 48.32039999961853, 396.32039999961853, -844.67960000038147, 750.32039999961853, -293.67960000038147, -343.67960000038147, 846.32039999961853, -938.67960000038147, 617.32039999961853, 110.32039999961853, -921.67960000038147, 1182.3203999996185, -1012.6796000003815, 241.32039999961853, 725.32039999961853, -1257.6796000003815, 1347.3203999996185, -715.67960000038147, -383.67960000038147, 1252.3203999996185, -1584.6796000003815, 1211.3203999996185, -99.67960000038147, -1193.6796000003815, 2037.3203999996185, -1142.6796000003815, -560.67960000038147, 335.32039999961853, 282.32039999961853]
        zoom_factor = 8.0
        orig_x = array(orig_x)/zoom_factor 
        orig_y = array(orig_y)/zoom_factor 

    if almaconf == 21:
        orig_x  =  [-337.29800000006799, 188.70199999993201, 64.701999999932013, -292.29800000006799, 458.70199999993201, -369.29800000006799, 45.701999999932013, 267.70199999993201, -471.29800000006799, 450.70199999993201, -198.29800000006799, -176.29800000006799, 495.70199999993201, -554.29800000006799, 469.70199999993201, 86.701999999932013, -422.29800000006799, 696.70199999993201, -526.29800000006799, 211.70199999993201, 374.70199999993201, -770.29800000006799, 801.70199999993201, -427.29800000006799, -151.29800000006799, 775.70199999993201, -1012.298000000068, 779.70199999993201, -66.298000000067987, -744.29800000006799, 1156.701999999932, -1098.298000000068, 407.70199999993201, 491.70199999993201, -1248.298000000068, 1269.701999999932, -839.29800000006799, -105.29800000006799, 1186.701999999932, -1667.298000000068, 1386.701999999932, -402.29800000006799, -1151.298000000068, -106.29800000006799, 419.70199999993201, -551.29800000006799, 2329.701999999932, -1132.1980000000913, -3020.298000000068, 3024.5019999999786]
        orig_y  =  [-101.26599999889731, -568.26599999889731, 193.73400000110269, -501.26599999889731, -245.26599999889731, 160.73400000110269, -714.26599999889731, 200.73400000110269, -311.26599999889731, -476.26599999889731, 318.73400000110269, -804.26599999889731, 91.734000001102686, -7.2659999988973141, -714.26599999889731, 565.73400000110269, -781.26599999889731, -158.26599999889731, 189.73400000110269, -1051.2659999988973, 543.73400000110269, -500.26599999889731, -550.26599999889731, 639.73400000110269, -1145.2659999988973, 410.73400000110269, -96.265999998897314, -1128.2659999988973, 975.73400000110269, -1219.2659999988973, 34.734000001102686, 518.73400000110269, -1464.2659999988973, 1140.7340000011027, -922.26599999889731, -590.26599999889731, 1045.7340000011027, -1791.2659999988973, 1004.7340000011027, -306.26599999889731, -1400.2659999988973, 1830.7340000011027, -1349.2659999988973, -767.26599999889731, 128.73400000110269, 75.734000001102686, 1983.7340000011027, 3331.6340000014752, 1860.7340000011027, 2418.1340000014752]

    if almaconf == 22:
        orig_x  =  [318.19599999999627, -509.80400000000373, -94.804000000003725, 127.19599999999627, -611.80400000000373, 310.19599999999627, -338.80400000000373, -316.80400000000373, 355.19599999999627, -694.80400000000373, 329.19599999999627, -53.804000000003725, -562.80400000000373, 556.19599999999627, -666.80400000000373, 71.195999999996275, 234.19599999999627, -910.80400000000373, 661.19599999999627, -567.80400000000373, -291.80400000000373, 635.19599999999627, -1152.8040000000037, 639.19599999999627, -206.80400000000373, -884.80400000000373, 1016.1959999999963, -1238.8040000000037, 267.19599999999627, 351.19599999999627, -1388.8040000000037, 1129.1959999999963, -979.80400000000373, -245.80400000000373, 1046.1959999999963, -1807.8040000000037, 1246.1959999999963, -542.80400000000373, -1291.8040000000037, -246.80400000000373, 279.19599999999627, -691.80400000000373, 2189.1959999999963, -1272.704000000027, -3160.8040000000037, 2883.9960000000428, 1558.3959999999497, -2863.1040000000503, 3802.5960000000196, 3589.1959999999963]
        orig_y  =  [-241.9679999994114, 164.0320000005886, -710.9679999994114, 204.0320000005886, -307.9679999994114, -472.9679999994114, 322.0320000005886, -800.9679999994114, 95.032000000588596, -3.9679999994114041, -710.9679999994114, 569.0320000005886, -777.9679999994114, -154.9679999994114, 193.0320000005886, -1047.9679999994114, 547.0320000005886, -496.9679999994114, -546.9679999994114, 643.0320000005886, -1141.9679999994114, 414.0320000005886, -92.967999999411404, -1124.9679999994114, 979.0320000005886, -1215.9679999994114, 38.032000000588596, 522.0320000005886, -1460.9679999994114, 1144.0320000005886, -918.9679999994114, -586.9679999994114, 1049.0320000005886, -1787.9679999994114, 1008.0320000005886, -302.9679999994114, -1396.9679999994114, 1834.0320000005886, -1345.9679999994114, -763.9679999994114, 132.0320000005886, 79.032000000588596, 1987.0320000005886, 3334.9320000009611, 1864.0320000005886, 2421.4320000009611, -2900.7679999992251, 1900.3320000004023, -2160.3679999997839, 2032.0320000005886]

    if almaconf == 23:
        orig_x  =  [-730.52199999999721, 191.47800000000279, -457.52199999999721, -435.52199999999721, 236.47800000000279, -813.52199999999721, 210.47800000000279, -172.52199999999721, -681.52199999999721, 437.47800000000279, -785.52199999999721, -47.521999999997206, 115.47800000000279, -1029.5219999999972, 542.47800000000279, -686.52199999999721, -410.52199999999721, 516.47800000000279, -1271.5219999999972, 520.47800000000279, -325.52199999999721, -1003.5219999999972, 897.47800000000279, -1357.5219999999972, 148.47800000000279, 232.47800000000279, -1507.5219999999972, 1010.4780000000028, -1098.5219999999972, -364.52199999999721, 927.47800000000279, -1926.5219999999972, 1127.4780000000028, -661.52199999999721, -1410.5219999999972, -365.52199999999721, 160.47800000000279, -810.52199999999721, 2070.4780000000028, -1391.4220000000205, -3279.5219999999972, 2765.2780000000494, 1439.6779999999562, -2981.8220000000438, 3683.8780000000261, 3470.4780000000028, -5010.5219999999972, 3225.3780000000261, 3506.2780000000494, 3580.6779999999562]
        orig_y  =  [-378.3879999993369, -543.3879999993369, 251.6120000006631, -871.3879999993369, 24.612000000663102, -74.387999999336898, -781.3879999993369, 498.6120000006631, -848.3879999993369, -225.3879999993369, 122.6120000006631, -1118.3879999993369, 476.6120000006631, -567.3879999993369, -617.3879999993369, 572.6120000006631, -1212.3879999993369, 343.6120000006631, -163.3879999993369, -1195.3879999993369, 908.6120000006631, -1286.3879999993369, -32.387999999336898, 451.6120000006631, -1531.3879999993369, 1073.6120000006631, -989.3879999993369, -657.3879999993369, 978.6120000006631, -1858.3879999993369, 937.6120000006631, -373.3879999993369, -1467.3879999993369, 1763.6120000006631, -1416.3879999993369, -834.3879999993369, 61.612000000663102, 8.6120000006631017, 1916.6120000006631, 3264.5120000010356, 1793.6120000006631, 2351.0120000010356, -2971.1879999991506, 1829.9120000004768, -2230.7879999997094, 1961.6120000006631, 1608.6120000006631, -6381.6879999991506, 5040.1120000006631, 2387.4120000004768]

    if almaconf == 24:
        orig_x  =  [-748.67799999995623, -76.677999999956228, -1126.6779999999562, -485.67799999995623, -994.67799999995623, 124.32200000004377, -1098.6779999999562, -360.67799999995623, -197.67799999995623, -1342.6779999999562, 229.32200000004377, -999.67799999995623, -723.67799999995623, 203.32200000004377, -1584.6779999999562, 207.32200000004377, -638.67799999995623, -1316.6779999999562, 584.32200000004377, -1670.6779999999562, -164.67799999995623, -80.677999999956228, -1820.6779999999562, 697.32200000004377, -1411.6779999999562, -677.67799999995623, 614.32200000004377, -2239.6779999999562, 814.32200000004377, -974.67799999995623, -1723.6779999999562, -678.67799999995623, -152.67799999995623, -1123.6779999999562, 1757.3220000000438, -1704.5779999999795, -3592.6779999999562, 2452.1220000000903, 1126.5219999999972, -3294.9780000000028, 3370.7220000000671, 3157.3220000000438, -5323.6779999999562, 2912.2220000000671, 3193.1220000000903, 3267.5219999999972, 2905.9220000000205, 3414.3220000000438, 4304.5219999999972, 2994.3220000000438]
        orig_y  =  [-912.18999999854714, -16.189999998547137, -115.18999999854714, 457.81000000145286, -889.18999999854714, -266.18999999854714, 81.810000001452863, -1159.1899999985471, 435.81000000145286, -608.18999999854714, -658.18999999854714, 531.81000000145286, -1253.1899999985471, 302.81000000145286, -204.18999999854714, -1236.1899999985471, 867.81000000145286, -1327.1899999985471, -73.189999998547137, 410.81000000145286, -1572.1899999985471, 1032.8100000014529, -1030.1899999985471, -698.18999999854714, 937.81000000145286, -1899.1899999985471, 896.81000000145286, -414.18999999854714, -1508.1899999985471, 1722.8100000014529, -1457.1899999985471, -875.18999999854714, 20.810000001452863, -32.189999998547137, 1875.8100000014529, 3223.7100000018254, 1752.8100000014529, 2310.2100000018254, -3011.9899999983609, 1789.1100000012666, -2271.5899999989197, 1920.8100000014529, 1567.8100000014529, -6422.4899999983609, 4999.3100000014529, 2346.6100000012666, -2455.2899999981746, 2888.8100000014529, -2288.9899999983609, 2280.8100000014529]

    if almaconf == 25:
        orig_x  =  [-700.64399999985471, -28.643999999854714, -1078.6439999998547, -312.64399999985471, -149.64399999985471, -1294.6439999998547, 277.35600000014529, -951.64399999985471, -675.64399999985471, 251.35600000014529, -1536.6439999998547, 255.35600000014529, -590.64399999985471, -1268.6439999998547, 632.35600000014529, -1622.6439999998547, -116.64399999985471, -32.643999999854714, -1772.6439999998547, 745.35600000014529, -1363.6439999998547, -629.64399999985471, 662.35600000014529, -2191.6439999998547, 862.35600000014529, -926.64399999985471, -1675.6439999998547, -630.64399999985471, -104.64399999985471, -1075.6439999998547, 1805.3560000001453, -1656.543999999878, -3544.6439999998547, 2500.1560000001919, 1174.5560000000987, -3246.9439999999013, 3418.7560000001686, 3205.3560000001453, -5275.6439999998547, 2960.2560000001686, 3241.1560000001919, 3315.5560000000987, 2953.956000000122, 3462.3560000001453, 4352.5560000000987, 3042.3560000001453, 4769.8560000001453, -2155.7439999998314, -2413.7439999998314, -4864.6439999998547]
        orig_y  =  [-1265.2760000005364, -369.27600000053644, -468.27600000053644, -1512.2760000005364, 82.723999999463558, -961.27600000053644, -1011.2760000005364, 178.72399999946356, -1606.2760000005364, -50.276000000536442, -557.27600000053644, -1589.2760000005364, 514.72399999946356, -1680.2760000005364, -426.27600000053644, 57.723999999463558, -1925.2760000005364, 679.72399999946356, -1383.2760000005364, -1051.2760000005364, 584.72399999946356, -2252.2760000005364, 543.72399999946356, -767.27600000053644, -1861.2760000005364, 1369.7239999994636, -1810.2760000005364, -1228.2760000005364, -332.27600000053644, -385.27600000053644, 1522.7239999994636, 2870.6239999998361, 1399.7239999994636, 1957.1239999998361, -3365.0760000003502, 1436.0239999992773, -2624.676000000909, 1567.7239999994636, 1214.7239999994636, -6775.5760000003502, 4646.2239999994636, 1993.5239999992773, -2808.3760000001639, 2535.7239999994636, -2642.0760000003502, 1927.7239999994636, 7554.0239999992773, 3328.5239999992773, 3456.9239999996498, 1286.7239999994636]

    if almaconf == 26:
        orig_x  =  [-1014.8339999999152, -342.83399999991525, -1392.8339999999152, -1265.8339999999152, -989.83399999991525, -62.83399999991525, -1850.8339999999152, -58.83399999991525, -904.83399999991525, -1582.8339999999152, 318.16600000008475, -1936.8339999999152, -430.83399999991525, -346.83399999991525, -2086.8339999999152, 431.16600000008475, -1677.8339999999152, -943.83399999991525, 348.16600000008475, -2505.8339999999152, 548.16600000008475, -1240.8339999999152, -1989.8339999999152, -944.83399999991525, -418.83399999991525, -1389.8339999999152, 1491.1660000000848, -1970.7339999999385, -3858.8339999999152, 2185.9660000001313, 860.36600000003818, -3561.1339999999618, 3104.566000000108, 2891.1660000000848, -5589.8339999999152, 2646.066000000108, 2926.9660000001313, 3001.3660000000382, 2639.7660000000615, 3148.1660000000848, 4038.3660000000382, 2728.1660000000848, 4455.6660000000848, -2469.933999999892, -2727.933999999892, -5178.8339999999152, 1548.1660000000848, 3549.566000000108, 4525.1660000000848, 3350.2660000000615]
        orig_y  =  [-1231.6420000009239, -335.64200000092387, -434.64200000092387, 212.35799999907613, -1572.6420000009239, -16.642000000923872, -523.64200000092387, -1555.6420000009239, 548.35799999907613, -1646.6420000009239, -392.64200000092387, 91.357999999076128, -1891.6420000009239, 713.35799999907613, -1349.6420000009239, -1017.6420000009239, 618.35799999907613, -2218.6420000009239, 577.35799999907613, -733.64200000092387, -1827.6420000009239, 1403.3579999990761, -1776.6420000009239, -1194.6420000009239, -298.64200000092387, -351.64200000092387, 1556.3579999990761, 2904.2579999994487, 1433.3579999990761, 1990.7579999994487, -3331.4420000007376, 1469.6579999988899, -2591.0420000012964, 1601.3579999990761, 1248.3579999990761, -6741.9420000007376, 4679.8579999990761, 2027.1579999988899, -2774.7420000005513, 2569.3579999990761, -2608.4420000007376, 1961.3579999990761, 7587.6579999988899, 3362.1579999988899, 3490.5579999992624, 1320.3579999990761, -4939.5420000012964, 2871.5579999992624, -6060.6420000009239, 3179.3579999990761]

    if almaconf == 27:
        orig_x  =  [-942.7599999998929, -270.7599999998929, -1320.7599999998929, 13.240000000107102, -832.7599999998929, -1510.7599999998929, 390.2400000001071, -1864.7599999998929, -358.7599999998929, -274.7599999998929, -2014.7599999998929, 503.2400000001071, -1605.7599999998929, -871.7599999998929, 420.2400000001071, -2433.7599999998929, 620.2400000001071, -1168.7599999998929, -1917.7599999998929, -872.7599999998929, -346.7599999998929, -1317.7599999998929, 1563.2400000001071, -1898.6599999999162, -3786.7599999998929, 2258.0400000001537, 932.44000000006054, -3489.0599999999395, 3176.6400000001304, 2963.2400000001071, -5517.7599999998929, 2718.1400000001304, 2999.0400000001537, 3073.4400000000605, 2711.8400000000838, 3220.2400000001071, 4110.4400000000605, 2800.2400000001071, 4527.7400000001071, -2397.8599999998696, -2655.8599999998696, -5106.7599999998929, 1620.2400000001071, 3621.6400000001304, 4597.2400000001071, 3422.3400000000838, -7252.3599999998696, 2557.1400000001304, 4184.2400000001071, -6973.7599999998929]
        orig_y  =  [-1303.0240000002086, -407.02400000020862, -506.02400000020862, -1627.0240000002086, 476.97599999979138, -1718.0240000002086, -464.02400000020862, 19.975999999791384, -1963.0240000002086, 641.97599999979138, -1421.0240000002086, -1089.0240000002086, 546.97599999979138, -2290.0240000002086, 505.97599999979138, -805.02400000020862, -1899.0240000002086, 1331.9759999997914, -1848.0240000002086, -1266.0240000002086, -370.02400000020862, -423.02400000020862, 1484.9759999997914, 2832.8760000001639, 1361.9759999997914, 1919.3760000001639, -3402.8240000000224, 1398.2759999996051, -2662.4240000005811, 1529.9759999997914, 1176.9759999997914, -6813.3240000000224, 4608.4759999997914, 1955.7759999996051, -2846.1239999998361, 2497.9759999997914, -2679.8240000000224, 1889.9759999997914, 7516.2759999996051, 3290.7759999996051, 3419.1759999999776, 1248.9759999997914, -5010.9240000005811, 2800.1759999999776, -6132.0240000002086, 3107.9759999997914, 1149.8760000001639, -6029.1239999998361, 5734.2759999996051, 527.97599999979138]

    if almaconf == 28:
        orig_x  =  [-1080.9379999998491, -408.93799999984913, -1458.9379999998491, -2002.9379999998491, -496.93799999984913, -412.93799999984913, -2152.9379999998491, 365.06200000015087, -1743.9379999998491, -1009.9379999998491, 282.06200000015087, -2571.9379999998491, 482.06200000015087, -1306.9379999998491, -2055.9379999998491, -1010.9379999998491, -484.93799999984913, -1455.9379999998491, 1425.0620000001509, -2036.8379999998724, -3924.9379999998491, 2119.8620000001974, 794.26200000010431, -3627.2379999998957, 3038.4620000001742, 2825.0620000001509, -5655.9379999998491, 2579.9620000001742, 2860.8620000001974, 2935.2620000001043, 2573.6620000001276, 3082.0620000001509, 3972.2620000001043, 2662.0620000001509, 4389.5620000001509, -2536.0379999998258, -2794.0379999998258, -5244.9379999998491, 1482.0620000001509, 3483.4620000001742, 4459.0620000001509, 3284.1620000001276, -7390.5379999998258, 2418.9620000001742, 4046.0620000001509, -7111.9379999998491, 3007.0620000001509, 5366.0620000001509, -8570.9379999998491, 4613.9620000001742]
        orig_y  =  [-1497.9539999999106, -601.95399999991059, -700.95399999991059, -174.95399999991059, -2157.9539999999106, 447.04600000008941, -1615.9539999999106, -1283.9539999999106, 352.04600000008941, -2484.9539999999106, 311.04600000008941, -999.95399999991059, -2093.9539999999106, 1137.0460000000894, -2042.9539999999106, -1460.9539999999106, -564.95399999991059, -617.95399999991059, 1290.0460000000894, 2637.9460000004619, 1167.0460000000894, 1724.4460000004619, -3597.7539999997243, 1203.3459999999031, -2857.3540000002831, 1335.0460000000894, 982.04600000008941, -7008.2539999997243, 4413.5460000000894, 1760.8459999999031, -3041.0539999995381, 2303.0460000000894, -2874.7539999997243, 1695.0460000000894, 7321.3459999999031, 3095.8459999999031, 3224.2460000002757, 1054.0460000000894, -5205.8540000002831, 2605.2460000002757, -6326.9539999999106, 2913.0460000000894, 954.94600000046194, -6224.0539999995381, 5539.3459999999031, 333.04600000008941, 3756.3459999999031, -6675.9539999999106, -328.95399999991059, 8883.2460000002757]
        

    addfactor = 300 # to put in centre of grid
    orig_x = np.array(orig_x) + addfactor
    orig_y = np.array(orig_y) + addfactor
    BALLS=len(orig_x)
    balltext = str(BALLS) + " ant.   "
    update_status(4)
    build_balls()
    draw()
    print_out() #update output.dat
    ImageGrab.grab((0,0, 1000 , 1000)).save('viewoutput.jpg')


def define_spiral():
    global BALLS, orig_x, orig_y, configmsg, balltext,synthesis_type, zoom_factor
    if BALLS == 1:
        BALLS=2

    if zoom_factor > 2:
            zoom_factor = 1
            
    configmsg = "Spiral with "
    #print "SPIRAL\n\n" #-- Spiral --#
    orig_x=[ 320, 300, 449, 357, 77, 267, 314, 219, 434, 175, 270, 314, 328, 449, 277, 218, 266, 435, 375, 210, 300, 300, 283, 355, 349, 338, 337, 287, 234, 270, 120, 238, 292, 238, 276, 409, 267, 402, 318, 300, 277, 340, 320, 308, 355, 210, 349, 254, 300, 53, 320]
    orig_y=[ 300, 184, 300, 473.5971559071, 373, 300, 257, 241, 397, 472, 279, 319, 262, 348, 370, 327, 195, 256, 196, 271, 326, 257, 323, 318, 284, 184, 351, 262, 348, 310, 431, 215, 326, 492, 318, 221, 289, 440, 313, 492, 269, 271, 306, 323, 300, 300, 335, 363, 370, 300, 300]
    synthesis_type=0
    build_balls()
    draw()
    print_out() #update output.dat
    balltext = str(len(balls)) + " ant.   "
    update_status(4)
        
def define_yshape():
    global configmsg, BALLS, orig_x, orig_y, balltext,synthesis_type, zoom_factor
    if BALLS == 1:
        BALLS=2

    if zoom_factor > 2:
            zoom_factor = 1
            
    configmsg = "YShape with "
    #-- Y --#     #print "YSHAPE\n\n"
    orig_x=[ 300, 300, 370, 214, 324, 450, 274, 166, 300, 300, 315, 489, 345, 532, 300, 300, 241, 300, 283, 300, 183, 300, 300, 301, 109, 357, 66, 384, 129, 415, 300, 334, 399, 510, 469, 297, 291, 300, 300, 300, 300, 264, 253, 300, 199, 307, 300, 148, 432, 228, 88, 450]
    orig_y=[ 300, 370, 230, 214, 276, 150, 274, 166, 432, 532, 285, 111, 255, 68, 307, 324, 241, 345, 283, 399, 183, 469, 510, 299, 109, 243, 66, 216, 129, 185, 415, 266, 201, 90, 131, 297, 291, 315, 357, 334, 450, 264, 253, 489, 199, 293, 384, 148, 168, 228, 88, 150]
    synthesis_type=0
    build_balls()
    draw()
    print_out()
    balltext = str(len(balls)) + " ant.    "
    update_status(4)
        
def define_line():
    global configmsg, BALLS, orig_x, orig_y, balltext,synthesis_type, zoom_factor
    if BALLS == 1:
        BALLS=2

    if zoom_factor > 2:
            zoom_factor = 1
        
    configmsg = "Line with "
    #print "LINE\n\n" #-- LINE --#
    orig_x=[ 50, 190, 300, 400, 550, 120, 240, 350, 460, 520, 80, 270, 490, 160, 330, 430, 540, 380, 220, 100, 420, 140, 510, 290, 60, 260, 320, 200, 470, 170, 360, 70, 530, 90, 500, 110, 480, 130, 450, 150, 440, 180, 390, 210, 410, 230, 370, 250, 280, 340, 310]
    orig_y=[ 50, 190, 300, 400, 550, 120, 240, 350, 460, 520, 80, 270, 490, 160, 330, 430, 540, 380, 220, 100, 420, 140, 510, 290, 60, 260, 320, 200, 470, 170, 360, 70, 530, 90, 500, 110, 480, 130, 450, 150, 440, 180, 390, 210, 410, 230, 370, 250, 280, 340, 310]
    synthesis_type=0
    build_balls()
    draw()
    print_out() #update output.dat
    balltext = str(len(balls)) + " ant.    "
    update_status(4)

def add_ball():
    global BALLS, balltext,synthesis_type,add_min
    OLD_BALLS=BALLS
    add_min=1
    BALLS=BALLS+1
    if BALLS==1:
        synthesis_type=2
    elif BALLS==0:
        statusmsg = "Minimum Antennas = 1"
        update_status(3)
        BALLS=1
        synthesis_type=2
    elif BALLS==51:
        statusmsg = "Minimum Antennas = 50"
        update_status(3)
        BALLS=50
        synthesis_type=synthesis_type
    else:
        if OLD_BALLS ==1:
            synthesis_type=0
        else:
            synthesis_type=synthesis_type
        
    balltext = str(BALLS) + " ant.       " #extra padding for 5
    update_status(4)
    build_balls()
    draw()
    print_out() #update output.dat

def min_ball():
    global BALLS, balltext,synthesis_type,add_min,status_msg
    add_min=1
    BALLS=BALLS-1
    if BALLS==1:
        synthesis_type=2
    elif BALLS==0:
        statusmsg = "Minimum Antennas = 1"
        update_status(3)
        BALLS=1
        synthesis_type=2
    elif BALLS==51:
        statusmsg = "Minimum Antennas = 50"
        update_status(3)
        BALLS=50
        synthesis_type=synthesis_type
    else:
        synthesis_type=synthesis_type

    
    balltext = str(BALLS) + " ant.       " #extra padding for 5
    update_status(4)
    build_balls()
    draw()
    print_out() #update output.dat

def ants_5():
    global BALLS, balltext,synthesis_type
    if synthesis_type==2:
        synthesis_type=0
    else:
        synthesis_type=synthesis_type
        
    BALLS=5
    balltext = str(BALLS) + " ant.       " #extra padding for 5
    update_status(4)
    build_balls()
    draw()
    print_out() #update output.dat


def ants_10():
    global BALLS, balltext,synthesis_type
    if synthesis_type==2:
        synthesis_type=0
    else:
        synthesis_type=synthesis_type
    BALLS=10
    balltext = str(BALLS) + " ant.  "
    update_status(4)
    build_balls()
    draw()
    print_out() #update output.dat


def ants_30():
    global BALLS, balltext,synthesis_type
    if synthesis_type==2:
        synthesis_type=0
    else:
        synthesis_type=synthesis_type
    BALLS=30
    balltext = str(BALLS) + " ant.   "
    update_status(4)
    build_balls()
    draw()
    print_out() #update output.dat


def ants_66(): #implement full ALMA?
    global BALLS, balltext
    BALLS=66
    balltext = str(BALLS) + " ant."
    update_status(4)
    build_balls()
    draw()
    print_out() #update output.dat


def use_webcam():
    ''' Connect to the webcam and process the image '''
    global filenamein, col_map
    filenamein = "input.png"
    # Camera 0 is the integrated web cam on my netbook
    camera_port = 0
    # FPS to use when ramping the camera
    fps = 30
    # Number of frames to take during camera ramp
    num_frames = 30
    # set up the camera with CaptureFromCAM() and index to a camera port. 
    camera = cv.CaptureFromCAM(camera_port)
    # camera needs to capture a few frames to adjust to ambient light levels. 
    while num_frames > 0:
    # Don't need to actually save these images
      im = cv.QueryFrame(camera)
      num_frames = num_frames - 1
      time.sleep(1/fps)

    camera_capture = cv.QueryFrame(camera)
    file = "inputted.png"
    cv.SaveImage(file, camera_capture)
    # release the camera, otherwise you won't be able to create a new 
    # capture object until your script exits
    del(camera)
    filenamein='inputted.png'

def use_aips():
    global filenamein
    filenamein = "aips.png"
    size=int(WIDTH_IMGS), int(HEIGHT_IMGS)
    im = Image.open(filenamein)
    im.thumbnail(size, Image.ANTIALIAS)
    im.save(filenamein, "PNG")

def use_casa():
    global filenamein
    size=int(WIDTH_IMGS), int(HEIGHT_IMGS)
    filenamein = "BigBenCrop_bw.png" #IMAGE CREDIT George J.Bendo
    im = Image.open(filenamein)
    im.thumbnail(size, Image.ANTIALIAS)
    im.save(filenamein, "PNG")

def use_galaxy():
    global filenamein
    filenamein = "m51_bw.png" #IMAGE CREDIT http://en.wikipedia.org/wiki/File:Messier51_sRGB.jpg 
    size=int(WIDTH_IMGS), int(HEIGHT_IMGS)
    im = Image.open(filenamein)
    im.thumbnail(size, Image.ANTIALIAS)
    im.save(filenamein, "PNG")

def zoom_out_2():
    global zoom_factor
    zoom_factor=2.0
    print zoom_factor

def zoom_in_2():
    global zoom_factor
    zoom_factor=0.5
    print zoom_factor

def unzoom():
    global zoom_factor
    zoom_factor=1.0
    
def sing_di():
    global configmsg, synthesis_type, BALLS, balltext
    BALLS=1
    configmsg = " "
    balltext = " 1 antenna"
    update_status(4)
    build_balls()
    draw()
    synthesis_type=2
    
def earth_rot():
    global synthesis_type, BALLS
    if BALLS==1:
        BALLS=2
        build_balls()
    balltext = str(BALLS) + " ant."
    print_out()
    synthesis_type=1
    update_status(4)

def snap_shot():
    global synthesis_type, BALLS
    if BALLS==1:
        BALLS=2
        build_balls()
    balltext = str(BALLS) + " ant."
    print_out()
    synthesis_type=0
    update_status(4)

def gauss_kern(size, sizey=None):
    '''borrowed from StackOverflow and wikipedia'''
    size = int(size)    
    if not sizey:
        sizey = size
    else:
        sizey = int(sizey)               
    x, y = mgrid[-size:size, -sizey:sizey]
    A = 1
    x0 = 0
    y0 = 0
 
    sigma_x = size/2.35482
    sigma_y = sizey/2.35482
 
    theta = 180
    theta=float(theta)/pi
    a = cos(theta)**2/2/sigma_x**2 + sin(theta)**2/2/sigma_y**2;
    b = -sin(2*theta)/4/sigma_x**2 + sin(2*theta)/4/sigma_y**2 ;
    c = sin(theta)**2/2/sigma_x**2 + cos(theta)**2/2/sigma_y**2;

    Z_exp_x=((x-x0)**2)/(2*(sigma_x**2))
    Z_exp_y=((y-y0)**2)/(2*(sigma_y**2))

    Z=A*exp(-1*(Z_exp_x+Z_exp_y))
    return Z/Z.sum()


def calc_uvplt():
	global filenamein, col_map, x_pos, y_pos
	'''Calculates the uv data and simulated images!'''
	in_img=mpimg.imread(filenamein) #gif_image
	in_img=in_img[:,:,1] #select a single colour plane from a RBG image
	img_siz=in_img.shape #input image dimensions

	global statusmsg
	statusmsg = "Calc. UV"
	update_status(3)
	
	if synthesis_type == 0 or synthesis_type ==1:	
		x=np.array(x_pos)
		y=np.array(y_pos)
		#,y=np.loadtxt("output.dat",unpack=True)
		x=x*zoom_factor*pix_to_m
		y=y*zoom_factor*pix_to_m
		N=len(x)*(len(x)-1)                     #number of baselines

		lx=np.zeros((len(x),len(x)))
		ly=np.zeros((len(y),len(x)))

		for i in range(len(x)):
			for j in range(len(y)):
				lx[j,i]=(x[i]-x[j])
				ly[i,j]=(y[i]-y[j])

	if synthesis_type == 0:                          #snapshot mode
		u=(np.ceil(ly/wavel))                    # u values
		typeused = "Snapshot        "            #long white space to overlay correctly
		v=(np.ceil((-1.*lx*sin_dec)/wavel))      # v values
                                                           
		re_u=np.reshape(u,(len(x)**2),order='F') #reshape u into linear form
		re_v=np.reshape(v,(len(y)**2),order='F') #reshape v into linear form
		full_re_u=re_u
		full_re_v=re_v
                
		obs_uv_matrix=np.zeros(img_siz)          #create an empty matrix same size as in image for multiplying with fft of true sky image

		for k in range(len(re_u)):
			int_u=int(re_u[k])
			int_v=int(re_v[k])
			obs_uv_matrix[int_u,int_v]=1.0
	elif synthesis_type == 1:                         #Earth Rotation mode
		ha_range=[0.,20.,40.,60.,80.,100.,120.,140.,160.,180.]
		typeused = "Earth Rotation"
		u=0
		v=0
		full_re_u=0
		full_re_v=0
		for ha in ha_range:
			#print ha
			sin_ha=np.sin((ha * np.pi)/ 180.)
			cos_ha=np.cos((ha * np.pi)/ 180.)
			u=(np.ceil((((lx*sin_ha)+(ly*cos_ha))/wavel)))                    # u values including ha
			v=(np.ceil(((-1.*lx*sin_dec*cos_ha)+(ly*sin_dec*sin_ha))/wavel)) # v values
			#print u.shape, v.shape

			re_u=np.reshape(u,(len(x)**2),order='F') #reshape u into linear form
			re_v=np.reshape(v,(len(y)**2),order='F') #reshape v into linear form
			full_re_u=np.append(full_re_u,re_u)
			full_re_v=np.append(full_re_v,re_v)
			#print full_re_u, full_re_v
            
			obs_uv_matrix=np.zeros(img_siz) #create an empty matrix same size as in image for multiplying with fft of true sky image

		for k in range(len(full_re_u)):
			int_u=int(full_re_u[k])
			int_v=int(full_re_v[k])
			obs_uv_matrix[int_u,int_v]=1.0
	elif synthesis_type == 2:                     #Single Dish
		size_gauss=1.22*(wavel/12.)
		#print size_gauss
		gaussian=gauss_kern(img_siz[0]/2,img_siz[1]/2)
		typeused = "Single Ant.    " #long white space to overlay corre
		obs_uv_matrix=np.zeros(img_siz)
		singledish=signal.fftconvolve(in_img,gaussian, mode='same')

		full_re_u=np.arange((-12.0/wavel),(12.0/wavel),0.1)
		full_re_v=np.arange((-12.0/wavel),(12.0/wavel),0.1)
            

	obs_uv_matrix[0,0]=0.0                   #fixes uv 0,0 to 0

	fig_uv = plt.figure(8,figsize=[(2.68*((HEIGHT_ANT*(2./3.))/570)),(2.68*((WIDTH_ANT*(2./3.))/570))]) #Horrific aspect ratio hack... sorry!
	fig_uv.clear()
	ax_uv = fig_uv.add_subplot(111)
	if synthesis_type == 0 or synthesis_type == 1:
		ax_uv.plot(full_re_u,full_re_v,'.')#plot uv coverage
		ax_uv.plot(0,0,'w.',mec='w')
	elif synthesis_type == 2:
		circ=pyl.Circle((0,0),radius=1.2)
		ax_uv.add_patch(circ)
	ax_uv.set_xlim(-100,100)
	ax_uv.set_ylim(-100,100)
	#ax_uv.get_xaxis().set_ticks([])
	#ax_uv.get_yaxis().set_ticks([])
	ax_uv.tick_params(axis='both',labelsize='4')
	ax_uv.set_xlabel('u [$\lambda$]',size='5')
	ax_uv.set_ylabel('v [$\lambda$]',size='5')
	fig_uv.savefig('uvplot.png', dpi=150, facecolor='w', edgecolor='w',
        orientation='portrait', papertype=None, format=None,
        transparent=False,bbox_inches='tight',pad_inches=0.05)

	#---3 Do the maths ---#
	#--Section 7 chapter 2 Synthesis imaging--#
	fft_img=np.fft.fft2(in_img)              #This is the complex visibility from a complete and ideal array from u,v =0,0 outward.
	observed=fft_img*obs_uv_matrix           #Observed complex visibility. Combines ideal visibility with the observed uv points, removing those not seen by the selected array configuration.
	ifft_img=np.fft.ifft2(observed)          #inverse FFTs the observed visibility
	real_ifft_img=ifft_img.real              #Takes real part only for plotting

	fig_obs = plt.figure(4, figsize=[(2.68*(WIDTH_ANT/600)),(2.68*(WIDTH_ANT/600))]) #Horrific aspect ratio hack... sorry!
	fig_obs.clear()
	fig_obs.subplots_adjust(left=0, right=1, top=1, bottom=0)
	ax_obs=fig_obs.add_subplot(111)
	if synthesis_type == 0 or synthesis_type ==1:
		ax_obs.imshow(real_ifft_img, cmap=col_map)                #Show observed version of input image.
		ax_obs.get_xaxis().set_visible(False)
		ax_obs.get_yaxis().set_visible(False)
		#plt.gca().invert_yaxis()
		fig_obs.savefig('output.png', dpi=150, facecolor='w', edgecolor='w',
                    orientation='portrait', papertype=None, format=None,
                    transparent=False, bbox_inches=None, pad_inches=None)
		statusmsg = "Done: " + str(typeused)
		update_status(3)
	elif synthesis_type == 2:
		ax_obs.imshow(singledish, cmap=col_map)                #Show observed version of input image.
		ax_obs.get_xaxis().set_visible(False)
		ax_obs.get_yaxis().set_visible(False)
		#plt.gca().invert_yaxis()
		fig_obs.savefig('output.png', dpi=150, facecolor='w', edgecolor='w',
                    orientation='portrait', papertype=None, format=None,
                    transparent=False, bbox_inches=None, pad_inches=None)
		statusmsg = "Done: " + str(typeused)
		update_status(3)

def make_printable():
    '''make a printable version of the output image '''
    fig = plt.figure(num=None, figsize=(4, 6), facecolor='k', edgecolor='none')
    img=mpimg.imread('output.png')
    rotate_img = ndimage.rotate(img, 90)
    lum_img = rotate_img[:,:,0]
    imgplot = plt.imshow(lum_img)
    plt.axis('off')
    plt.text(20, 445, 'Seen through ALMA\'s eyes - at the Summer\nScience Exhibition 2012 almauk.tumblr.com ', style='italic',color="white",
            bbox={'facecolor':'black', 'alpha':0.5, 'pad':10}, rotation=180)

    im = Image.open('logo2.png')
    height = im.size[1]
    # We need a float array between 0-1, rather than
    # a uint8 array between 0-255
    im = np.array(im).astype(np.float) / 255
    # With newer (1.0) versions of matplotlib, you can 
    # use the "zorder" kwarg to make the image overlay
    # the plot, rather than hide behind it... (e.g. zorder=10)
    im = ndimage.rotate(im, 90)
    fig.figimage(im, 20, 1900, zorder=2)
    im2 = Image.open('almalogo.png')
    height = im2.size[1]
    im2 = np.array(im2).astype(np.float) / 255
    im2 = ndimage.rotate(im2, 90)
    fig.figimage(im2, 1000, 1900)
    plt.subplots_adjust(left=0.00, right=1.0, top=0.9, bottom=0.0)
    fig.savefig('outputprint.png',figsize=(4, 6),dpi=400, facecolor='k', edgecolor='none')


def draw_uvplt():
        uvimg=Image.open("uvplot.png")
        global statusmsg
        #statusmsg = "UV plotting"
        update_status(3)
        uvphoto=ImageTk.PhotoImage(uvimg)
        uv_image.configure(image=uvphoto)
        uv_image.image=uvphoto
	
def draw_output():
        outimg=Image.open('output.png')
        outphoto=ImageTk.PhotoImage(outimg) #out_img = PhotoImage(file="output.gif")
        output_image.configure(image=outphoto)
        output_image.image=outphoto   
		
def draw():
    ''' Draw array_canvas'''
    array_canvas.delete(ALL)
    array_canvas.create_line((X_LEFTOUT, Y_UPOUT, X_LEFTOUT, Y_DOWNOUT), fill='blue', width=3)
    array_canvas.create_line((X_RIGHTOUT, Y_UPOUT, X_RIGHTOUT, Y_DOWNOUT), fill='blue', width=2)
    array_canvas.create_line((X_RIGHTOUT, Y_DOWNOUT, X_LEFTOUT, Y_DOWNOUT), fill='blue', width=3)
    array_canvas.create_line((X_RIGHTOUT, Y_UPOUT, X_LEFTOUT, Y_UPOUT), fill='blue', width=3)
    #make grid
    for line in range(int(10*zoom_factor)+(int(np.ceil(zoom_factor)))):#great scott thats an ugly expressioN! 
        increment=((WIDTH_ANT-(2*WALL))/(10*zoom_factor))*line         # and requires 1.21 JW of power to solve. :p
        array_canvas.create_line(((X_LEFTOUT+increment), Y_UPOUT, (X_LEFTOUT+increment), Y_DOWNOUT), fill='black', width=1)
        array_canvas.create_line((X_RIGHTOUT, (Y_UPOUT+increment), X_LEFTOUT, (Y_UPOUT+increment)), fill='black', width=1)
    # Draw all balls.
    for ball in balls:
        x1 = ball.position.x - BALL_RADIUS
        y1 = ball.position.y - BALL_RADIUS
        x2 = ball.position.x + BALL_RADIUS
        y2 = ball.position.y + BALL_RADIUS
        array_canvas.create_oval((x1, y1, x2, y2), fill='#6699ff')
    array_canvas.update()
    #array_canvas.postscript(file="my_drawing.ps", colormode='color')


def build_balls():
    ''' Create balls variable.'''
    global balls, add_min
    global orig_x, orig_y
    global x_pos, y_pos
    if add_min == 1:
        add_min=0
        nu_orig_x=x_pos
        nu_orig_y=y_pos#np.loadtxt("output.dat",unpack=True)
        nu_orig_x=append(nu_orig_x,orig_x[BALLS])
        nu_orig_y=append(nu_orig_y,orig_y[BALLS])
        balls = tuple(Ball(nu_orig_x[ball], nu_orig_y[ball]) for ball in xrange(BALLS))
    else:
        balls = tuple(Ball(orig_x[ball], orig_y[ball]) for ball in xrange(BALLS))

def on_motion(event):
    i=0
    for ball in balls:
        if(ball.userPick(event.x,event.y)):
            ball.antwasPick(event.x,event.y)
            isOut(event.x,event.y,i)
            checkCollision(i)
            draw()
        i=i+1
        
def on_release(event):
       release_x, release_y= event.x, event.y
       draw()
       print_out()
       #print release_x, release_y

def print_out():
    global x_pos, y_pos
    x_pos = tuple(ball.position.x for ball in balls)
    y_pos = tuple(ball.position.y for ball in balls)
    

def isOut (x,y,i):
        # Ant pos outside x left
        if (x < X_LEFTOUT):
            print "less than XL"
            balls[i].position.x=orig_x[i]
            balls[i].position.y=orig_y[i]
            return True
        elif (x > X_RIGHTOUT):
            # Set xy - Position to start
            print "greater than XR"
            balls[i].position.x=orig_x[i]
            balls[i].position.y=orig_y[i]
            return True
        elif (y < Y_UPOUT):
          #Set xy - Position to start
            print "less than YU"
            balls[i].position.x=orig_x[i]
            balls[i].position.y=orig_y[i]
            return True
        elif (y > Y_DOWNOUT):
              # Set xy - Position to start
            print "greater than YD"
            balls[i].position.x=orig_x[i]
            balls[i].position.y=orig_y[i]
            return True
        else:
            return False

def checkCollision(b):
        for ball in balls: 
             if(ball.colliding(balls[b])):
                shiftAway(b)
                break
	
def shiftAway (b):
		balls[b].position.x = balls[b].position.x-10;
		balls[b].position.y = balls[b].position.y+10;
		isOut(balls[b].position.x,balls[b].position.y,b);

#--------------------------------------------------------------------------------#


#------------------------ TWO DIMENTIONAL VECTOR CLASS --------------------------#
#--- credit code.activestate.com/recipes/502241-bouncing-ball-simulation --------#
class TwoD:

    def __init__(self, x, y):
        self.x = float(x)
        self.y = float(y)

    def __repr__(self):
        return 'TwoD(%s, %s)' % (self.x, self.y)

    def __add__(self, other):
        return TwoD(self.x + other.x, self.y + other.y)

    def __sub__(self, other):
        return TwoD(self.x - other.x, self.y - other.y)

    def __mul__(self, other):
        return TwoD(self.x * other, self.y * other)

    def __div__(self, other):
        return TwoD(self.x / other if other else self.x, self.y / other if other else self.y)

    def __iadd__(self, other):
        self.x += other.x
        self.y += other.y
        return self

    def __isub__(self, other):
        self.x -= other.x
        self.y -= other.y
        return self

    def __imul__(self, other):
        self.x *= other
        self.y *= other
        return self

    def __idiv__(self, other):
        self.x /= other
        self.y /= other
        return self

    def mag(self):
        return ((self.x ** 2) + (self.y ** 2)) ** 0.5

#-------------------------------------------------------------------------#

#-------------------- BALL IMPLEMENTATION CLASS---------------------------#

class Ball:

    def __init__(self,x,y):
         self.position = TwoD(x,y)
        
	 #--Picking up antenna--#
    def userPick (self, mouse_x, mouse_y):
        # distance between click and antenna position
        x = mouse_x - self.position.x;
        y = mouse_y - self.position.y;
		
        # Pythagoras for cacling distance between click and antenna cent
        distance = np.sqrt ((x*x) + (y*y));
		
        if (distance < BALL_RADIUS*1.1):
            return True
        else:
            return False
        
    #** Picking up antenna */
    def antwasPick (self, mouse_x, mouse_y):
        # distance between click and antenna position
        self.position.x=mouse_x
        self.position.y=mouse_y
        
    def colliding (self, other):
        if (self == other):
            return False;
        else:
            xd = self.position.x - other.position.x
            yd = self.position.y - other.position.y
			
            sumRadius = BALL_RADIUS
            sqrRadius = sumRadius * sumRadius
			
            distSqr = (xd * xd) + (yd * yd)
			
            if (distSqr <= sqrRadius):
                return True
            else:
                return False

#-----------------------------------------------------------------------#
def update_input():
    # to update array canvas
    input_image.after(IN_UPDATE, update_input)
    draw_input()

def draw_input():
        print filenamein
        size=int(dpi*(2.68*(WIDTH_ANT/600))),int(dpi*(2.68*(WIDTH_ANT/600)))
        im = Image.open(filenamein)
        im = im.resize(size, Image.ANTIALIAS)
        im.save(filenamein, "PNG")
        inpimg=Image.open(filenamein) #"shed.png"
        inpphoto=ImageTk.PhotoImage(inpimg)
        input_image.configure(image=inpphoto)
        input_image.image=inpphoto

#-----------------------------------------------------------------------#
def update_status(rowuse):
    global statusmsg
    global configmsg, balltext
    if rowuse == 3:
        statustext = Label(button_frame, text=statusmsg, relief=GROOVE)
        #statustext.grid(column=4, row=rowuse, sticky=W)
        statustext.pack()
        statustext.place(bordermode=OUTSIDE, height=BUTTON_H, width=200, x=BUT_COL_SEV, y=BUT_ROW_TWO)

    if rowuse == 4:
        configtext = Label(button_frame, text=configmsg+balltext, relief=GROOVE)
        #configtext.grid(column=4, row=4, sticky=W)
        configtext.pack()
        configtext.place(bordermode=OUTSIDE, height=BUTTON_H, width=200, x=BUT_COL_SEV, y=BUT_ROW_THR)
    
#-----------------------------------------------------------------------#
def print_image():
    '''send data to the printer '''
    make_printable() #make a nice looking plot first
    time.sleep(5) #wait for the above to save
    filetoprint = 'outputprint.png' #make global?
    # Constants for GetDeviceCaps
    # HORZRES / VERTRES = printable area
    HORZRES = 8
    VERTRES = 10
    # LOGPIXELS = dots per inch
    LOGPIXELSX = 88
    LOGPIXELSY = 90
    # PHYSICALWIDTH/HEIGHT = total area
    PHYSICALWIDTH = 110
    PHYSICALHEIGHT = 111
    # PHYSICALOFFSETX/Y = left / top margin
    PHYSICALOFFSETX = 112
    PHYSICALOFFSETY = 113
    printer_name = win32print.GetDefaultPrinter ()
    file_name = filetoprint #"output.png"
    # Create a device context from a named printer
    #  and assess the printable size of the paper.
    hDC = win32ui.CreateDC ()
    hDC.CreatePrinterDC (printer_name)
    printable_area = hDC.GetDeviceCaps (HORZRES), hDC.GetDeviceCaps (VERTRES)
    printer_size = hDC.GetDeviceCaps (PHYSICALWIDTH), hDC.GetDeviceCaps (PHYSICALHEIGHT)
    printer_margins = hDC.GetDeviceCaps (PHYSICALOFFSETX), hDC.GetDeviceCaps (PHYSICALOFFSETY)
    # Open the image, rotate it if it's wider than
    #  it is high, and work out how much to multiply
    #  each pixel by to get it as big as possible on
    #  the page without distorting.
    #
    bmp = Image.open (file_name)
    if bmp.size[0] > bmp.size[1]:
      bmp = bmp.rotate (90)

    ratios = [1.0 * printable_area[0] / bmp.size[0], 1.0 * printable_area[1] / bmp.size[1]]
    scale = min (ratios)
    # Start the print job, and draw the bitmap to
    #  the printer device at the scaled size.
    hDC.StartDoc (file_name)
    hDC.StartPage ()
    dib = ImageWin.Dib (bmp)
    scaled_width, scaled_height = [int (scale * i) for i in bmp.size]
    x1 = int ((printer_size[0] - scaled_width) / 2)
    y1 = int ((printer_size[1] - scaled_height) / 2)
    x2 = x1 + scaled_width
    y2 = y1 + scaled_height
    dib.draw (hDC.GetHandleOutput (), (x1, y1, x2, y2))
    hDC.EndPage()
    hDC.EndDoc()
    hDC.DeleteDC()

#-----------------------------------------------------------------------#
def makecolourful():
    global col_map
    col_map=cm.jet

#-----------------------------------------------------------------------#
def makerepresentative():
    global col_map
    col_map=cm.gist_gray

#------------------------ GUI SETUP ------------------------------------#

root = Tk()
root.title("ALMA Sim")
WIDTH, HEIGHT = root.winfo_screenwidth(), root.winfo_screenheight()
HEIGHT=HEIGHT-70
print WIDTH, HEIGHT
root.geometry("%dx%d+0+0" % (WIDTH, HEIGHT))
root.configure(background = bgcolour)

#--- Define Telescope array parameters based on screen size ---#
WIDTH_ANT= WIDTH/2.5
HEIGHT_ANT= WIDTH/3.0
BALL_RADIUS = 20        # FOR ballS IN PIXELS
X_LEFTOUT=BALL_RADIUS*1.5                  # LEFT BOUNDARY
X_RIGHTOUT=WIDTH_ANT-(BALL_RADIUS*1.5)     # RIGHT BOUNDARY
Y_UPOUT=BALL_RADIUS*1.5                    # TOP BOUNDARY
Y_DOWNOUT=HEIGHT_ANT-(BALL_RADIUS*1.5)     # BOTTOM BOUNDARY
BUTTON_H=WIDTH_ANT*(1./12.)
BUTTON_W=WIDTH_ANT*(1./6.)
WIDTH_IMGS=WIDTH_ANT*(2./3.)
HEIGHT_IMGS=WIDTH_IMGS

print WIDTH_IMGS

BUT_COL_ONE=(BUTTON_W/10.0)
BUT_COL_TWO=(BUTTON_W+(2.0*(BUTTON_W/10.0)))
BUT_COL_THR=(2.0*BUTTON_W+(3.0*(BUTTON_W/10.0)))
BUT_COL_FOU=(3.0*BUTTON_W+(4.0*(BUTTON_W/10.0)))
BUT_COL_FIV=((4.0*BUTTON_W)+(5.0*(BUTTON_W/10.0)))
BUT_COL_SIX=((5.0*BUTTON_W)+(6.0*(BUTTON_W/10.0)))
BUT_COL_SEV=((6.0*BUTTON_W)+(7.0*(BUTTON_W/10.0)))
BUT_COL_EIG=((7.0*BUTTON_W)+(8.0*(BUTTON_W/10.0)))

BUT_ROW_ONE=(BUTTON_H/10.0)
BUT_ROW_TWO=(BUTTON_H+(2.0*(BUTTON_H/10.0)))
BUT_ROW_THR=(2.0*BUTTON_H+(3.0*(BUTTON_H/10.0)))
BUT_ROW_FOU=(3.0*BUTTON_H+(4.0*(BUTTON_H/10.0)))
BUT_ROW_FIV=(4.0*BUTTON_H+(5.0*(BUTTON_H/10.0)))

#--------------------------------------------------------------#

meters='YEAH'

mainframe = Frame(root)
mainframe.grid(column=0, row=0, sticky=(N, W, E, S))
mainframe.columnconfigure(0, weight=1)
mainframe.rowconfigure(0, weight=1)


#--ARRAY--#
array_canvas = Canvas(mainframe, width=WIDTH_ANT, height=HEIGHT_ANT, background='white')
array_canvas.grid(column=0, row=0, sticky=(N, W, E, S))
array_canvas.after(1000 / FRAMES_PER_SEC, update_array)
array_canvas.bind("<B1-Motion>", on_motion)
array_canvas.bind("<ButtonRelease-1>", on_release)

#-----CONTROL BOX----------------------------------------------------------#

#--BUTTONS--#
button_frame= Canvas(mainframe,background=bgcolour,height=(HEIGHT_ANT*(2./3.)),width=(WIDTH_ANT*(5./3.)),highlightcolor=bgcolour,highlightbackground=bgcolour)
button_frame.grid(columnspan=2,column=0, row=1, sticky=(N, W,E, S))
button_frame.pack()

#--- ANTENNA CONFIGs ---#
sprial=Button(button_frame, text="Spiral", command=define_spiral)
sprial.pack()
sprial.place(bordermode=OUTSIDE, height=BUTTON_H, width=BUTTON_W, x=BUT_COL_ONE,y=BUT_ROW_ONE)

y_shape=Button(button_frame, text="Y-shape", command=define_yshape)
y_shape.pack()
y_shape.place(bordermode=OUTSIDE,  height=BUTTON_H, width=BUTTON_W, x=BUT_COL_ONE,y=BUT_ROW_TWO)

line=Button(button_frame, text="line", command=define_line)
line.pack()
line.place(bordermode=OUTSIDE,  height=BUTTON_H, width=BUTTON_W, x=BUT_COL_ONE,y=BUT_ROW_THR)

#-- ALMA antenna config, slightly different to above due to drop down ---#
var = StringVar(root)
choices = list([1,4,8,12,16,20]) #list(np.arange(1,28,1))
option = OptionMenu(button_frame, var, *choices)
option.pack()
option.place(bordermode=OUTSIDE, height=BUTTON_H, width=BUTTON_W, x=BUT_COL_TWO,y=BUT_ROW_FOU)
alma=Button(button_frame, text="ALMA conf.", command=define_alma)
alma.pack()
alma.place(bordermode=OUTSIDE, height=BUTTON_H, width=BUTTON_W, x=BUT_COL_ONE, y=BUT_ROW_FOU)

#--- ANTENNA NUMBERS ---#
five_ants=Button(button_frame, text="05\nAntennae", command=ants_5)
five_ants.pack()
five_ants.place(bordermode=OUTSIDE, height=BUTTON_H, width=BUTTON_W, x=BUT_COL_TWO, y=BUT_ROW_ONE)

ten_ants=Button(button_frame, text="10\nAntennae", command=ants_10)
ten_ants.pack()
ten_ants.place(bordermode=OUTSIDE, height=BUTTON_H, width=BUTTON_W, x=BUT_COL_TWO, y=BUT_ROW_TWO)

twe_ants=Button(button_frame, text="30\nAntennae", command=ants_30)
twe_ants.pack()
twe_ants.place(bordermode=OUTSIDE, height=BUTTON_H, width=BUTTON_W, x=BUT_COL_TWO, y=BUT_ROW_THR)

add_ants=Button(button_frame, text="Add\nAntennae", command=add_ball)
add_ants.pack()
add_ants.place(bordermode=OUTSIDE, height=BUTTON_H, width=BUTTON_W, x=BUT_COL_THR, y=BUT_ROW_ONE)

min_ants=Button(button_frame, text="Remove\nAntennae", command=min_ball)
min_ants.pack()
min_ants.place(bordermode=OUTSIDE, height=BUTTON_H, width=BUTTON_W, x=BUT_COL_THR, y=BUT_ROW_TWO)

#--- IMAGE SELECTION ---#
takecam=Button(button_frame, text="Use Webcam", command=use_webcam)
takecam.pack()
takecam.place(bordermode=OUTSIDE,height=BUTTON_H, width=BUTTON_W, x=BUT_COL_FOU, y=BUT_ROW_ONE)

takedefault=Button(button_frame, text="Use Big Ben", command=use_casa)
takedefault.pack()
takedefault.place(bordermode=OUTSIDE, height=BUTTON_H, width=BUTTON_W, x=BUT_COL_FOU, y=BUT_ROW_TWO)

takegalaxy=Button(button_frame, text="Use Galaxy", command=use_galaxy)
takegalaxy.pack()
takegalaxy.place(bordermode=OUTSIDE,  height=BUTTON_H, width=BUTTON_W, x=BUT_COL_FOU, y=BUT_ROW_THR)


#--- Synthesis ---#
ear_rot=Button(button_frame, text="Earth\nRotation", command=earth_rot)
ear_rot.pack()
ear_rot.place(bordermode=OUTSIDE,  height=BUTTON_H, width=BUTTON_W, x=BUT_COL_FIV, y=BUT_ROW_ONE)

snapshot=Button(button_frame, text="Snapshot\nmode", command=snap_shot)
snapshot.pack()
snapshot.place(bordermode=OUTSIDE,  height=BUTTON_H, width=BUTTON_W, x=BUT_COL_FIV, y=BUT_ROW_TWO)

sing_dish=Button(button_frame, text="Single\nAntenna", command=sing_di)
sing_dish.pack()
sing_dish.place(bordermode=OUTSIDE,  height=BUTTON_H, width=BUTTON_W, x=BUT_COL_FIV, y=BUT_ROW_THR)

#--Zoom---#
zoom_out=Button(button_frame, text="Increase\nArray Size", command=zoom_out_2)
zoom_out.pack()
zoom_out.place(bordermode=OUTSIDE, height=BUTTON_H, width=BUTTON_W,x=BUT_COL_SIX, y=BUT_ROW_ONE)

unzoom_bu=Button(button_frame, text="Normal\nArray Size", command=unzoom)
unzoom_bu.pack()
unzoom_bu.place(bordermode=OUTSIDE, height=BUTTON_H, width=BUTTON_W, x=BUT_COL_SIX, y=BUT_ROW_TWO)

zoom_in=Button(button_frame, text="Decrease\nArray Size", command=zoom_in_2)
zoom_in.pack()
zoom_in.place(bordermode=OUTSIDE, height=BUTTON_H, width=BUTTON_W, x=BUT_COL_SIX, y=BUT_ROW_THR)

#-- Colours ---#
pretty=Button(button_frame, text="Colourful", command=makecolourful)
pretty.pack()
pretty.place(bordermode=OUTSIDE, height=BUTTON_H, width=BUTTON_W, x=BUT_COL_SEV, y=BUT_ROW_FOU)

notpretty=Button(button_frame, text="Scientific", command=makerepresentative)
notpretty.pack()
notpretty.place(bordermode=OUTSIDE, height=BUTTON_H, width=BUTTON_W, x=BUT_COL_EIG, y=BUT_ROW_FOU)


#--- STATUS ---#
namestatus = Label(button_frame, text='Status',font=("Helvetica", 16),relief=GROOVE)
namestatus.pack()
namestatus.place(bordermode=OUTSIDE, height=BUTTON_H, width=200, x=BUT_COL_SEV, y=BUT_ROW_ONE)

statustext = Label(button_frame, text=statusmsg,relief=GROOVE)
statustext.pack()
statustext.place(bordermode=OUTSIDE, height=BUTTON_H, width=200, x=BUT_COL_SEV, y=BUT_ROW_TWO)

configtext = Label(button_frame, text=configmsg,relief=GROOVE)
configtext.pack()
configtext.place(bordermode=OUTSIDE, height=BUTTON_H, width=200, x=BUT_COL_SEV, y=BUT_ROW_THR)


#---------------------------------------------------------MEDIA BOX ----#

media_frame= Canvas(mainframe,background=bgcolour,height=(HEIGHT_ANT*(2./3.)),width=(WIDTH_ANT*(2./3.)),highlightcolor=bgcolour,highlightbackground=bgcolour)
media_frame.grid(column=2, row=1, sticky=(N, W,E, S))
media_frame.pack()

#-- Print image - we need a code verification? ---#
#printimage=Button(media_frame, text="Print Image", command=print_image)
#printimage.pack()
#printimage.place(bordermode=OUTSIDE, height=50, width=100,x=450,y=10)

#--Some Branding ---#
logo=Image.open("arclogo_adv.png")
logophoto=ImageTk.PhotoImage(logo)
logo_image = Label(button_frame,image=logophoto, background=bgcolour)
logo_image.pack()
logo_image.place(bordermode=OUTSIDE, height=67, width=200,x=BUT_COL_ONE,y=BUT_ROW_FIV)

manlogo=Image.open("manlogo_adv.png")
manlogophoto=ImageTk.PhotoImage(manlogo)
manlogo_image = Label(button_frame,image=manlogophoto, background=bgcolour)
manlogo_image.pack()
manlogo_image.place(bordermode=OUTSIDE, height=67, width=200, x=BUT_COL_THR,y=BUT_ROW_FIV)

camlogo=Image.open("camlogo_adv.png")
camlogophoto=ImageTk.PhotoImage(camlogo)
camlogo_image = Label(button_frame,image=camlogophoto, background=bgcolour)
camlogo_image.pack()
camlogo_image.place(bordermode=OUTSIDE, height=67, width=330,x=BUT_COL_FIV,y=BUT_ROW_FIV)


#-----------------------------------------------------------------------#

#--INPUT IMAGE--#
inpimg=Image.open(filenamein)
inpphoto=ImageTk.PhotoImage(inpimg)
input_image = Label(mainframe,image=inpphoto, width=(WIDTH_IMGS*5./3.),background=bgcolour, anchor=CENTER)#, relief=GROOVE)
input_image.grid(column=1, row=0, sticky=(N, W, E, S), ipadx=(WIDTH_ANT*1./25.),ipady=(WIDTH_ANT*1./25.))
input_image.after(1000 / FRAMES_PER_SEC, update_input)

#--OUTPUT IMAGE--#
outimg=Image.open(gif_image)
outphoto=ImageTk.PhotoImage(outimg)
output_image = Label(mainframe, image=outphoto, width=(WIDTH_IMGS*5./3.),background=bgcolour,anchor=CENTER)#, relief=GROOVE)
output_image.grid(column=2, row=0, sticky=(N, W, E, S), ipadx=(WIDTH_ANT*1./25.),ipady=(WIDTH_ANT*1./25.))
output_image.after(1000 / FRAMES_PER_SEC, update_output)

#--UV IMAGE--#
uv_img=Image.open("uvplot.png")
uvphoto=ImageTk.PhotoImage(uv_img)
uv_image = Label(media_frame, image=uvphoto, width=(WIDTH_IMGS*4./3.),background=bgcolour,anchor=CENTER)#, relief=GROOVE)
#uv_image.grid(column=2, row=1, sticky=(N, W, E, S), ipadx=(WIDTH_ANT*1./25.),ipady=0)#(WIDTH_ANT*1./25.))
uv_image.pack()
uv_image.place(bordermode=OUTSIDE,x=100,y=0);
uv_image.after(1000 / FRAMES_PER_SEC, update_uv)

for child in mainframe.winfo_children(): child.grid_configure(padx=0, pady=0)

initialise()
root.mainloop()
