/*
  _______________________________________________________________________
  This file should contain only sparc specific code.
  -----------------------------------------------------------------------
  Original version by stg
  Routines added to cope with double precision data by njj:
*/


/* C header routines to PGPLOT FORTRAN calls */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#define MAX_STR 5
long int str_len[MAX_STR];
/*.......................................................................
  Open a plot device.
*/
void pg_arro (float xstart, float ystart, float xend, float yend)
{
	pgarro_(&xstart, &ystart, &xend, &yend) ;
}

int pg_begin(int unit, char *file, int nxsub, int nysub)
{
        int i=0;
	pgend_();
	str_len[0]=strlen(file);
        if(pgbegin_(&unit, file, &nxsub, &nysub, str_len[0]) != 1)
	  return -1;
	pgask_(&i);
	return 0;
}

void pg_box(char *xopt, float xtick, int nxsub, char *yopt, float ytick, int nysub)
{
        str_len[0]=strlen(xopt);
        str_len[1]=strlen(yopt);
        pgbox_(xopt, &xtick, &nxsub, yopt, &ytick, &nxsub, str_len[0],str_len[1]);
	return;
}

void pg_env(float xmin, float xmax, float ymin, float ymax, int just, int axis)
{
        pgenv_(&xmin, &xmax, &ymin, &ymax, &just, &axis);
	return;
}

void pg_advance(void)
{
        pgadvance_();
	return;
}

void pg_bin(int nbin, float x[], float data[], int center)
{
        pgbin_(&nbin, x, data, &center);
	return;
}

void pg_dbin(int nbin, double x[], double data[], int center)
{
        float *xbuf = NULL, *dbuf = NULL ;
	int i=0 ;

        xbuf = (float *) malloc (nbin * sizeof (float)) ;
        dbuf = (float *) malloc (nbin * sizeof (float)) ;
        
	for (i=0; i<nbin; i++)
	{
		xbuf[i] = (float) x[i] ;
		dbuf[i] = (float) data[i] ;
	}
	
        pgbin_(&nbin, xbuf, dbuf, &center);
        free (xbuf) ;
        free (dbuf) ;
	return;
}

void pg_conl(float a[], int idim, int jdim, int i1, int i2, int j1, int j2, float c,
        float tr[6], char *label, int intval, int minint)
{
      	        pgconl_(a, &idim, &jdim, &i1, &i2, &j1, &j2, &c, tr, label, &intval, &minint);
                return;
}
                

void pg_cont(float a[], int idim, int jdim, int i1, int i2, int j1, int j2, float c[], int nc, float tr[6])
{
        pgcont_(a, &idim, &jdim, &i1, &i2, &j1, &j2, c, &nc, tr);
	return;
}

void pg_dcont(double a[], int idim, int jdim, int i1, int i2, int j1, int j2, double c[], int nc, double tr[6])
{
        float *dbuf = NULL, ftr[6], fc[1000] ;
	int i=0 ;

        dbuf = (float *) malloc (idim * jdim * sizeof (float)) ;

        for (i=0;i<idim*jdim;i++) dbuf[i] = (float) a[i] ;
        for (i=0;i<6;i++) ftr[i] = tr[i] ;
        for (i=0;i<nc;i++) fc[i] = c[i] ;
        pgcont_(dbuf, &idim, &jdim, &i1, &i2, &j1, &j2, fc, &nc, ftr);
        free (dbuf) ;
        
	return;
}

int pg_curse(float *x, float *y, char *cr)
{
	static int junk ;
        str_len[0]=1;
        junk = pgcurse_(x, y, cr, 1L);
        return junk ;
}

void pg_draw(float x, float y)
{
        pgdraw_(&x, &y);
	return;
}

void pg_ddraw(double x, double y)
{
	float fx=(float)x, fy=(float)y ;
        pgdraw_(&fx, &fy);
	return;
}

void pg_end(void)
{
        pgend_();
	return;
}

void pg_errx(int n, float x1[], float x2[], float y[], float t)
{
        pgerrx_(&n, x1, x2, y, &t);
	return;
}

void pg_erry(int n, float x[], float y1[], float y2[], float t)
{
        pgerry_(&n, x, y1, y2, &t);
	return;
}

void pg_gray(float a[], int idim, int jdim, int i1, int i2, int j1, int j2, float black, float white, float tr[6])
{
        pggray_(a, &idim, &jdim, &i1, &i2, &j1, &j2, &black, &white, tr);
	return;
}

void pg_dgray(double a[], int idim, int jdim, int i1, int i2, int j1, int j2, double black, double white, double tr[6])
{
        float *dbuf = NULL, fblack = (float) black, fwhite = (float) white, ftr[6] ;
	int i=0 ;

        dbuf = (float *) malloc (idim * jdim * sizeof (float)) ;
        for (i=0;i<idim*jdim;i++) dbuf[i] = (float) a[i] ;
        for (i=0;i<6;i++) ftr[i] = (float) tr[i] ;
        pggray_(dbuf, &idim, &jdim, &i1, &i2, &j1, &j2, &fblack, &fwhite, ftr);
        free (dbuf) ;
}

void pg_hist(int n, float data[], float datmin, float datmax, int nbin, int pgflag)
{
        pghist_(&n, data, &datmin, &datmax, &nbin, &pgflag);
	return;
}

void pg_dhist(int n, double data[], double datmin, double datmax, int nbin, int pgflag)
{
	int i=0 ;
	float *dbuf=NULL, fmin, fmax ;

	dbuf = (float *) malloc (n * sizeof (float)) ;
	
	for (i=0; i<nbin; i++)
		dbuf[i] = (float) data[i] ;

	fmin = (float) datmin ;
	fmax = (float) datmax ;
	
        pghist_(&n, dbuf, &fmin, &fmax, &nbin, &pgflag);
        free (dbuf) ;
	return;
}

void pg_label(char *xlbl, char *ylbl, char *toplbl)
{
        str_len[0] = strlen(xlbl);
	str_len[1] = strlen(ylbl);
	str_len[2] = strlen(toplbl);
        pglabel_(xlbl, ylbl, toplbl, str_len[0], str_len[1], str_len[2]);
	return;
}

void pg_line(int n, float xpts[], float ypts[])
{
        pgline_(&n, xpts, ypts);
	return;
}

void pg_dline(int n, double xpts[], double ypts[])
{
	float *xbuf = NULL, *dbuf = NULL ;
	int i=0 ;

        xbuf = (float *) malloc (n * sizeof (float)) ;
        dbuf = (float *) malloc (n * sizeof (float)) ;
	for (i=0; i<n; i++)
	{
		xbuf[i] = (float) xpts[i] ;
		dbuf[i] = (float) ypts[i] ;
	}
	pgline_(&n, xbuf, dbuf);
	free (xbuf) ;
	free (dbuf) ;
	return;
}

void pg_move(float x, float y)
{
        pgmove_(&x, &y);
	return;
}

void pg_dmove(double x, double y)
{
	float fx = (float)x, fy = (float) y ;
        pgmove_(&fx, &fy);
	return;
}

void pg_mtext(char *side, float disp, float coord, float fjust, char *text)
{
        str_len[0] = strlen(side);
        str_len[1] = strlen(text);
        pgmtext_(side, &disp, &coord, &fjust, text, str_len[0],str_len[1]);
	return;
}

void pg_panl(int ix, int iy)
{
        pgpanl_(&ix, &iy);
	return;
}

void pg_paper(float width, float aspect)
{
        pgpaper_(&width, &aspect);
	return;
}

void pg_point(int n, float xpts[], float ypts[], int symbol)
{
        pgpoint_(&n, xpts, ypts, &symbol);
	return;
}

void pg_circ(float xpts, float ypts, float size)
{
        pgcirc_(&xpts, &ypts, &size);
	return;
}

void pg_dpoint(int n, double xpts[], double ypts[], int symbol)
{
	float *xbuf=NULL, *dbuf=NULL ;
	int i=0,j=0 ;

	dbuf = (float *) malloc (n * sizeof (float)) ;
	xbuf = (float *) malloc (n * sizeof (float)) ;
	
	for (i=0; i<n; i++)
	{
		xbuf[j] = (float) xpts[i] ;
		dbuf[j] = (float) ypts[i] ;
		j++ ;
	}
	pgpoint_(&j, xbuf, dbuf, &symbol);

	free (xbuf) ;
	free (dbuf) ;
	return;
}

void pg_ptext(float x, float y, float angle, float fjust, char *text)
{
        str_len[0]=strlen(text);
        pgptext_(&x, &y, &angle, &fjust, text, str_len[0]);
	return;
}

void pg_dptext(double x, double y, float angle, float fjust, char *text)
{
	float fx = (float)x, fy = (float) y ;
        str_len[0]=strlen(text);
        pgptext_(&fx, &fy, &angle, &fjust, text, str_len[0]);
	return;
}

void pg_qinf(char *item, char *value, int *length)
{
        str_len[0]=strlen(item);
	str_len[1]=strlen(value);
	pgqinf_(item, value, length, str_len[0], str_len[1]);
	return;
}

void pg_rect(float x1, float x2, float y1, float y2)
{
        pgrect_(&x1, &x2, &y1, &y2);
	return;
}

void pg_drect(double x1, double x2, double y1, double y2)
{
	float fx1 = (float)x1, fx2 = (float)x2 ;
	float fy1 = (float)y1, fy2 = (float)y2 ;
        pgrect_(&fx1, &fx2, &fy1, &fy2);
	return;
}

void pg_rnge(float x1, float x2, float *xlo, float *xhi)
{
        pgrnge_(&x1, &x2, xlo, xhi);
	return;
}

void pg_shls(int ci, float ch, float cl, float cs)
{
        pgshls_(&ci, &ch, &cl, &cs);
	return;
}

void pg_sah(int fs, float angle, float barb)
{
	pgsah_(&fs, &angle, &barb) ;
}

void pg_scf(int cf)
{
        pgscf_(&cf);
	return;
}

void pg_sch(float size)
{
        pgsch_(&size);
	return;
}

void pg_sci(int ci)
{
        pgsci_(&ci);
	return;
}

void pg_scr(int ci, float cr, float cg, float cb)
{
        pgscr_(&ci, &cr, &cg, &cb);
	return;
}

void pg_sitf(int itf)
{
        pgsitf_(&itf);
        return;
}


void pg_sfs(int fs)
{
        pgsfs_(&fs);
	return;
}

void pg_sls(int ls)
{
        pgsls_(&ls);
	return;
}

void pg_slw(int lw)
{
        pgslw_(&lw);
	return;
}

void pg_text(float x, float y, char *text)
{
        str_len[0]=strlen(text);
        pgtext_(&x, &y, text, str_len[0]);
	return;
}

void pg_dtext(double x, double y, char *text)
{
	float fx=(float)x, fy=(float)y ;
        str_len[0]=strlen(text);
        pgtext_(&fx, &fy, text, str_len[0]);
	return;
}

void pg_vport(float xleft, float xright, float ybot, float ytop)
{
        pgvport_(&xleft, &xright, &ybot, &ytop);
	return;
}

void pg_vsize(float xleft, float xright, float ybot, float ytop)
{
        pgvsize_(&xleft, &xright, &ybot, &ytop);
	return;
}

void pg_vstand(void)
{
        pgvstand_();
	return;
}

void pg_window(float x1, float x2, float y1, float y2)
{
        pgwindow_(&x1, &x2, &y1, &y2);
	return;
}

void pg_dwindow(double x1, double x2, double y1, double y2)
{
	float fx1 = (float)x1, fx2 = (float)x2 ;
	float fy1 = (float)y1, fy2 = (float)y2 ;
        pgwindow_(&fx1, &fx2, &fy1, &fy2);
	return;
}

void pg_wnad(float x1, float x2, float y1, float y2)
{
        pgwnad_(&x1, &x2, &y1, &y2);
	return;
}

void pg_qch(float *height)
{
        pgqch_(height);
	return;
}

void pg_qci(int *index)
{
        pgqch_(index);
	return;
}

void pg_qwin(float *xmin, float *xmax, float *ymin, float *ymax)
{
        pgqwin_(xmin,xmax,ymin,ymax);
	return;
}

void pg_updt()
{
        pgupdt_();
        return;
}

void pg_ask(int flag)
{
       pgask_(&flag);
       return;
}







