#include<stdio.h>
#include<math.h>
#include<stdlib.h>
#include<gsl/gsl_rng.h>

#define MAXTOK 40
#define MAXLEN 100

struct tok
{
  int n ;
  char ct[MAXTOK][MAXLEN] ;
} ;
typedef struct tok Tok ;

Tok *gettok (FILE *) ;

main (int argc, char *argv[])
{
    FILE *fp, *fo, *fopen () ;
    char line[1024], command[128] ;
    Tok *t ;
    int niter=0, i=0, j=0, doflux=1 ;
    float err, val ;
    long idum = -time(NULL) ;
    gsl_rng *rng = gsl_rng_alloc (gsl_rng_mt19937) ;

    if (argc < 3)
    {
        printf ("syntax: monte [.igl-file] [iterations]\n") ;
        exit(0) ;
    }
    sscanf (argv[2], "%d", &niter) ;
    if (argc > 3) sscanf (argv[3], "%d", &doflux) ;
    strcpy (command, "rm -f templog") ;
    system (command) ;

    for (i=0;i<niter;i++)
    {
        if (!(fp=fopen (argv[1], "r")))
        {
	    printf ("file %s not found\n", argv[1]) ;
            exit(0) ;
        }

        fo=fopen ("tempout", "w") ;
        while ((t = gettok (fp)))
	{
            if (t->n==0) fprintf (fo, "#\n") ;
	    else if (t->n==8)
	    {
                fprintf (fo, "%s ", t->ct[0]) ;
	        sscanf (t->ct[1], "%f", &val) ;
	        sscanf (t->ct[2], "%f", &err) ;
	        fprintf (fo, "%+f %f ", val+(float)gsl_ran_gaussian (rng,err), err) ;
	        sscanf (t->ct[3], "%f", &val) ;
	        sscanf (t->ct[4], "%f", &err) ;
	        fprintf (fo, "%+f %f ", val+(float)gsl_ran_gaussian (rng,err), err) ;
	        sscanf (t->ct[5], "%f", &val) ;
	        sscanf (t->ct[6], "%f", &err) ;
	        fprintf (fo, "%+f %f ", val+(float)gsl_ran_gaussian (rng,err), err) ;
                fprintf (fo, "%s\n", t->ct[7]) ;
	    }
	    else
	    {
	        for (j=0;j<t->n;j++) fprintf (fo, "%s ", t->ct[j]) ; 
                fprintf (fo, "\n") ;
	    }
	}
	fclose (fo) ;
	fclose (fp) ;
	sprintf (command, "igloo tempout %d >> templog", doflux) ;
	system (command) ;
    }

}

Tok *gettok (FILE *fp)
{
    static Tok t ;
    int i=0,j=0 ;
    char line[128] ;

    if (!(fgets (line, sizeof (line), fp))) return NULL ;
    for (i=0;i<strlen(line);i++) if (line[i]=='=') line[i]=' ';
    for (i=0;i<MAXTOK;i++) for (j=0;j<MAXLEN;j++) t.ct[i][j]='\0'; i=j=0 ;
    t.n = 1 ;
    while (line[i]==' ') i++ ;

    for(;;)
    {
        if (line[i]==' ')
	{
   	    t.n++ ; j=0 ; while (line[i]==' ')i++ ;
	}
        else if (line[i]=='\n'||line[i]=='#') 
        {
            if (!i||line[i-1]==' ')t.n-- ; break ;
	}
        else t.ct[t.n-1][j++] = line[i++] ;
    }
    return (&t) ;
}

