#include "gdefs.h"
#include "gpgdefs.h"
#define PSP 4
#define MAXH 100
#define NSHAPE h->iter
#define TS ((NSHAPE+1)*NSHAPE)/2

IGDEF

double gwds (double *p)
{
    static double dscale, wscale, *psf, *data, *data_sort,*w,galcenx,galceny ;
    static int been_here, d_siz, psf_siz, idmax, idmin, d_siz2, w_siz ;
    double *ff,d[TS],swt[TS], dmax, dmin, pmax, pmin, *chisq, *dw,
    *model, minv, maxv, x, y, scenx, sceny, shapes[NSHAPE*NSHAPE],*f, *sldata, 
    *scdata, *sdata,*tmp_sdata, radius, tr[6]={0.0,1.0,0.0,0.0,0.0,1.0};
    int ss1=h->spix,ss2=ss1,ii,nsing,sing[TS],imin,imax,idx,idx1,ix,iy,i,j,k;
    char data_file[1024], psf_file[1024], dfile[1024]="\0", wfile[1024]="\0" ;
    
    if (h->reg>0.0) radius=h->reg; else radius=1.0 ;
    for (ii=0;ii<NSHAPE*NSHAPE;ii++) shapes[ii]=0.0 ;
    for (ii=0;ii<TS;ii++) d[ii]=swt[ii]=0.0;
    for (ii=0;ii<TS;ii++) sing[ii]=0;
    if (!been_here || !p)
    {
      /*
printf (" Enter name of data file: ") ;    scanf ("%s", data_file) ;
printf (" Enter name of psf file: ") ;     scanf ("%s", psf_file) ;
printf (" Model file name (or ^D for current model): ") ;scanf ("%s", dfile) ;
printf (" Error file (or ^D to use crude estimate): ") ;scanf ("%s", wfile) ;
*/
        been_here = 1 ;
	strcpy (data_file,"0128_LEVN.FITS") ;
	strcpy (psf_file, "0128_LEVN.PSF") ;
	strcpy (dfile, "0128_opt.igl") ;
        strcpy (wfile, "") ;

        if (!(psf = fitsin (psf_file, &psf_siz, &dscale)) || 
            !(data = fitsin (data_file, &d_siz, &dscale))) 
            { printf ("Not found\n"); return VERYBIG ; }
        d_siz2 = d_siz * d_siz ;

	if (strlen(dfile)>0) ginput (dfile) ;
        free(data_sort) ;
	/*
        printf (" x coordinate (pixels) of the galaxy in the FITS file:") ;
	scanf ("%lf", &galcenx) ;
        printf (" y coordinate (pixels) of the galaxy in the FITS file:") ;
	scanf ("%lf", &galceny) ;
*/
	galcenx = g[0].par[NGX] ;   galceny = g[0].par[NGY] ;
        printf ("wd: data scale %f, image scale %f\n",dscale,h->a) ;
        printf ("wd: rescaling image plane by %f\n", h->a/dscale) ;
        
        for (ii=h->ngal-1;ii>=0;ii--)
        {
            g[ii].par[NGX]=galcenx+(g[ii].par[NGX]-g[0].par[NGX])*h->a/dscale;
            g[ii].par[NGY]=galceny+(g[ii].par[NGY]-g[0].par[NGY])*h->a/dscale;
            g[ii].par[NGB] *= h->a/dscale ;
            g[ii].par[NGS] *= h->a/dscale ;
            printf ("wd: Adjusted galaxy %i to (%f,%f), ER%f\n", ii, 
		    g[ii].par[NGX],g[ii].par[NGY],g[ii].par[NGB]);
            gfill (&g[ii]) ;
        }

        h->a = dscale ;
        pfill (&h->papix, h->a*1000.0, BROWN) ;
        h->ims = d_siz ;
        a = (double *) realloc (a,h->ims*h->ims*sizeof(double)) ;
        pifill (&h->pims, h->ims, BROWN) ;
        printf ("wd: setting plot grid to %dx%.2f\n", h->ims, h->a*1000.0) ;
	/*        
        efunk (NULL) ;
        loadtop () ;
	*/
        if (!h->docore)
        {
            h->docore = 1 ;
            pifill (&h->pdocore, h->docore, BROWN) ;  
            printf ("wd: Note - setting docore to 1\n") ;
        }
        minmax (psf, psf_siz*psf_siz, &pmin, &pmax, &idmin, &idmax) ;
        minmax (data, d_siz2, &dmin, &dmax, &idmin, &idmax) ;

        printf ("wd: Image grid %d mas (%dx%d); source grid %d mas (%dx%d)\n",
             d_siz*(int)(1000.0*h->a), d_siz, (int)(1000.0*h->a),
             ss1*(int)(1000.0*h->sscale), ss1, (int)(h->sscale*1000.0)) ;
    }
    if (p) loadfromp (p, 0) ;
    
    /* find brightest pixel in image, project back to source plane, determine 
   offset from source plane centre in arcseconds, convert to sp pixel size  */

    y = (double)(idmax/d_siz) ;
    x = (double)(idmax-d_siz*(idmax/d_siz)) ;
    gcsm (x, y, s[0].par[NSZ]) ;
    scenx = x - h->xoff ;
    sceny = y - h->yoff ;

    if (!p) printf ("wd: bright pix in image (%.1f,%.1f) -> (%.1f,%.1f)\n",
                    x,y,scenx,sceny) ;
    /*
    printf ("Type the new scenx: ");
    scanf ("%lf", &scenx) ;
    printf ("Type the new sceny: ");
    scanf ("%lf", &sceny) ;
    */

    chisq = (double *) malloc (d_siz2*sizeof (double)) ;
    model = (double *) malloc (d_siz2*sizeof (double)) ;
    dw = (double *) malloc (d_siz2*sizeof (double)) ;

    f = (double *) malloc (h->ims*h->ims*TS*sizeof(double)) ;
    w = getweight (data, d_siz2, "", scenx, sceny) ;
    for (i=0;i<d_siz2;i++) dw[i] = (w[i]<1.0/VERYBIG)?0.0:data[i] ;

    i=0; printf ("wd: Using %d shapelets\nProcessing ",TS) ;
    for (iy=0;iy<NSHAPE;iy++)
    {
        for (ix=0;ix<NSHAPE-iy;ix++)
	{
            for (j=0;j<NSHAPE*NSHAPE;j++) shapes[j]=0.0 ;
 	    shapes[iy*NSHAPE+ix]=1.0 ;
            sdata=shapelet(shapes,radius,ss1,ss2,.5*(double)ss1,.5*(double)ss2);
            sldata = gwds_lens (sdata,scenx,sceny,ss1,ss2) ;
            scdata = gwds_convolve (sldata, psf) ;
            memcpy (&f[i*h->ims*h->ims], scdata, h->ims*h->ims*sizeof(double));
	    i++;
            printf ("%d ", i); fflush(stdout) ;
	}
    }

    ff = (double *)malloc(TS*TS*sizeof(double));
    for (i=0;i<TS;i++)
    {
        idx=h->ims*h->ims*i;
        for (k=0;k<h->ims*h->ims;k++)
	    d[i]+=data[k]*f[idx+k]*w[k] ;

	for (j=0;j<TS;j++)
	{
	    idx1=h->ims*h->ims*j;
	    ff[i*TS+j]=0;
	    for (k=0;k<h->ims*h->ims;k++)
	      ff[i*TS+j]+=f[idx+k]*f[idx1+k]*w[k];
	}
    }          

    h->chucksing=0 ;
    
    nsing=getsvd (ff, d, sing, TS, swt) ;
    for (j=0;j<ss1*ss2;j++)
        sdata[j]=0.0 ;
    tmp_sdata=(double *)malloc(ss1*ss2*sizeof(double));
    for (j=0;j<NSHAPE*NSHAPE;j++) shapes[j]=0.0 ;
    i=0;
    for (iy=0;iy<NSHAPE;iy++)
        for (ix=0;ix<NSHAPE-iy;ix++)
           shapes[iy*NSHAPE+ix]=swt[i++] ;

    sdata=shapelet(shapes,radius,ss1,ss2,.5*(double)ss1,.5*(double)ss2);
    screen(WPLOT2);
    minmax(sdata,ss1*ss2,&minv,&maxv,&imin,&imax);
    h->pxu=h->pyu=NSHAPE;h->pxl=h->pyl=1.0;
    pg_dgray(sdata,ss1,ss2,1,ss1,1,ss2,minv,maxv,tr);
    sldata = gwds_lens (sdata,scenx,sceny,ss1,ss2) ;
    scdata = gwds_convolve (sldata, psf) ;

    if (nsing)
    {
    	if (p) for (ii=0;ii<h->os.nos;ii++) printf ("%.2f ", p[ii]) ;
        printf ("\nwd: warning: %d singular values\n", nsing) ;
    }

    for (i=0;i<h->ims*h->ims;i++)
        chisq[i] = (scdata[i]-data[i])*(scdata[i]-data[i])*w[i];
    h->pxu = h->pyu = NSHAPE ;
    screen (WPLOT5) ;
    minmax (shapes, NSHAPE*NSHAPE, &minv, &maxv, &imin, &imax) ;
    pg_dgray (shapes,NSHAPE,NSHAPE,1,NSHAPE,1,NSHAPE,minv,maxv,tr)  ;
    h->pxu = h->pyu = d_siz ;
    screen (WPLOT1) ;
    minmax (dw, d_siz*d_siz, &minv, &maxv, &imin, &imax) ;
    printf ("\nData: range %f-%f\n",minv,maxv) ;
    pg_dgray (dw,d_siz,d_siz,1,d_siz,1,d_siz,minv,minv+0.7*(maxv-minv),tr);
    screen (WPLOT2) ;
    /*    minmax (scdata, d_siz*d_siz, &minv, &maxv, &imin, &imax) ;*/
    printf ("Model: range %f-%f\n",minv,maxv) ;
    pg_dgray (scdata,d_siz,d_siz,1,d_siz,1,d_siz,minv,minv+0.7*(maxv-minv),tr);
    screen (WPLOT3) ;
    h->pxu = h->pyu = ss1 ;
    pg_window (0.0,(float)ss1,0.0,(float)ss2) ;
    minmax (sdata, ss1*ss2, &minv, &maxv, &imin, &imax) ; minv=0.0;
    printf ("Source: range %f-%f\n",minv,maxv) ;
    pg_dgray (sdata,ss1,ss2,1,ss1,1,ss2,minv,minv+0.7*(maxv-minv),tr);
    h->pxu = h->pyu = d_siz ;
    screen (WPLOT4) ;
    minmax (chisq, d_siz*d_siz, &minv, &maxv, &imin, &imax) ;
    pg_dgray (chisq,d_siz,d_siz,1,d_siz,1,d_siz,minv,minv+0.7*(maxv-minv),tr);

    /* print the shapes */

    for (i=0;i<NSHAPE;i++)
    {
        for (j=0;j<NSHAPE;j++)
	  printf ("%+6.3f ", shapes[(NSHAPE-i-1)*NSHAPE+j]) ;
	printf ("\n") ;
    }
    fitsout ("igloo_model.fits", d_siz,d_siz,scdata) ;

    free (sldata) ; free (scdata) ;
    screen (FULL) ;
    free (chisq) ;
    free (model) ;
    free (f) ;
    free (ff) ;
    free (dw) ;
    free (tmp_sdata) ;
    return 0.0 ;
}

double *shapelet (double *shape, double radius, 
                  int idim, int jdim, double cenx, double ceny)
{
    double *image, *ddata, scale ;
    float *fimage ;
    static double *data ;
    int nx=NSHAPE, ny=NSHAPE,i,j,ix,iy ;

    if (data) free (data) ;
    data = (double *) malloc (idim*jdim*sizeof (double)) ;
    image = (double *)malloc (idim*jdim*sizeof(double)) ;
    for (i=0;i<idim*jdim;i++) data[i]=0.0;
    scale = pow(radius,2.0) ;

    for (iy=0;iy<ny;iy++)
    {
        for (ix=0;ix<ny-iy;ix++)
	{
	    herm_image (image, idim, jdim, radius, ix, iy, cenx, ceny) ;
	    for (i=0;i<idim;i++)
	        for (j=0;j<jdim;j++)
	            data[idim*j+i] += shape[nx*iy+ix]*(float)image[idim*j+i] ;
	}
    }
    free (image) ;
    return data ;
}

void herm_image (double *image, int idim, int jdim, double radius, int nx, 
                       int ny, double cenx, double ceny)
{
    double x, y, xpow[idim][MAXH], ypow[jdim][MAXH], xherm ;
    int i,j ;

    for (i=0;i<idim;i++)
        for (j=0;j<=nx;j++) 
            xpow[i][j] = (double) pow (((double)i-cenx)/radius, (double) j) ;
    for (i=0;i<jdim;i++)
        for (j=0;j<=ny;j++) 
            ypow[i][j] = (double) pow (((double)i-ceny)/radius, (double) j) ;
    for (i=0;i<idim*jdim;i++) image[i]=0.0 ;

    for (i=0;i<idim;i++)
    {
        x = ((double)i-cenx)/radius ;
        xherm = hermite (nx, x, xpow[i]) ;
        for (j=0;j<jdim;j++)
        {
            y=((double)j-ceny)/radius ;
            image[j*idim+i] += xherm * hermite (ny,y,ypow[j]) * 
                   exp(-0.5*(x*x+y*y)) /
                   sqrt(3.1415927*pow(2.0,nx+ny)*factorial(nx)*factorial(ny)) ;
        }
    }
}

double factorial (int n)
{
    static double fac[100] ;
    static int been_here ;
    int i ;
    if (!been_here)
    {
    	fac[0]=fac[1]=1.0 ;
    	for (i=2;i<100;i++) fac[i]=fac[i-1]*(double)i ;
    	been_here=1 ;
    }
    if (n<100) return (fac[n]) ; else return (0.0) ;
}

double hermite (int n, double x, double powers[MAXH])
{
    static double h[MAXH][MAXH] ;
    static int been_here ;
    int i,j,k ;
    double val=0.0, f ;
    if (!been_here)
    {
        for (i=0;i<MAXH;i++)
        {
            for (j=0;j<MAXH;j++) h[i][j]=0.0 ;
            f=pow(2.,(double)(i)) ;
            for (k=i;k>=0;k-=2)
            {
            	h[i][k]=f ;
            	f*=-0.5*(k*(k-1))/(double)(i+2-k) ;
            }
        }
        been_here=1 ;
    }
    for (i=0;i<=n;i++) val+=h[n][i]*powers[i] ;
    return val ;
}

double *gwds_lens (double *ip, double scenx, double sceny, int ss1, int ss2)
{
    int ix, iy ;
    static double *out ;
    double xs, ys, xsg, ysg ;
    out = (double *) malloc (h->ims*h->ims*sizeof(double)) ;
    for (ix=0;ix<h->ims;ix++)
    {
        for (iy=0;iy<h->ims;iy++)
        {
	    out[iy*h->ims+ix] = 0.0 ;
	    gcsm ((double)ix,(double)iy,s[0].par[NSZ]);
            xs = (double)ix - h->xoff ;
	    ys = (double)iy - h->yoff ;
	    /* then convert xs, ys, to position on small source grid */
            xsg = 0.5*ss1+((double)h->a/(double)h->sscale)*(xs-scenx) ;
            ysg = 0.5*ss2+((double)h->a/(double)h->sscale)*(ys-sceny) ;
            if (xsg>0.0 && xsg<(double)ss1 && ysg>0.0 && ysg<(double)ss2)
                out[iy*h->ims+ix] = linterp (ip, xsg, ysg, ss1, ss2) ;
	}
    }
    return out ;
}
double *gwds_convolve (double *ip, double *conv)
{   /* done the lazy way by python */
    FILE *fo, *fopen() ;
    static double *out ;
    static int count ;
    int asiz ;
    double ascale ;
    out = (double *) malloc (h->ims*h->ims*sizeof(double)) ;
    system("rm tmp_in.fits") ;
    system ("rm tmp_psf.fits") ;
    system ("rm tmp_out.fits") ;
    fitsout ("tmp_in.fits", h->ims, h->ims, ip) ;
    fitsout ("tmp_psf.fits", h->ims, h->ims, conv) ;
    fo = fopen("tmp.py", "w") ;
    fprintf (fo, "import njj\nimport pyfits\nfrom pyfits import getdata\n");
    fprintf (fo, "import matplotlib\nfrom matplotlib import pyplot as plt\n");
    fprintf (fo, "a=getdata('tmp_in.fits')\n") ;
    fprintf (fo, "b=getdata('tmp_psf.fits')\n") ;
    fprintf (fo, "c=njj.convolve(a,b)\n") ;
    fprintf (fo, "plt.subplot(131);plt.imshow(a)\n");
    fprintf (fo, "plt.subplot(132);plt.imshow(b)\n");
    fprintf (fo, "plt.subplot(133);plt.imshow(c)\n");
    fprintf (fo, "plt.savefig('debugpic%03d')\n",count++) ;
    fprintf (fo, "pyfits.writeto('tmp_out.fits',c)\n") ;
    fclose(fo);
    system ("python tmp.py") ;
    out = fitsin ("tmp_out.fits", &asiz, &ascale) ;
    return out ;
}

double *getweight (double *data, int d_siz2, char *wfile, double sx, double sy)
{
    static double *w ;
    Obs *im = groot (sx, sy) ;
    double *data_sort, wscale, minv, maxv ;
    int ii, j, ix, iy, w_siz, d_siz=(int)sqrt((float)(d_siz2)),imin,imax;
    w = (double *) malloc (d_siz2*sizeof (double)) ;
    data_sort = (double *) malloc (d_siz2*sizeof (double)) ;

    for (ii=0;ii<d_siz2;ii++) 
            data_sort[ii]=(data[ii]>0.0)?data[ii]:-data[ii] ;
    qsort (data_sort, d_siz2, sizeof(double), sort_compf) ;

    if (strlen (wfile))
    {
        if (!(w = fitsin (wfile, &w_siz, &wscale))) 
            { printf ("Not found\n"); return w; }
    }
    else
    {
        w = (double *) malloc (d_siz2*sizeof(double)) ;

        minmax (data, d_siz*d_siz, &minv, &maxv, &imin, &imax) ;

	
        for (ii=0;ii<d_siz2;ii++) 
	{
	     if (data[ii]<minv || data[ii]<-minv)
	         w[ii]=0.0 ;
	     else
	       /*w[ii]=pow(data[ii],0.5) ;*/ w[ii]=1.0;

	     /* blank out around image B */
	     iy=ii/d_siz;
	     ix=ii-iy*d_siz;
	     if (hypot((double)ix-159.5,(double)iy-80.5)<6.5)
	       w[ii]=0.0 ;
	}

	/*	for (ii=0;ii<d_siz2;ii++) w[ii]=1.0 ;*/
	/*	  w[ii]=0.01+0.01*sqrt(abs(data[ii]));*/

	/* blank around images */
	/*	
	for (j=0;j<im->ncomp;j++)
	  for (ix=0;ix<d_siz;ix++)
	    for(iy=0;iy<d_siz;iy++)
	      if (hypot(im->ra[j]-(double)ix,im->dec[j]-(double)iy)<10.0)
		w[iy*d_siz+ix]=0.0;
	*/
    }
    fitsout ("igloo_weight.fits",d_siz,d_siz,w);
    return w ;
}
