#include "gdefs.h"
#include "gpgdefs.h"
#include "gsl/gsl_multimin.h"

IGDEF

struct sersic
{
  double peak ;
  double cx ;
  double cy ;
  double r_e ;
  double axrat ;
  double theta ;
  double sindex ;
  double psfx ;
  double psfy ;
  double psfpeak ;
} ;
typedef struct sersic Sersic ;

double getmod (int, int, Sersic *, Sersic *) ;
double gwdp_optimize(Sersic *, Sersic *) ;
double gwdp_func (const gsl_vector *, void *) ;

double *data, *psf, *w, dhscale ;
int d_siz, d_siz2, psf_siz ;

double gwdp (double *p)
{
  Sersic ser, ser2 ;
    static double dscale, wscale, *data_sort, galcenx,galceny ;
    static int been_here, idmax, idmin ;
    double *ff, dmax, dmin, pmax, pmin, minv, maxv, x, y, *temp_psf,
      scenx, sceny, *sdata,radius,sx,sy,goodness,xcen,ycen,oldix,oldiy; 
    int ii,imin,imax,idx,idx1,ix,iy,i,j,k;
    char data_file[1024], psf_file[1024], dfile[1024]="\0", wfile[1024]="\0" ;
    
    if (h->reg>0.0) radius=h->reg; else radius=1.0 ;
    dhscale = 1.0 ;
    if (!been_here || !p)
    {
      /*
printf (" Enter name of data file: ") ;    scanf ("%s", data_file) ;
printf (" Enter name of psf file: ") ;     scanf ("%s", psf_file) ;
printf (" Model file name (or ^D for current model): ") ;scanf ("%s", dfile) ;
      */
/*
printf (" Error file (or ^D to use crude estimate): ") ;scanf ("%s", wfile) ;
      */
        been_here = 1 ;
	strcpy (data_file,"0128_LEVN.FITS") ;
	strcpy (psf_file, "0128_LEVN.PSF") ;
	strcpy (dfile, "0128_opt.igl") ;
        strcpy (wfile, "") ;

        if (!(psf = fitsin (psf_file, &psf_siz, &dscale)) || 
            !(data = fitsin (data_file, &d_siz, &dscale))) 
            { printf ("Not found\n"); return VERYBIG ; }
        d_siz2 = d_siz * d_siz ;

	if (strlen(dfile)>0) ginput (dfile) ;
        free(data_sort) ;
	/*
        printf (" x coordinate (pixels) of the galaxy in the FITS file:") ;
	scanf ("%lf", &galcenx) ;
        printf (" y coordinate (pixels) of the galaxy in the FITS file:") ;
	scanf ("%lf", &galceny) ;
	*/
        galcenx = 154.725; galceny=132.815;
        printf ("wd: data scale %f, image scale %f\n",dscale,h->a) ;
        dhscale = h->a/dscale ;
        printf ("wd: rescaling image plane by %f\n", dhscale) ;

        /* rescale the psf */

        temp_psf = (double *)malloc(psf_siz*psf_siz*sizeof(double));
        xcen=ycen=(double)psf_siz/2.0 ;
        for (ix=0;ix<psf_siz;ix++)
	{
            for (iy=0;iy<psf_siz;iy++)
	    {
		idx=iy*psf_siz+ix;
                oldix=xcen+dhscale*((double)ix-xcen);
                oldiy=xcen+dhscale*((double)iy-ycen);
                temp_psf[idx]=linterp(psf,oldix,oldiy,psf_siz,psf_siz);
	    }
	}
        for (ix=0;ix<psf_siz;ix++)
            for (iy=0;iy<psf_siz;iy++)
 	        psf[iy*psf_siz+ix]=temp_psf[iy*psf_siz+ix];
        
        /* rescale the parameters of the galaxy for the new image scale */

        for (ii=h->ngal-1;ii>=0;ii--)
        {
            g[ii].par[NGX]=galcenx+(g[ii].par[NGX]-g[0].par[NGX])*dhscale;
            g[ii].par[NGY]=galceny+(g[ii].par[NGY]-g[0].par[NGY])*dhscale;
            g[ii].par[NGB] *= dhscale ;
            g[ii].par[NGS] *= dhscale ;
            printf ("wd: Adjusted galaxy %i to (%f,%f), ER%f\n", ii, 
		    g[ii].par[NGX],g[ii].par[NGY],g[ii].par[NGB]);
            gfill (&g[ii]) ;
        }

        h->a = dscale ;
        pfill (&h->papix, h->a*1000.0, BROWN) ;
        h->ims = d_siz ;
        a = (double *) realloc (a,h->ims*h->ims*sizeof(double)) ;
        pifill (&h->pims, h->ims, BROWN) ;
        printf ("wd: setting plot grid to %dx%.2f\n", h->ims, h->a*1000.0) ;

        if (!h->docore)
        {
            h->docore = 1 ;
            pifill (&h->pdocore, h->docore, BROWN) ;  
        }
        minmax (psf, psf_siz*psf_siz, &pmin, &pmax, &idmin, &idmax) ;
        minmax (data, d_siz2, &dmin, &dmax, &idmin, &idmax) ;

        printf ("wd: Image grid %d mas (%dx%d); source grid %d mas (%dx%d)\n",
            d_siz*(int)(1000.0*h->a), d_siz, (int)(1000.0*h->a),
            h->spix*(int)(1000.0*h->sscale), h->spix, (int)(h->sscale*1000.0)) ;
    }
    if (p) loadfromp (p, 0) ;
    
    /* find brightest pixel in image, project back to source plane, determine 
   offset from source plane centre in arcseconds, convert to sp pixel size  */

    y = (double)(idmax/d_siz) ;
    x = (double)(idmax-d_siz*(idmax/d_siz)) ;
    gcsm (x, y, s[0].par[NSZ]) ;
    scenx = x - h->xoff ;
    sceny = y - h->yoff ;

    if (!p) printf ("wd: bright pix in image (%.1f,%.1f) -> (%.1f,%.1f)\n",
                    x,y,scenx,sceny) ;

    w = getweight (data, d_siz2, "", scenx, sceny) ;
 /*   -------- this is for 0712 ----------------
    ser.cx = 94.0;ser.cy = 98.0; ser.r_e=4.0; ser.peak = 0.5; ser.sindex=1.0;
    ser.axrat=0.3;ser.theta=40.0;ser.psfx=ser.cx;ser.psfy=ser.cy;
    ser.psfpeak=10.0;
 */
    printf ("Setting sersic in gwdp\n");
    ser.cx = scenx; ser.cy = sceny; ser.peak=0.1 ; ser.r_e=1.0;
    ser.sindex=0.5;ser.axrat=0.3;ser.theta=40.0;
    ser.psfx=ser.cx;ser.psfy=ser.cy;ser.psfpeak=0.1;
    ser2.cx = scenx; ser2.cy = sceny; ser2.peak=0.0 ; ser2.r_e=0.001;
    ser2.sindex=0.5;ser2.axrat=1.0;ser2.theta=0.0;
    ser2.psfx=ser.psfy;ser2.psfy=ser.psfy;ser2.psfpeak=0.0;
    goodness = gwdp_optimize (&ser, &ser2) ;

    screen (FULL) ;
    printf ("%f\n", goodness) ;
    return goodness ;
}

double getmod (int ix, int iy, Sersic *s1, Sersic *s2)
{    
  double sinth = sin(s1->theta), costh = cos(s1->theta),ex,ey,val=0.0,
    r[4] = {-sinth,costh,-costh,-sinth},rt[4] = {-sinth,-costh,costh,-sinth},
     sig[4] = {s1->r_e,0.0,0.0,s1->r_e*s1->axrat},scra[4],scrb[4] ;
  double sinth2 = sin(s2->theta), costh2 = cos(s2->theta),
    r2[4] = {-sinth2,costh2,-costh2,-sinth2},
    rt2[4] = {-sinth2,-costh2,costh2,-sinth2},
      sig2[4] = {s2->r_e,0.0,0.0,s2->r_e*s2->axrat},x,y;

    x = (double)ix - s1->cx; y = (double)iy - s1->cy ;
    mxmul(sig,r,scra);
    mxmul(rt,scra,scrb);
    mxinv(scrb,scra);
    ex=scra[0]*x+scra[1]*y;
    ey=scra[2]*x+scra[3]*y;
    val=(s1->peak/s1->axrat)*exp(-pow(hypot(ex,ey)/s1->r_e,s1->sindex));
    /*
    if (ix==201 && iy==158)
        printf ("val1: %f ",val) ;
    x = (double)ix - s2->cx; y = (double)iy - s2->cy ;
    if (s2->axrat<0.99 || s2->axrat>1.01)
    {
        mxmul(sig2,r2,scra);
        mxmul(rt2,scra,scrb);
        mxinv(scrb,scra);
        ex=scra[0]*x+scra[1]*y;
        ey=scra[2]*x+scra[3]*y;
        val+=(s2->peak/s2->axrat)*exp(-pow(hypot(ex,ey)/s2->r_e,s2->sindex));
    }
    else
    {
        val+=s2->peak*exp(-pow(hypot(x,y)/s2->r_e,s2->sindex));
    }
    */
    return val ;
}

double gwdp_optimize(Sersic *ser, Sersic *ser2)
{
    size_t niter=0 ;
    double amosize, chi, oldchi=VERYBIG ;
    const gsl_multimin_fminimizer_type *T=gsl_multimin_fminimizer_nmsimplex ;
    gsl_vector *ss, *x ;
    gsl_multimin_fminimizer *S=NULL ;
    gsl_multimin_function my_func ;
    int i,j,status,ndim = 8 ;
    double par[2]={1.0,2.0};
    ss=gsl_vector_alloc(ndim);
    x=gsl_vector_alloc(ndim);
    gsl_vector_set (x,0,ser->cx);
    gsl_vector_set (x,1,ser->cy);
    gsl_vector_set (x,2,ser->peak);
    gsl_vector_set (x,3,ser->r_e);
    gsl_vector_set (x,4,ser->axrat);
    gsl_vector_set (x,5,ser->theta);
    gsl_vector_set (x,6,ser->sindex);
    gsl_vector_set (x,7,ser->psfpeak);
    /*
    gsl_vector_set (x,7,ser2->peak);
    gsl_vector_set (x,8,ser2->r_e);
    gsl_vector_set (x,9,ser2->sindex);
    */

    gsl_vector_set (ss,0,1.0);
    gsl_vector_set (ss,1,1.0);
    gsl_vector_set (ss,2,0.1*ser->peak);
    gsl_vector_set (ss,3,0.1*ser->r_e);
    gsl_vector_set (ss,4,0.1*ser->axrat);
    gsl_vector_set (ss,5,0.1*ser->theta);
    gsl_vector_set (ss,6,0.1*ser->sindex);
    gsl_vector_set (ss,7,0.1*ser->psfpeak);
    /*
    gsl_vector_set (ss,7,0.1*ser2->peak);
    gsl_vector_set (ss,8,0.1*ser2->r_e);
    gsl_vector_set (ss,9,0.1*ser2->sindex) ;
    */
    my_func.f = &gwdp_func ;
    my_func.n = ndim ;
    my_func.params = par ;

    S = gsl_multimin_fminimizer_alloc (T,ndim) ;
    gsl_multimin_fminimizer_set (S, &my_func, x, ss) ;
    do
    {
        niter++ ;
        if (status = gsl_multimin_fminimizer_iterate (S)) break ;
        amosize = gsl_multimin_fminimizer_size (S) ;
        status = gsl_multimin_test_size (amosize, FTOL) ;
	/*
        for (i=0;i<ndim;i++) printf ("%.2f ", gsl_vector_get (S->x,i)) ;
        printf ("->%.2f (SS=%.2g), %d, %d\n", S->fval, amosize,status,niter) ;
	*/
        fflush(stdout);
    }
    while (status==GSL_CONTINUE && niter<1000) ;
    gsl_vector_free (x) ;
    gsl_vector_free (ss) ;
    gsl_multimin_fminimizer_free (S) ;
    return chi ;
}

double gwdp_func (const gsl_vector *v, void *pp)
{
    FILE *fo, *fopen() ;
    Sersic ser, ser2 ;
    Obs *im ;
    static int count;
    char outfile[1024];
    int ix, iy, idx, imin, imax, i ;
    double tr[6]={0.0,1.0,0.0,0.0,0.0,1.0},*pdata,add,xdist,ydist,psfhalf;
    double sx, sy, minv, maxv, *ldata, *lldata, *sdata, *chisq, *dw, 
      *model,goodness, xs, ys ;
    ldata = (double *) malloc (d_siz2*sizeof (double)) ;
    lldata = (double *) malloc (d_siz2*sizeof (double)) ;
    pdata = (double *) malloc (d_siz2*sizeof (double)) ;
    model = (double *) malloc (d_siz2*sizeof (double)) ;
    dw = (double *) malloc (d_siz2*sizeof (double)) ;
    sdata = (double *) malloc (h->spix*h->spix*sizeof(double));
    chisq = (double *) malloc (d_siz2*sizeof (double)) ;
    for (i=0;i<d_siz2;i++) dw[i] = (w[i]<1.0/VERYBIG)?0.0:data[i] ; 

    ser.cx = ser.psfx = ser2.cx = gsl_vector_get (v,0);
    ser.cy = ser.psfy = ser2.cy = gsl_vector_get (v,1);
    ser.peak = gsl_vector_get (v,2);
    ser.r_e = gsl_vector_get (v,3);
    ser.axrat = gsl_vector_get (v,4);
    ser.theta = gsl_vector_get (v,5);
    ser.sindex = gsl_vector_get (v,6);
    ser.psfpeak = gsl_vector_get (v,7);
    /*
    ser2.peak = gsl_vector_get (v,7);
    ser2.r_e = gsl_vector_get (v,8);
    ser2.sindex = gsl_vector_get (v,9);
    ser2.axrat = 1.0; ser2.theta = 0.0 ;
    */ 
    if (ser2.peak<0.0 || ser.peak<0.0) return VERYBIG ;

    for (i=0;i<d_siz*d_siz;i++) pdata[i]=0.0 ;

    for (ix=0;ix<d_siz;ix++)
    {
        for (iy=0;iy<d_siz;iy++)    
	{
	    idx=iy*d_siz+ix ;
            ldata[idx]=getmod(ix,iy,&ser,&ser2);
	}
    }


    for (ix=0;ix<d_siz;ix++)
    {
        for (iy=0;iy<d_siz;iy++)    
	{
	    idx=iy*d_siz+ix ;
	    gcsm ((double)ix, (double)iy, s[0].par[NSZ]) ;
            xs = (double)ix - h->xoff ;
            ys = (double)iy - h->yoff ;
            lldata[idx] = linterp (ldata, xs, ys, d_siz, d_siz) ;
	}
    }
    
    model = gwdp_convolve (lldata, psf) ;

    im = groot (ser.psfx,ser.psfy) ;
    for (ix=0;ix<d_siz;ix++)
    {
        for (iy=0;iy<d_siz;iy++)    
	{
            for (i=0;i<im->ncomp;i++)
	    {
	        xdist=(double)ix-im->ra[i];
	        ydist=(double)iy-im->dec[i];
                psfhalf=(double)psf_siz/2.0;
                add = ser.psfpeak*fabs(im->magtemp[i])*
		  linterp (psf,psfhalf+xdist,psfhalf+ydist,psf_siz,psf_siz);
  	        model[iy*d_siz+ix] += add ;
		/*                if (xdist*xdist<4.0 && ydist*ydist<4.0)
		  printf ("%d %.3f %.3f %f\n", i,im->magtemp[i],
		  linterp (psf,psfhalf+xdist,psfhalf+ydist,psf_siz,psf_siz),
                  add);*/

	    }
	}
    }

    sdata = (double *)malloc(h->spix*h->spix*sizeof(double));
    for (ix=0;ix<h->spix;ix++)
    {
	for(iy=0;iy<h->spix;iy++)
	{
	    idx=iy*h->spix+ix ;
            sx = h->sscale*((double)ix-(double)h->spix/2.0);
            sy = h->sscale*((double)iy-(double)h->spix/2.0);
            sdata[idx] = getmod(sx,sy,&ser,&ser2) ;
	}
    }

    goodness = 0.0;
    for (i=0;i<h->ims*h->ims;i++)
    {
        chisq[i] = (model[i]-data[i])*(model[i]-data[i]);  /* *w[i]; */
        chisq[i] /= ((7.2E-5)*(7.2E-5));
        goodness += chisq[i] ;
    }
    h->pxu = h->pyu = d_siz ;
    screen (WPLOT1) ;
    minmax (dw, d_siz*d_siz, &minv, &maxv, &imin, &imax) ;
    printf ("\nData: range %f-%f\n",minv,maxv) ;
    pg_dgray (dw,d_siz,d_siz,1,d_siz,1,d_siz,-0.0001,0.002,tr);
    screen (WPLOT2) ;
    minmax (model, d_siz*d_siz, &minv, &maxv, &imin, &imax) ;
    printf ("Model: range %f-%f\n",minv,maxv) ;
    pg_dgray (model,d_siz,d_siz,1,d_siz,1,d_siz,-0.0001,0.002,tr);
    screen (WPLOT3) ;
    minmax(sdata,h->spix*h->spix,&minv,&maxv,&imin,&imax);
    h->pxu=h->spix;h->pyu=h->spix;h->pxl=h->pyl=1.0;
    pg_dgray(sdata,h->spix,h->spix,1,h->spix,1,h->spix,minv,maxv,tr);
    h->pxu=h->pyu=d_siz;h->pxl=h->pyl=1.0;
    screen (WPLOT4) ;
    minmax (chisq, d_siz*d_siz, &minv, &maxv, &imin, &imax) ;
    pg_dgray (chisq,d_siz,d_siz,1,d_siz,1,d_siz,minv,minv+0.1*(maxv-minv),tr);

    free(ldata);free(pdata);free(model);free(dw);free(sdata);free(chisq);
    free(lldata);
    fitsout ("gwdp_model.fits", d_siz, d_siz, model);
    fitsout ("gwdp_chisq.fits", d_siz, d_siz, chisq);
    printf ("%7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f ->%7.4f\n",
	    ser.cx,ser.cy,ser.peak,ser.r_e,ser.axrat,ser.theta,ser.sindex,
	    ser.psfpeak,ser2.r_e,ser2.sindex,goodness/(float)(d_siz*d_siz));

    return goodness/(float)(d_siz*d_siz) ;
}

double *gwdp_convolve (double *ip, double *conv)
{   /* done the lazy way by python */
    FILE *fo, *fopen() ;
    static double *out ;
    static int count ;
    int asiz ;
    double ascale ;
    out = (double *) malloc (h->ims*h->ims*sizeof(double)) ;
    system("rm tmp_in.fits") ;
    system ("rm tmp_psf.fits") ;
    system ("rm tmp_out.fits") ;
    fitsout ("tmp_in.fits", h->ims, h->ims, ip) ;
    fitsout ("tmp_psf.fits", psf_siz,psf_siz, conv) ;
    fo = fopen("tmp.py", "w") ;
    fprintf (fo, "import njj\nimport pyfits\nfrom pyfits import getdata\n");
    fprintf (fo, "import matplotlib\nfrom matplotlib import pyplot as plt\n");
    fprintf (fo, "import numpy as np\n") ;
    fprintf (fo, "a=np.asarray(getdata('tmp_in.fits'),dtype='f')\n") ;
    fprintf (fo, "b=np.asarray(getdata('tmp_psf.fits'),dtype='f')\n") ;
    fprintf (fo, "c=njj.convolve(a,b)\n") ;
    fprintf (fo, "plt.subplot(131);plt.imshow(a)\n");
    fprintf (fo, "plt.subplot(132);plt.imshow(b)\n");
    fprintf (fo, "plt.subplot(133);plt.imshow(c)\n");
    /*    fprintf (fo, "plt.savefig('debugpic%03d')\n",count++) ;*/
    fprintf (fo, "pyfits.writeto('tmp_out.fits',c)\n") ;
    fclose(fo);
    system ("python tmp.py") ;
    out = fitsin ("tmp_out.fits", &asiz, &ascale) ;
    return out ;
}
