#include "gsl/gsl_linalg.h"
#include "gsl/gsl_errno.h"
#include "gdefs.h"
#include "gpgdefs.h"

IGDEF

double gsvd ()
{
    int j=0,i=0,dim=4+3*h->o.ncomp, icomp,is; long idum ; char ch, oldopt ;
    double y[MAXOPT], yb=VERYBIG, *nullp = NULL ;
    
    h->prm[0][0] = g[0].par[NGX] ;
    h->prm[1][0] = 0.3*g[0].par[NGXERR] ;
    h->prm[0][1] = g[0].par[NGY] ;
    h->prm[1][1] = 0.3*g[0].par[NGYERR] ;
    h->prm[0][2] = g[0].par[SM] ;
    h->prm[1][2] = 0.03*g[0].par[SM] ;
    h->prm[0][3] = g[0].par[SA] ;
    h->prm[1][3] = 3.0 ;

    for (i=4;i<dim;i+=3)
    {
        for (is=0;is<h->nsrc;is++)
	{
  	     for (icomp=0;icomp<h->o.ncomp;icomp++)
	     {
                 if (is+1==h->o.sno[icomp])
		 {
    	             h->prm[0][i] = h->o.ra[icomp] ;
                     h->prm[1][i] = 0.3*h->o.errmaj[icomp] ;
    	             h->prm[0][i+1] = h->o.dec[icomp] ;
    	             h->prm[1][i+1] = 0.3*h->o.errmaj[icomp] ;
    	             h->prm[0][i+2] = h->o.flux[icomp] * (double)h->o.parity[icomp] ;
    	             h->prm[1][i+2] = 0.3*h->o.fluxerr[icomp] ;
                     i+=3 ;
                 }
	     }
        }
    }
    if (!h->svdwiggle) return (calcsvd (h->prm[0])) ;
    h->doupdate = 0 ; h->noisy = h->usep = h->usedim = 1 ;  h->dim = dim ;
    oldopt = h->doopt ; h->doopt='V' ;

    for(;;)
    {
    	gamoeba (calcsvd) ;
    	printf ("do you want more amoebas?: ") ; fflush (stdout) ;
    	scanf ("%c", &ch) ;
    	scanf ("%c", &ch) ;
    	if (ch=='n') break ;
    }

    h->doopt = oldopt ;
    g[0].par[NGX] = h->prm[0][0] ;    g[0].par[NGY] = h->prm[0][1] ;
    g[0].par[SM] = h->prm[0][2] ;     g[0].par[SA] = h->prm[0][3] ;
    gfill (&g[0]) ;
    h->usep = h->usedim = 0 ; h->doupdate = 1 ; h->noisy = 2 ;
    printf ("("); for (j=0;j<dim;j++) printf ("%.2f ",h->prm[0][j]);
    printf(")->%f, efunk %f\n ", (yb=calcsvd (h->prm[0])), efunk(nullp)) ;
    h->noisy = 0 ;
    return yb ;
}

double calcsvd (double *p)
{
    int i, j, jx, l, is, icomp, index, dim = 3*h->o.ncomp-h->nsrc,
          n=h->o.ncomp, i1st, howmany[MAXS], nsing=0, sing[MAXOPT] ;
    double c[dim*dim], d[dim], xx[dim], goodness=0.0,
          th, og[200], ogmean, fk, xcoord, ycoord, val ;

    for (is=0;is<MAXS;is++) howmany[is] = 0 ;
    if (fabs((p[0]-g[0].par[NGX])/g[0].par[NGXERR]) > 3.0) return VERYBIG ;
    if (fabs((p[1]-g[0].par[NGY])/g[0].par[NGYERR]) > 3.0) return VERYBIG ;
    if (g[0].par[SMERR]>0.0 && g[0].par[SMERR]<=1.0 &&
        g[0].par[SAERR]>0.0 && g[0].par[SAERR]<=90.0 &&
    	(fabs((p[2]-g[0].par[SM])/g[0].par[SMERR]) > 3.0 ||
    	 fabs((p[3]-g[0].par[SA])/g[0].par[SAERR]) > 3.0)) return VERYBIG ;
    
    for (i=0;i<n;i++)
    {
    	index = aix (h->o.sno[i]-1, howmany[h->o.sno[i]]) ;
        if (fabs((p[index]-h->o.ra[i])/h->o.errmaj[i]) > 3.0) return VERYBIG ;
        if (fabs((p[index+1]-h->o.dec[i])/h->o.errmaj[i]) > 3.0) return VERYBIG ;
        if (fabs((p[index+2]-(double)h->o.parity[i]*h->o.flux[i])/h->o.fluxerr[i]) > 3.0) return VERYBIG ;
        howmany[h->o.sno[i]]++ ;
    }
    for (i=j=l=is=0;is<h->nsrc;is++)
    {
        l=0 ;
        for (icomp=0;icomp<h->o.ncomp;icomp++)
	{
  	    if (is+1==h->o.sno[icomp])
	    {
	        for (j=0;j<2*h->nsrc;j++) c[i*dim+j]=0.0 ;
                c[i*dim+2*is]=1.0 ;
                c[i*dim+2*h->nsrc] = svg1 (p, 0, l, is, SVALPHA) ;

                for (jx=0,j=2*h->nsrc+1;j<3*h->o.ncomp-1;jx++,j++)
		    c[i*dim+j] = ((jx/2)*2==jx) ?
		             svg1 (p, 2+(jx/2), l, is, SVALPHA)
		           : svg1 (p, 2+(jx/2), l, is, SVBETA) ;

                d[i] = svg1 (p, 0, l, is, SVRCOST) ;
                i++ ; l++ ;
	    }
	}
        l=0 ;
        for (icomp=0;icomp<h->o.ncomp;icomp++)
	{
  	    if (is+1==h->o.sno[icomp])
	    {
	        for (j=0;j<2*h->nsrc;j++) c[i*dim+j]=0.0 ;
                c[i*dim+2*is+1]=1.0 ;
                c[i*dim+2*h->nsrc] = svg1 (p, 0, l, is, SVAHAT) ;

                for (jx=0,j=2*h->nsrc+1;j<3*h->o.ncomp-1;jx++,j++)
		    c[i*dim+j] = ((jx/2)*2==jx) ?
		             svg1 (p, 2+(jx/2), l, is, SVAHAT)
		           : svg1 (p, 2+(jx/2), l, is, SVBHAT) ;

                d[i] = svg1 (p, 0, l, is, SVRSINT) ;
                i++ ; l++ ;
	    }
	}
    }
    for (is=0;is<h->nsrc;is++)
    {
        l=i1st=1 ;
        for (icomp=0;icomp<h->o.ncomp;icomp++)
	{
  	    if (is+1==h->o.sno[icomp])
	    {
	    	if (i1st) i1st=0 ;
	    	else
	    	{
	            for (j=0;j<2*h->nsrc;j++) c[i*dim+j]=0.0 ;
                    c[i*dim+2*h->nsrc] = svg1 (p,  0, l, is, SVGAMMA) ;
                    jx=0 ;
                    for (j=2*h->nsrc+1;j<3*h->o.ncomp-1;j++)
		    {
		        if ((jx/2)*2==jx)
		            c[i*dim+j] = svg1 (p, 2+(jx/2), l, is, SVGAMMA) ;
		        else
		            c[i*dim+j] = svg1 (p, 2+(jx/2), l, is, SVDELTA) ;
		        jx++ ;
		    }
                    d[i] = svg1 (p, 0, l, is, SVFR) ;
                    i++ ; l++ ;
		}
	    }
	}
    }

    h->chucksing = 1 ;
    nsing = getsvd (c, d, sing, dim, xx) ;
    if (nsing == -1) return VERYBIG ; /* svdcmp exceeded 30 iterations */

    for (ogmean=th=0.0,j=0;j<200;th+=PI/100.0,j++)
    {
        og[j]=xx[2*h->nsrc] ;
        for (i=2*h->nsrc+2;i<=dim-nsing;i++)
        {
            fk=(double)((i-2*(h->nsrc-1))/2) ;
            if (2*(i/2)==i)
                og[j]+=xx[i-1]*(1.0-fk*fk)*cos(fk*th) ;
            else
                og[j]+=xx[i-1]*(1.0-fk*fk)*sin(fk*th) ;
        }
        ogmean += og[j]/200.0 ;
    }

    if (h->svdwiggle<2)
         for (i=2*h->nsrc+2;i<dim-nsing;i++) goodness += pow (1000.0*xx[i], 2.0) ;
    else for (j=0;j<200;j++)  goodness += (og[j]-ogmean)*(og[j]-ogmean) ;
    goodness = sqrt (goodness);
    
    if ((h->noisy > 1||!h->svdwiggle)&&goodness<=VERYBIG-1.0)
    {
        printf ("\n*** goodness %f; there were %d singular values ", goodness,nsing) ;
        for (j=0;j<nsing;j++) printf (" %d", sing[j]) ; printf ("\n") ;
        pg_sci (GREEN) ;
        screen (WPLOTP) ;
        for (j=0,th=0.0;j<200;j++,th+=PI/100.0)
        {
            xcoord = p[0] + g[0].par[NGB]*og[j]*cos(th) ;
            ycoord = p[1] + g[0].par[NGB]*og[j]*sin(th) ;
            if (th==0.0) pg_move (xcoord, ycoord) ;
            else         pg_draw (xcoord, ycoord) ;
        }
        fflush (stdout) ;
    }
    screen (FULL) ;
    return goodness ;
}

int getsvd (double *c, double *d, int *sing, int dim, double *xx)
{
  /* crash is something to do with this routine not calling routine?
     tried taking almost everything out of gwds, still crashes on 2nd
     call. gwd is OK unless gwds is called first */
    int nsing=0, i=0,j=0, status=0 ;
    double val ;
    double gwmax ;
    gsl_vector *gwork, *gs, *gb, *gx ;
    gsl_matrix *gu, *gv ;

    gu = gsl_matrix_alloc (dim, dim) ;
    gs = gsl_vector_alloc (dim) ;
    gb = gsl_vector_alloc (dim) ;
    gx = gsl_vector_alloc (dim) ;
    gv = gsl_matrix_alloc (dim, dim) ;
    gwork = gsl_vector_alloc (dim) ;
    for (i=0;i<dim;i++) for (j=0;j<dim;j++) 
         gsl_matrix_set (gu,i,j,(double)c[i*dim+j]);
    for (i=0;i<dim;i++) gsl_vector_set (gb, i, (double)d[i]) ;
    status = gsl_linalg_SV_decomp (gu, gv, gs, gwork) ;
    if (isnan(*gu[0].data)) {printf("\n\n**** GSL routine crash ****\n\n");}
    if (status) printf ("error 1: %s\n", gsl_strerror (status)) ;
    gwmax = gsl_vector_max (gs) ;
    for (i=0;i<dim;i++)
    {
        if (gsl_vector_get (gs, i)<gwmax*pow(10.0,h->svsing))
	{
	    sing[nsing++] = i ;
            gsl_vector_set(gs, i, 0.0) ;
	}
    }
    if (nsing && h->chucksing)
    {
        gsl_matrix_free (gu) ;
        gsl_matrix_free (gv) ;
        gsl_vector_free (gs) ;
        gsl_vector_free (gb) ;
        gsl_vector_free (gx) ;
        gsl_vector_free (gwork) ;
        gu = gsl_matrix_alloc (dim, dim-nsing) ;
        gs = gsl_vector_alloc (dim-nsing) ;
        gb = gsl_vector_alloc (dim) ;
        gx = gsl_vector_alloc (dim-nsing) ;
        gv = gsl_matrix_alloc (dim-nsing, dim-nsing) ;
        gwork = gsl_vector_alloc (dim-nsing) ;
        for (i=0;i<dim;i++) for (j=0;j<dim-nsing;j++) gsl_matrix_set (gu, i, j, (double)c[i*dim+j]);
        for (i=0;i<dim;i++) gsl_vector_set (gb, i, (double)d[i]) ;
        status = gsl_linalg_SV_decomp (gu, gv, gs, gwork) ;
        if (status) printf ("error 3: %s\n", gsl_strerror (status)) ;
    }
    status = gsl_linalg_SV_solve (gu, gv, gs, gb, gx) ;
    if (status) printf ("error 4: %s\n", gsl_strerror (status)) ;
    for (i=0;i<dim-nsing;i++) xx[i] = (double) gsl_vector_get (gx, i) ;

    gsl_matrix_free (gu) ;
    gsl_matrix_free (gv) ;
    gsl_vector_free (gs) ;
    gsl_vector_free (gb) ;
    gsl_vector_free (gx) ;
    gsl_vector_free (gwork) ;

    if ((h->noisy > 1||!h->svdwiggle) && h->doopt != 'W')
    {
        printf ("\nx: ") ;  for (i=0;i<dim-nsing;i++) printf ("%.3f ", xx[i]) ;
        printf ("\nd: ") ;  for (i=0;i<dim-nsing;i++) printf ("%.3f ", d[i]) ;
        printf ("\nCx: ") ;
    
        for (i=0;i<dim;i++)
        {
            val = 0.0 ; for (j=0;j<dim-nsing;j++) val+=c[i*dim+j]*xx[j] ;
            printf ("%.3f ", val) ;
        }
    }
    fflush (stdout) ;

    return nsing ;
}

double svg1 (double *p, int k, int l, int is, int code)
{
    double fk = (double) k, f1l, r1, rl, t, t1, w1, wl ;
    double g1 =  p[2]*sin(2.0*p[3]*R2D) ;
    double g2 =  p[2]*cos(2.0*p[3]*R2D) ;
    int pb = aix (is, l) , pb1 = aix (is, 0) ;
    rl = h->a*hypot(p[pb+1]-p[1],p[pb]-p[0]) ;
    r1 = h->a*hypot(p[pb1+1]-p[1],p[pb1]-p[0]) ;
    t =  gatan(p[pb+1]-p[1],p[pb]-p[0]) ;
    t1 = gatan(p[pb1+1]-p[1],p[pb1]-p[0]) ;
    f1l = p[pb1+2]/p[pb+2] ;
    w1 = 1+g1*cos(2*t1)+g2*sin(2*t1) ;
    wl = 1+g1*cos(2*t)+g2*sin(2*t) ;
    if (code==SVALPHA) return (cos(t)*cos(fk*t)+fk*sin(t)*sin(fk*t)) ;
    if (code==SVAHAT)  return (sin(t)*cos(fk*t)-fk*cos(t)*sin(fk*t)) ;
    if (code==SVBETA)  return (cos(t)*sin(fk*t)-fk*sin(t)*cos(fk*t)) ;
    if (code==SVBHAT)  return (sin(t)*sin(fk*t)+fk*cos(t)*cos(fk*t)) ;
    if (code==SVGAMMA) return ((1-fk*fk)*(f1l*rl*cos(k*t1)*w1-r1*cos(k*t)*wl)) ; 
    if (code==SVDELTA) return ((1-fk*fk)*(f1l*rl*sin(k*t1)*w1-r1*sin(k*t)*wl)) ;
    if (code==SVRCOST) return ((1.0+g1)*rl*cos(t)+g2*rl*sin(t)) ;
    if (code==SVRSINT) return ((1.0-g1)*rl*sin(t)+g2*rl*cos(t)) ;
    if (code==SVFR)    return ((f1l-1.0)*r1*rl*(1-g1*g1-g2*g2)) ;
    printf ("Unknown code, help.\n") ;
}

int aix (int is, int icomp)
{
    int i, j, jx, pb=0, ai[MAXS][MAXCOMP] ;
    for (i=0;i<h->nsrc;i++)
    	for (jx=j=0;j<h->o.ncomp;j++)
            if (h->o.sno[j]==i+1) ai[i][jx++] = pb++ ;
    return (4+3*ai[is][icomp]) ;
}
