#include "gdefs.h"
#include "gpgdefs.h"
#include "gsl/gsl_vector.h"
#include "gsl/gsl_multiroots.h"

IGDEF
struct rparams { double px ; double py ; } ;
int get_alpha (const gsl_vector *, void *, gsl_vector *) ;
void get_im (Obs *, double, double, double, double, double, double) ;

Obs *groot (double sx, double sy)
{
    static Obs im ;
    Obs imcore, imtemp ;
    int iim=0, igal, i=0, j=0, itmag, rim,
         ignorecore=(float)(IGNORECORE*(float)h->ims/128.0);
    double xdist, ydist, dist, searchcore, mag, tmag=VERYBIG ;

    for (i=0;i<MAXCOMP;i++) im.sno[i] = 0 ;
    get_im (&im, h->ims/2, h->ims/2, h->ims, h->ims, sx, sy) ;

    /*    printf ("input %.2f %.2f, gal %.2f %.2f %.2f %.2f %.2f %.3f %.2f\n",
            sx, sy, g[0].par[NGX],g[0].par[NGY],g[0].par[NGB],
            g[0].par[NGTH],g[0].par[NGE],g[0].par[SM],g[0].par[SA]);*/
    
    for (iim=0;iim<im.ncomp;iim++)
    {
        im.iscore[iim] = -1 ;
    	for (igal=0;igal<h->ngal;igal++)
    	{
    	    /* for each gal, if there is an image within IGNORECORE*ims/128 
               of it then it is a core image */
    		
	    if (hypot(im.ra[iim]-g[igal].par[NSX],
		      im.dec[iim]-g[igal].par[NSY]) < ignorecore)
	        im.iscore[iim] = igal ;
	}
        if (im.iscore[iim] == -1)
	  refine_im (&im, sx, sy, iim);
    }

    if (!h->docore)    /* eliminate core images if we don't want them */
    {
        for (i=0,j=0;i<im.ncomp;i++)     /* copy non-core to temp array */
	    if (im.iscore[i]==-1)
	      imcopy (&imtemp, j++, &im, i);
        imtemp.ncomp = im.ncomp = j;
        for (i=0;i<im.ncomp;i++)     /* put these back */
            imcopy (&im, i, &imtemp, i);
    }

    for (i=0;i<im.ncomp;i++)    /* identify very close images */
       for (j=i+1;j<im.ncomp;j++)
	  if (hypot (im.ra[i]-im.ra[j],im.dec[i]-im.dec[j])<0.0001)
   	        im.sno[j]=-1 ;
    for (i=0,j=0;i<im.ncomp;i++)     /* copy only non-close ones */
        if (!im.sno[i])
	  imcopy (&imtemp, j++, &im, i);
    imtemp.ncomp = im.ncomp = j;
    for (i=0;i<im.ncomp;i++)     /* put these back and evaluate mag */
    {
        imcopy (&im, i, &imtemp, i);
        gcsm (im.ra[i], im.dec[i], s[0].par[NSZ]);
        im.magtemp[i] = h->magn ;
    }

    return (&im) ;
}

void get_im (Obs *im,double xcen,double ycen,double xwid,double ywid, 
            double sx, double sy)
{
    double pr1,pr2,pr3,xcoord,ycoord,st[(int)h->divnum+1][(int)h->divnum+1][2];
    int j=0, k=0 ;
    
    for (j=0;j<MAXCOMP;j++) im->ra[j]=im->dec[j]=0.0 ;
    im->ncomp = 0 ;
    for (k=0;k<h->divnum+1;k++)
    {
        ycoord = ycen - ywid/2.0 + (double)k*ywid/h->divnum ;
        for (j=0;j<h->divnum+1;j++)
        {
            xcoord = xcen - xwid/2.0 + (double)j*xwid/h->divnum ;
            gcsm (xcoord, ycoord, s[0].par[NSZ]);
            st[j][k][0] = xcoord - h->xoff - sx ;
            st[j][k][1] = ycoord - h->yoff - sy ;
        }
    }
    for (k=0;k<h->divnum;k++)
    {
        ycoord = ycen - ywid/2.0 + (double)k*ywid/h->divnum ;
        for (j=0;j<h->divnum;j++)
        {
            xcoord = xcen - xwid/2.0 + (double)j*xwid/h->divnum ;
            pr1 = st[j][k][0]*st[j][k+1][1]-st[j][k][1]*st[j][k+1][0] ;
            pr2 = st[j][k+1][0]*st[j+1][k+1][1]-st[j][k+1][1]*st[j+1][k+1][0] ;
            pr3 = st[j+1][k+1][0]*st[j][k][1]-st[j+1][k+1][1]*st[j][k][0] ;
            if ((pr1>0.&&pr2>0.&&pr3>0.)||(pr1<0.&&pr2<0.&&pr3<0.))
            {
            	im->ra[im->ncomp] = xcoord+xwid*0.333/h->divnum ;
            	im->dec[im->ncomp] = ycoord+ywid*0.667/h->divnum ;
                im->ncomp++ ;
            }
            pr1 = st[j][k][0]*st[j+1][k+1][1]-st[j][k][1]*st[j+1][k+1][0] ;
            pr2 = st[j+1][k+1][0]*st[j+1][k][1]-st[j+1][k+1][1]*st[j+1][k][0] ;
            pr3 = st[j+1][k][0]*st[j][k][1]-st[j+1][k][1]*st[j][k][0] ;
            if ((pr1>0.&&pr2>0.&&pr3>0.)||(pr1<0.&&pr2<0.&&pr3<0.))
            {
            	im->ra[im->ncomp] = xcoord+xwid*0.667/h->divnum ;
            	im->dec[im->ncomp] = ycoord+ywid*0.333/h->divnum ;
                im->ncomp++ ;
            }
        }
    }
}

void refine_im (Obs *im, double sx, double sy, int imno)
{
    const gsl_multiroot_fsolver_type *T ;
    gsl_multiroot_fsolver *sol ;
    size_t i, iter = 0 ;
    int status ;
    const size_t n = 2 ;
    struct rparams p = { sx, sy } ;
    double x_init[2] = { im->ra[imno], im->dec[imno] } ;

    gsl_multiroot_function f = {&get_alpha, n, &p} ;
    gsl_vector *x = gsl_vector_alloc (n) ;
    gsl_vector_set (x, 0, x_init[0]) ;
    gsl_vector_set (x, 1, x_init[1]) ;
    T = gsl_multiroot_fsolver_dnewton ;
    sol = gsl_multiroot_fsolver_alloc (T, 2) ;
    gsl_multiroot_fsolver_set (sol, &f, x) ;

    do
    {
    	iter++ ;
    	status = gsl_multiroot_fsolver_iterate (sol) ;
    	if (status) break ;
    	status = gsl_multiroot_test_residual (sol->f, 1.e-7) ;
    }
    while (status == GSL_CONTINUE && iter < 1000) ;

    im->ra[imno] = gsl_vector_get (sol->x, 0) ;
    im->dec[imno] = gsl_vector_get (sol->x, 1) ;
    gsl_multiroot_fsolver_free (sol) ;
    gsl_vector_free (x) ;
}

int get_alpha (const gsl_vector *x, void *p, gsl_vector *f)
{
    double x0 = gsl_vector_get (x, 0) ;
    double x1 = gsl_vector_get (x, 1) ;
    gcsm (x0, x1, s[0].par[NSZ]) ;
    gsl_vector_set (f, 0, x0 - h->xoff - ((struct rparams *) p)->px) ;
    gsl_vector_set (f, 1, x1 - h->yoff - ((struct rparams *) p)->py) ;
    return GSL_SUCCESS ;
}
