#include "gdefs.h"
#include "gpgdefs.h"

IGDEF

void gplot ()
{
    int i=0, j=0 ;
    double bs[h->ims*h->ims], contour[NUM_CONT], white,black,plotx,ploty, 
       tr[6]={h->pxl-0.5*h->a,(h->pxu-h->pxl)/(float)h->ims,0.0,
              h->pyl-0.5*h->a,0.0,(h->pyu-h->pyl)/(float)h->ims } ;
    char xopt[5] = "BCST", yopt[5] = "BCST", pstr[64] ;

    screen (WPLOT) ;
    for (i=0; i<h->ims; i++)
        for (j=0; j<h->ims; j++)
           bs[j*h->ims+i] = a[j*h->ims+i] ;

    fitsout ("igloo_out.fits", h->ims, h->ims, a) ;

    qsort (bs, h->ims*h->ims, sizeof (double), sort_compf) ;

    if (h->lookup < 3) pg_sitf (h->lookup) ;
    
    if (h->docont == 0 || h->docont == 2)
    {
        screen (FULL) ;
        screen (WPLOT) ;
        if (h->zoom)
        {
            tr[1] = tr[5] = h->a ;
            tr[0] = tr[3] = -h->a*h->ims/2.0 ;
        }
        pg_dgray (a, h->ims, h->ims, 1, h->ims, 1, h->ims, 
                  bs[h->ims*h->ims/10] , bs[h->ims*h->ims-1], tr) ;
        pg_sci (7) ;
        if (h->lookup >=3) pg_box ("BCGNST", 0.0, 0, "BCGNST", 0.0, 0) ;
        else pg_box ("BCNST", 0.0, 0, "BCNST", 0.0, 0) ;
        pg_sci (0) ;
    }

    pg_box (xopt, 0.0, 0, yopt, 0.0, 0) ;

    if (h->docont)
    {
    	pg_sci(GREEN) ;
    	black = bs[0]; white = bs[h->ims*h->ims-1] ;
    	for (i=0;i<NUM_CONT;i++) contour[i] = 
         (float)(bs[0]+(double)i*(bs[h->ims*h->ims-1]-bs[0])/NUM_CONT) ;
        pg_dcont (a,h->ims,h->ims,1,h->ims,1,h->ims,contour,NUM_CONT,tr) ;
    }
    pg_sci (RED) ;

    screen (WPLOT) ;
    for (i=0; i<h->nsrc; i++)
    {
    	plotx = h->a * (s[i].par[NSX]-h->ims/2.0) ;
    	ploty = h->a * (s[i].par[NSY]-h->ims/2.0) ;
        pg_dpoint (1, &plotx, &ploty, 17) ;
        pg_dpoint (1, &plotx, &ploty, 24) ;

        if (h->o.ncomp)
        {
            for (j=0;j<h->o.ncomp; j++)
            {
                if (h->o.sno[j] == i+1)
                {
                    plotx = h->a * (s[i].par[NSX]-h->ims/2.0) ;
                    ploty = h->a * (s[i].par[NSY]-h->ims/2.0) ;
            	    pg_move (plotx, ploty) ;
                    if (h->o.xsa[j]>0.0&&h->o.ysa[j]>0.0&&
                        h->o.xsa[j]<h->ims&&h->o.ysa[j]<h->ims)
                    {
                        plotx = h->a * (h->o.xsa[j]-h->ims/2.0) ;
                        ploty = h->a * (h->o.ysa[j]-h->ims/2.0) ;
            	        pg_draw (plotx, ploty) ;
            	    }
            	}
            }
        }
    }
    pg_sci (GREEN) ;
    for (i=0; i<h->ngal; i++)
    {
    	plotx = h->a * (g[i].par[NGX]-h->ims/2.0) ;
    	ploty = h->a * (g[i].par[NGY]-h->ims/2.0) ;
        pg_dpoint (1, &plotx, &ploty, 17) ;
        pg_dpoint (1, &plotx, &ploty, 24) ;
    }
    for (i=0;i<h->o.ncomp; i++)
    {
        pg_sci ((h->o.parity[i]>0.0)?YELLOW:BROWN) ;
    	plotx = h->a * (h->o.ra[i]-h->ims/2.0) ;
	ploty = h->a * (h->o.dec[i]-h->ims/2.0) ;
        pg_dpoint (1, &plotx, &ploty, 9) ;
    }
    screen (FULL) ;
    mkrect (0.6,1.0,0.0,0.03,1,GREEN) ;
    sprintf (pstr, "plot range: %f-%f", black, white) ;
    pg_sci (BLACK) ;
    pg_text (0.6,0.002,pstr) ; 
    pg_sci (WHITE);
}

void gprint ()
{
    int i ;
    char label[256] ;
    pg_end();
    if (pg_begin(1,"/cps",0,0)!=PG_OK) pg_begin (1, "/null", 0, 0);
    screen (WPRINT) ;
    for (i=0;i<h->nsrc;i++) sfill (&s[i]) ;
    for (i=0;i<h->ngal;i++) gfill (&g[i]) ;
    g2image();
    gplot();
    gcrit();
    h->docont = 1 ;
    plotthings ("tdel") ;
    pg_text (0.1, 0.18, label) ;
    pg_text (0.1, 0.1, "igloo 30AUG03") ;
    h->docont = 0 ;
    pg_end();
    if (pg_begin (1, "/xwin ", 0, 0)!=PG_OK) pg_begin (1, "/null", 0, 0) ;
    screen (FULL) ;
    pinit (&s[0],&g[0]) ;
}

void screen (int type)
{
    pg_sch (0.9) ;
    pg_slw (3) ;
    switch (type)
    {
    	case FULL:
    	    pg_vport (0.0,1.0,0.0,1.0) ;
    	    pg_window (0.0,1.0,0.0,1.0) ;
    	    break ;
    	case WPLOT:
    	    pg_vport (XZSTA, XZSTA+BZS, YZSTA-X2YRATIO*BZS, YZSTA) ;
    	    pg_window (h->pxl, h->pxu, h->pyl, h->pyu) ;
    	    break ;
    	case WPLOTP:
    	    pg_vport (XZSTA, XZSTA+BZS, YZSTA-X2YRATIO*BZS, YZSTA) ;
    	    pg_window (1.0,h->ims,1.0,h->ims) ;
    	    break ;
    	case WPLOT1:
    	    pg_vport (XZSTA, XZSTA+0.5*BZS, YZSTA-0.5*X2YRATIO*BZS, YZSTA) ;
    	    pg_window (h->pxl,h->pxu,h->pyl,h->pyu) ;
    	    break ;
    	case WPLOT2:
    	    pg_vport (XZSTA+0.5*BZS, XZSTA+BZS, YZSTA-0.5*X2YRATIO*BZS, YZSTA) ;
    	    pg_window (h->pxl, h->pxu, h->pyl, h->pyu) ;
    	    break ;
    	case WPLOT3:
    	    pg_vport (XZSTA, XZSTA+0.5*BZS, YZSTA-X2YRATIO*BZS, YZSTA-0.5*X2YRATIO*BZS) ;
    	    pg_window (h->pxl, h->pxu, h->pyl, h->pyu) ;
    	    break ;
    	case WPLOT4:
    	    pg_vport (XZSTA+0.5*BZS, XZSTA+BZS, YZSTA-X2YRATIO*BZS, YZSTA-0.5*X2YRATIO*BZS) ;
    	    pg_window (h->pxl, h->pxu, h->pyl, h->pyu) ;
    	    break ;
    	case WPLOT5:
    	    pg_vport (XZSTA-BZS, XZSTA-0.5*BZS, YZSTA-1.5*X2YRATIO*BZS, YZSTA-X2YRATIO*BZS) ;
    	    pg_window (h->pxl, h->pxu, h->pyl, h->pyu) ;
    	    break ;
    	case WPRINT:
    	    pg_vport (0.027,0.973,0.0,1.0) ;
    	    pg_window (0.0,1.0,0.0,1.0) ;
    	    break ;
    }
}

void gtype (char *gngngn)
{
    char command[256] ;
    double x, y, *inva, detj, minmag = MINCOREMAG, plotx, ploty ;
    int i ;
    Obs *im ;

    if (strlen (gngngn))
    	strcpy (command, gngngn) ;
    else
    {
        printf ("Enter command: ") ;
        fflush(stdin);
        scanf ("%s", command) ;
    }
    
    if (!strncmp (command, "findsrc", 7))
    {
    	printf ("Enter x, y: ") ;
    	scanf ("%lf %lf", &x, &y) ;
    	gcsm (0.5*h->ims+x/h->a, 0.5*h->ims+y/h->a, s[0].par[NSZ]) ;
    	printf ("(%f,%f)->(%f,%f)\n", x, y, x-h->xoff*h->a,
    	                           y-h->yoff*h->a) ;
    }
    else if (!strncmp (command, "findim", 6))
    {
    	if (command[6]=='g')
    	{
    	    printf ("Enter x, y: ") ; fflush (stdout) ;
    	    scanf ("%lf %lf", &x, &y) ;  fflush (stdin) ;
	    im = groot (x/h->a+h->ims/2.0, y/h->a+h->ims/2.0) ;
    	}
    	else im = groot (s[0].par[NSX], s[0].par[NSY]) ;

	printf ("Galaxy 0 position: %+f %+f\n", h->a*(g[0].par[NGX]-h->ims/2.),
		h->a*(g[0].par[NGY]-h->ims/2.)) ;
        for (i=0;i<im->ncomp;i++)
        {
            x = h->a*(im->ra[i]-h->ims/2.0) ;
            y = h->a*(im->dec[i]-h->ims/2.0) ;
            if (im->magtemp[i]>minmag || im->magtemp[i]<-minmag)
                 printf ("Image %d: %+f %+f , mag %.3g",i,x,y,im->magtemp[i]) ;
            else printf ("Image %d: %+f %+f , mag <%.3g",i,x,y,minmag) ;
            if (im->iscore[i]!=-1) printf (" (C)\n") ; else printf ("\n") ;
            screen (WPLOT) ;
            pg_sci(BLUE) ;
            plotx = h->a*(im->ra[i]-h->ims/2.0) ;
            ploty = h->a*(im->dec[i]-h->ims/2.0) ;
            pg_dpoint (1, &plotx, &ploty, 24) ;
            screen (FULL) ;
        }
        if (!i) printf ("No images within area\n") ;
    }
    else if (!strncmp (command, "magt", 4))
    {
    	printf ("Enter x, y: ") ;
    	scanf ("%lf %lf", &x, &y) ;
    	inva = gcsm (0.5*h->ims+x/h->a, 0.5*h->ims+y/h->a, s[0].par[NSZ]) ;
        detj=inva[0]*inva[3]-inva[1]*inva[2];
        printf ("Magnification tensor: ") ;
        printf ("%f %f %f %f\n",inva[3]/detj,-inva[1]/detj,-inva[2]/detj,inva[0]/detj) ;
        printf ("Magnification: %f\n", 1.0/detj) ;
        printf ("Deflection: %f %f\n", h->xoff, h->yoff) ;
    }
    else if (!strncmp (command, "sim", 3)) gsim() ;
}

void plotthings (char *command)
{
    int ix=0, iy=0, is=1 ;
    double *inva ;

    if (h->nsrc>1 && s[0].par[NSZ] != s[1].par[NSZ])
    {
    	printf ("Which source do you want this projecting onto?\n ") ;
    	scanf ("%d", &is) ; if (is<1||is>h->nsrc) is=1 ;
    }
    for (ix=0; ix<h->ims; ix++)
    {
    	for (iy=0; iy<h->ims; iy++)
    	{
            a[iy*h->ims+ix]=0.0 ;
            if (!strncmp(command,"potn",4) || !strncmp (command, "tdel", 4)) h->uca = 1;
    	    inva = gcsm ((double)ix, (double)iy, s[is-1].par[NSZ]) ;
    	    if (!strncmp(command,"kappa",5))a[iy*h->ims+ix]=plotget(h->kappa) ;
    	    if (!strncmp(command,"magn",4)) a[iy*h->ims+ix]=plotget(h->magn) ;
    	    if (!strncmp(command,"potn",4)) a[iy*h->ims+ix]=plotget(h->pot) ;
    	    if (!strncmp(command,"defl",4)) 
            a[iy*h->ims+ix]=plotget(sqrt(h->xoff*h->xoff+h->yoff*h->yoff)) ;
    	    if (!strncmp(command,"xdefl",5))a[iy*h->ims+ix]=plotget(h->xoff) ;
    	    if (!strncmp(command,"ydefl",5))a[iy*h->ims+ix]=plotget(h->yoff) ;
    	    if (!strncmp(command,"tdel",4)) a[iy*h->ims+ix]=h->tdel ;
    	    if (!strncmp(command,"gamma",5))a[iy*h->ims+ix]=plotget(h->gamma) ;
    	    if (!strncmp(command,"gamm1",5))a[iy*h->ims+ix]=plotget(h->gamma1) ;
    	    if (!strncmp(command,"gamm2",5))a[iy*h->ims+ix]=plotget(h->gamma2) ;
    	}
    }
    gplot (a, s, g, h) ;
    h->uca = 0 ;
}

double plotget (double val)
{
    if (val>VERYBIG || val<-VERYBIG || val==0.0) return 0.0 ;
    /*    if (val<0.0) val *= -1.0 ;*/
    return (val) ;
    /*    return (log10(val)) ;*/
}

int sort_compf (const void *a, const void *b)
{
     if (*((double *)a)==*((double *)b)) return 0 ;
     if (*((double *)a)>*((double *)b)) return 1 ;
     if (*((double *)a)<*((double *)b)) return -1 ;
}
