#include "gdefs.h"
#include "gpgdefs.h"
#include "gsl/gsl_rng.h"

IGDEF

#include "gperm.h"

void gopt ()
{
    static int nos ;
    double x, y ;  float xr, yr ;    char c ; int i;

    if (h->interactive)
    {
        printf (" Select the parameters to vary\n") ;
        for (;;)
        {
            if (nos==MAXOPT)
            {
                printf ("op: Maximum number of parameters exceeded\n") ;
                break ;
            }
            pg_curse (&xr, &yr, &c) ; c= toupper(c) ; x = (double) xr ; y = (double) yr ;
            if (c=='X') break ;
            opt_identify (x, y, c, 0) ;
	}
    }
    printf ("op: Using mode %c\nop: Parameters optimised are\n", h->doopt) ;
    for (i=0;i<h->os.nos;i++)
    {
    	printf ("    %c%d  param=%d ", h->os.sorg[i],h->os.num[i],h->os.ipar[i]) ;
    	if (h->os.otype[i]==PURPLE) printf ("free optimisation\n") ;
    	if (h->os.otype[i]==BLUE) 
            printf ("Gaussian constr %f+/-%f\n", h->os.refval[i],h->os.err[i]) ;
    	if (h->os.otype[i]==BLACK) 
            printf ("brick-wall constr %f+/-%f\n", h->os.refval[i],h->os.err[i]) ;
    }
    if (h->doopt != NOPT)
    {
    	if (h->doopt == WDOPT) optadd (0, 0,'R',0,0.0,0.0) ;
        printf ("op: *** BEST X2: %.2f ***\n", gamoeba ((h->doopt==WDOPT)?gwd:efunk)) ;
        if (h->doopt != WDOPT) optsrc (1) ;
        for (i=1;i<h->aiter;i++)
        printf ("op: *** BEST X2: %.2f ***\n", gamoeba ((h->doopt==WDOPT)?gwd:efunk)) ;
        if (h->doopt != WDOPT) optsrc (0) ;
    	if (h->doopt == WDOPT) optdel (0, 0, 'R') ;
    }
    if (h->doopt == NFOPT || h->doopt == NFIMOPT) 
        printf ("op: *** Fluxes have NOT been used for chi-sq ***\n") ;
}

double var1 ()
{
    double plo, phi, chihi=-VERYBIG, chilo=VERYBIG, chival[MAXITER], par[MAXITER] ;
    int i=0, j=0, pnum ;
    Galaxy gtemp[MAXG] ;
    Source stemp[MAXS] ;
    h->noisy = -1 ;
    h->vos.nos = 1 ;
    varopt (&plo, &phi, &pnum) ;
    memcpy (gtemp, g, MAXG*sizeof (Galaxy)) ;
    memcpy (stemp, s, MAXS*sizeof (Source)) ;

    for (i=0; i<pnum;i++)
    {
        memcpy (g, gtemp, MAXG*sizeof (Galaxy)) ;  /* set up as first */
        memcpy (s, stemp, MAXS*sizeof (Source)) ;
        printf ("op: Value of %f\n", (par[i] = plo + (phi-plo)*(double)i/(double)(pnum-1))) ;
        if (h->vos.sorg[0]=='S')
 	    s[h->vos.num[0]].par[h->vos.ipar[0]] = par[i] ;
        else if (h->vos.sorg[0]=='G')
 	    g[h->vos.num[0]].par[h->vos.ipar[0]] = par[i] ;
 	else if (h->vos.sorg[0]=='R')
 	    h->reg = par[i] ;

        printf ("op: *** BEST CHI-SQ %.2f ***\n",
                    (chival[i] = gamoeba ((h->doopt==WDOPT)?gwd:efunk))) ;
        if (h->doopt != WDOPT) optsrc (1) ;
        for (j=1;j<h->aiter;j++)
	    printf ("op: *** BEST CHI-SQ %.2f ***\n",
                    (chival[i] = gamoeba ((h->doopt==WDOPT)?gwd:efunk))) ;
        if (h->doopt != WDOPT) optsrc (0) ;
        if (chilo>chival[i]) chilo = chival[i] ;
	if (chihi<chival[i]&&chival[i]!=VERYBIG) chihi = chival[i] ;
    }
    pg_end () ;
    if (pg_begin (1, "/cps", 0, 0)!=PG_OK) pg_begin (1, "/null",0,0) ;
    pg_vport (0.2, 0.9, 0.2, 0.9) ;
    pg_window (plo-0.1*(phi-plo), phi+0.1*(phi-plo), chilo-0.1*(chihi-chilo), chihi+0.1*(chihi-chilo)) ;
    pg_box ("BCNST", 0.0, 0, "BCNST", 0.0, 0) ;
    pg_dpoint (i, par, chival, 17) ;
    pg_label (g[h->vos.num[0]].p[h->vos.ipar[0]].de, "Chi-squared", "igloo 6") ;
    pg_end () ;
    if (pg_begin (1, "/xwin", 0, 0)!=PG_OK) pg_begin(1, "/null",0,0) ;
    screen (FULL) ;
    pinit (&s[0], &g[0]) ;
    h->noisy = h->vos.nos = 0 ;
}

double var2 ()
{
    char toplabel[512] ;
    double plo1, phi1, plo2, phi2, chival[MAXITER*MAXITER], par1[MAXITER],
        par2[MAXITER], tr[6], chisort[MAXITER*MAXITER], contour[NUM_CONT] ;
    int i=0, i1=0, i2=0, j=0, pnum1, pnum2, iok ;
    Galaxy gtemp[MAXG] ;
    Source stemp[MAXS] ;

    h->noisy = 0 ;
    h->vos.nos = 1 ;
    varopt (&plo1, &phi1, &pnum1) ;
    h->vos.nos = 2 ;
    varopt (&plo2, &phi2, &pnum2) ;
    memcpy (gtemp, g, MAXG*sizeof (Galaxy)) ;
    memcpy (stemp, s, MAXS*sizeof (Source)) ;

    for (i1=0; i1<pnum1;i1++)
    {
        for (i2=0; i2<pnum2; i2++)
	{
            memcpy (g, gtemp, MAXG*sizeof (Galaxy)) ;  /* set up as first */
            memcpy (s, stemp, MAXS*sizeof (Source)) ;

            printf ("(%f,", (par1[i1] = plo1 + (phi1-plo1)*(double)i1/(double)(pnum1-1))) ;
            if (h->vos.sorg[0]=='S')
                 s[h->vos.num[0]].par[h->vos.ipar[0]] = par1[i1] ;
            else if (h->vos.sorg[0]=='G')
                 g[h->vos.num[0]].par[h->vos.ipar[0]] = par1[i1] ;
            else if (h->vos.sorg[0]=='R')
                 h->reg = par1[i1] ;

            printf ("%f) -> ", (par2[i2] = plo2 + (phi2-plo2)*(double)i2/(double)(pnum2-1))) ;
            if (h->vos.sorg[1]=='S')
 	         s[h->vos.num[1]].par[h->vos.ipar[1]] = par2[i2] ;
            else if (h->vos.sorg[1]=='G')
                 g[h->vos.num[1]].par[h->vos.ipar[1]] = par2[i2] ;
            else if (h->vos.sorg[1]=='R')
                 h->reg = par2[i2] ;

            printf ("op: *** BEST CHI-SQ %.2f ***\n",
                (chival[i2*pnum1+i1] = gamoeba ((h->doopt==WDOPT)?gwd:efunk))) ;
            if (h->doopt != WDOPT) optsrc (1) ;
            for (j=1;j<h->aiter;j++)
	        printf ("op: *** BEST CHI-SQ %.2f ***\n",
                (chival[i2*pnum1+i1] = gamoeba ((h->doopt==WDOPT)?gwd:efunk))) ;
            if (h->doopt != WDOPT) optsrc (0) ;
	}
    }
    pg_end () ;
    if (pg_begin (1, "/cps", 0, 0)!=PG_OK) pg_begin (1,"/null",0,0) ;
    pg_vport (0.2, 0.9, 0.2, 0.9) ;
    pg_window (plo1, phi1, plo2, phi2) ;
    pg_box ("BCNST", 0.0, 0, "BCNST", 0.0, 0) ;

    tr[0] = plo1 ; tr[1] = (phi1-plo1)/(double)pnum1 ; tr[2] = 0.0 ;
    tr[3] = plo2 ; tr[4] = 0.0; tr[5] = (phi2-plo2)/(double)pnum2 ;

    memcpy (chisort, chival, pnum1*pnum2*sizeof(double)) ;
    qsort (chisort, pnum1*pnum2, sizeof (double), sort_compf) ;
    for (iok=0;chisort[iok]<VERYBIG&&iok<pnum1*pnum2;iok++) ;
    sprintf (toplabel, "contours %6g %6g ...%6g", chisort[0],chisort[1],chisort[iok/2]) ;

    for (i=0;i<NUM_CONT;i++) contour[i] = chisort[0]+((double)i/NUM_CONT)*(chisort[iok/2]-chisort[0]) ;
    pg_dcont (chival, pnum1, pnum2, 1, pnum1, 1, pnum2, contour, NUM_CONT, tr);
    pg_label (g[h->vos.num[0]].p[h->vos.ipar[0]].de, g[h->vos.num[1]].p[h->vos.ipar[1]].de, toplabel) ;
    pg_end () ;
    if (pg_begin (1, "/xwin", 0, 0)!=PG_OK) pg_begin (0,"/null",1,1) ;
    screen (FULL) ;
    pinit (&s[0], &g[0]) ;

    h->noisy = h->vos.nos = 0 ;
}

void varopt (double *lo, double *hi, int *step)
{
    char c = 'z' ;
    double x, y ;
    float xr, yr ;
    while (c!='D')
    {
        printf (" Use the MIDDLE button to identify an OPTIMISED parameter\n");
        pg_curse (&xr, &yr, &c) ; c=toupper(c); x = (double) xr ; y = (double) yr ;
        if (c=='D') break ;
    }

    opt_identify (x, y, c, 1) ;
    printf (" Parameter %d of %c%d: enter [lower] [upper] [num-steps]\n",
	    h->vos.ipar[0], h->vos.sorg[0], h->vos.num[0]) ;
    scanf ("%lf %lf %d", lo, hi, step) ;
}

double efunk (double *p)
{
    int i, j, icomp, isxopt, isyopt ;
    double xmean,ymean,xweig,yweig,*inva, mxtot[4]={0.0,0.0,0.0,0.0}, 
        xtot=0.0,ytot=0.0,xtemp,ytemp,mscr1[4],mscr2[4],goodness=0.0 ;
    Obs *impred = NULL ;

    if (loadfromp (p, 0))
        return VERYBIG ;
    if (!h->o.ncomp) 
    {
        printf ("Error: no images\n") ;
        return VERYBIG*NOIMG ;
    }

    /* add in the goodnesses from constrained parameters, which
       have been loaded into the galaxy parameters by loadfromp */

    for (i=0;i<h->os.nos;i++)
    {
    	if (h->os.otype[i]==BLUE&&h->os.sorg[i]=='G')
    	    goodness += (h->os.refval[i]-g[h->os.num[i]].par[h->os.ipar[i]])*
    	                (h->os.refval[i]-g[h->os.num[i]].par[h->os.ipar[i]])
                       /(h->os.err[i]*h->os.err[i]) ;
    	if (h->os.otype[i]==BLACK&&h->os.sorg[i]=='G' &&
            (h->os.refval[i]-g[h->os.num[i]].par[h->os.ipar[i]])*
            (h->os.refval[i]-g[h->os.num[i]].par[h->os.ipar[i]]) >
                 h->os.err[i]*h->os.err[i]) return VERYBIG ;
    }

    for (icomp=0; icomp<h->o.ncomp; icomp++) 
        h->o.xsa[icomp] = h->o.ysa[icomp] = 0.0 ;
    
    for (i=0; i<h->nsrc; i++)
    {
        xmean = ymean = xweig = yweig = 0.0 ;
        xtot = ytot = mxtot[0] = mxtot[1] = mxtot[2] = mxtot[3] = 0.0 ;

        for (icomp=0; icomp<h->o.ncomp; icomp++)
        {
            if (h->o.sno[icomp]-1 == i)
            {
                inva = gcsm (h->o.ra[icomp], h->o.dec[icomp], s[i].par[NSZ]) ;
                h->o.xsa[icomp] = h->o.ra[icomp] - h->xoff ;
                h->o.ysa[icomp] = h->o.dec[icomp] - h->yoff ;
                xmean += h->o.xsa[icomp]/(h->o.errmaj[icomp]*h->o.errmaj[icomp]) ;
                ymean += h->o.ysa[icomp]/(h->o.errmaj[icomp]*h->o.errmaj[icomp]);

                mxmul (inva, inva, mscr1) ;
                cmxmul (1./(h->o.errmaj[icomp]*h->o.errmaj[icomp]), mscr1, mscr2) ;
                mxvec (mscr2, h->o.xsa[icomp], h->o.ysa[icomp], &xtemp, &ytemp) ;
                mxadd (mxtot, mscr2, mxtot) ;
                xtot += xtemp; ytot += ytemp ;

                xweig += 1.0/(h->o.errmaj[icomp]*h->o.errmaj[icomp]) ;
                yweig += 1.0/(h->o.errmaj[icomp]*h->o.errmaj[icomp]);
            }
        }

        mxinv (mxtot, mscr1) ;
        mxvec (mscr1, xtot, ytot, &xtemp, &ytemp) ;
        
        isxopt = isyopt = 0 ;
        for (j=0;j<h->os.nos;j++)
        {
            if (h->os.sorg[j]=='S'&&h->os.num[j]==i&&h->os.ipar[j]==NSX) isxopt=1 ;
            if (h->os.sorg[j]=='S'&&h->os.num[j]==i&&h->os.ipar[j]==NSY) isyopt=1 ;
        }
/*       if (!isxopt) s[i].par[NSX] = xmean / xweig ;
        if (!isyopt) s[i].par[NSY] = ymean / yweig ;*/

        if (!isxopt) s[i].par[NSX] = xtemp ;
        if (!isyopt) s[i].par[NSY] = ytemp ;

        for (icomp=0; icomp<h->o.ncomp; icomp++)
        {
            if (h->o.sno[icomp]-1 == i)
            {
                inva = gcsm (h->o.ra[icomp], h->o.dec[icomp], s[i].par[NSZ]) ;
                h->o.tdpred[icomp] = h->tdel * normfac (0, 0) ;
            }
        }

        if (h->noisy>1) printf ("Source %d: (%+.5f,%+.5f)\n", i,
                h->a*(s[i].par[NSX]-h->ims/2),h->a*(s[i].par[NSY]-h->ims/2)) ;

        if (h->doopt==IMOPT || h->doopt==NFIMOPT)
	{
 	    impred = groot (s[i].par[NSX], s[i].par[NSY]) ;
	    goodness += imageplane (impred, i) ;
	}
	else goodness += sourceplane (i) ;
    } 

    if (h->doh0) goodness += compare_td () ;
    return goodness ;
}

double compare_td ()
{
    int i,j ;
    double goodness_td=0.0, extra=0.0, val, diff ;
    if (h->noisy > 1) printf ("Time delays (H0=%.1f): ",h->h0);
    for (i=0;i<h->o.ncomp;i++)
    {
        if (i==h->o.tdcomp) continue;
        if (h->o.sno[i] == h->o.sno[h->o.tdcomp])
	{
            val = h->o.tdpred[i]-h->o.tdpred[h->o.tdcomp] ;
            diff = h->o.td[i]-val ;
            goodness_td += diff*diff/(h->o.errtd[i]*h->o.errtd[i]) ;
            if (h->noisy>1)
	      printf ("%.1f->%.1f+/-%.1f; ",i,h->o.td[i],val,h->o.errtd[i]) ;
	}
    }
    if (h->noisy>1) printf ("\n") ;
    return goodness_td ;
}

double sourceplane (int ns)
{
    int icomp, inorm=-1 ;
    double vecx, vecy, *inva, detj, goodness=0.0, xpred, ypred, rat1=0.0,
         rat2=0.0, chip, smaj, smin, spa, fgood=0.0 ;
    
    for (icomp=0; icomp<h->o.ncomp; icomp++)
    {
        if(h->o.sno[icomp]-1 == ns)
        {
            vecx = h->o.xsa[icomp] - s[ns].par[NSX] ;
            vecy = h->o.ysa[icomp] - s[ns].par[NSY] ;

            if (h->doopt == SOPT || h->doopt == NFSOPT)
            {
            	get_source_ellip (h->o.ra[icomp], h->o.dec[icomp], h->o.errmaj[icomp],
                                     &smaj, &smin, &spa) ;
            	goodness += errellip (vecx, vecy, smaj, smin, spa) ;
            }
            inva = gcsm (h->o.ra[icomp],h->o.dec[icomp],s[h->o.sno[icomp]-1].par[NSZ]) ;

            detj=inva[0]*inva[3]-inva[1]*inva[2];
            h->o.ivecxtemp[icomp] = (1/detj)*(inva[3]*vecx-inva[1]*vecy);
            h->o.ivecytemp[icomp] = (1/detj)*(-inva[2]*vecx+inva[0]*vecy);
            h->o.magtemp[icomp] = h->magn ;

            if (((h->o.parity[icomp] > 0 && h->magn < 0.0) ||
                 (h->o.parity[icomp] < 0 && h->magn > 0.0)) && h->iter>0)  
	    {
                printf ("Parity check failure, component %d\n",icomp) ;
                goodness += VERYBIG ;
	    }
            rat1 += fabs(h->o.magtemp[icomp])*h->o.flux[icomp]/(h->o.fluxerr[icomp]*h->o.fluxerr[icomp]) ;
            rat2 += h->o.magtemp[icomp]*h->o.magtemp[icomp]/(h->o.fluxerr[icomp]*h->o.fluxerr[icomp]) ;
        }
    }
    
    for (icomp=0; icomp<h->o.ncomp; icomp++)
    {
        if(h->o.sno[icomp]-1 == ns)
        {
            xpred = h->a*(h->o.ra[icomp]-h->o.ivecxtemp[icomp]-h->ims/2.0);
            ypred = h->a*(h->o.dec[icomp]-h->o.ivecytemp[icomp]-h->ims/2.0);

            if (h->o.errmaj[icomp]/h->o.errmin[icomp]<1.01)
                chip =  (h->o.ivecxtemp[icomp]*h->o.ivecxtemp[icomp] + h->o.ivecytemp[icomp]*
                    h->o.ivecytemp[icomp])/(h->o.errmaj[icomp]*h->o.errmaj[icomp]);
            else
                chip = errellip (h->o.ivecxtemp[icomp], h->o.ivecytemp[icomp],
                             h->o.errmaj[icomp], h->o.errmin[icomp], h->o.errpa[icomp]) ;

            if (h->doopt != SOPT && h->doopt != NFSOPT) goodness += chip ;

            h->o.magtemp[icomp]*=rat1/rat2 ;
            if (h->doopt == SOPT || h->doopt == OPT)
            {
                fgood = (h->o.flux[icomp]-fabs(h->o.magtemp[icomp]))*
                    (h->o.flux[icomp]-fabs(h->o.magtemp[icomp]))/
                    (h->o.fluxerr[icomp]*h->o.fluxerr[icomp]) ;
                goodness += fgood ;
            }
            if (h->noisy>1 && h->doopt != SOPT && h->doopt != NFSOPT)
                printf ("(%+.4f,%+.4f) -> (%+.4f,%+.4f)+/-(%g,%g) X2(%.1f,%.1f)\n",
                    h->a*(h->o.ra[icomp]-h->ims/2.0),
                    h->a*(h->o.dec[icomp]-h->ims/2.0), xpred,ypred,
                    h->a*h->o.errmaj[icomp], h->a*h->o.errmin[icomp], 
                    chip, fgood);
            if (!h->interactive)
                printf ("%+.9f %+.9f %+.9f %+.9f %.9f %.9f %.9f #\n",
                    h->a*(h->o.ra[icomp]-h->ims/2.0),
                    h->a*(h->o.dec[icomp]-h->ims/2.0), xpred,ypred,
                    h->o.flux[icomp], fabs(h->o.magtemp[icomp]),chip, 
                    fgood);
        }
    }
    return goodness ;
}

double imageplane (Obs *im, int ns)
{
    Obs om, imtemp ;
    int i, j, k,iminmag,imindist,iparity,oparity,*qx,iqx;
    double goodness=0.0, xdist, ydist, minmag=VERYBIG, mindist=VERYBIG,dist,
      rat1=0.0, rat2=0.0, chip, fgood=0.0, pgood=0.0 ;
    char line[1024];
    FILE *fp, *fopen () ;

    om.ncomp=0 ;
    for (i=0;i<h->o.ncomp;i++)
    	if (h->o.sno[i] == ns+1)
    	    imcopy (&om, om.ncomp++, &h->o, i) ;

    if (om.ncomp != im->ncomp)
    {
    	/* wrong number of images. First, if the number observed is bigger
           than the number predicted, gripe straight away */

    	if (om.ncomp > im->ncomp)
        {
            h->im_expect = om.ncomp ;
            h->im_got = im->ncomp ;
            return VERYBIG_NIM ;
        }

        /* more predicted than observed. This may be because the central 
           images aren't detected -> remove from predicted list the h->ngal 
           with smallest magnification. If discrepancy > h->ngal, gripe */

        if (im->ncomp - om.ncomp > h->ngal)      	
      	    return VERYBIG_NIM ;
      	else
      	{
      	    for (k=0;k<h->ngal;k++)
      	    {
      	        for (j=0;j<im->ncomp-om.ncomp;j++)
      	        {
      	            minmag = VERYBIG ;
      	            for (i=0;i<im->ncomp;i++)
      	            {
      	    	        if (fabs(im->magtemp[i]) < minmag)
      	    	        {
      	    	            minmag = fabs(im->magtemp[i]);
      	    	            iminmag = i ;
      	    	        }
      	            }
      	            for (i=iminmag;i<im->ncomp-1;i++)
      	    	        imcopy (im, i, im, i+1) ;
      	            im->ncomp-- ;
      	            if (im->ncomp == om.ncomp) goto im1 ;
      	        }
      	    }
      	}
    } 

im1: imtemp.ncomp = im->ncomp ;

    switch (im->ncomp) {
    case 1:    qx = (int *)malloc(sizeof(perm_1));
               memcpy (qx, perm_1, sizeof(perm_1));      break;
    case 2:    qx = (int *)malloc(sizeof(perm_2));
               memcpy (qx, perm_2, sizeof(perm_2));      break;
    case 3:    qx = (int *)malloc(sizeof(perm_3));
               memcpy (qx, perm_3, sizeof(perm_3));      break;
    case 4:    qx = (int *)malloc(sizeof(perm_4));
               memcpy (qx, perm_4, sizeof(perm_4));      break;
    case 5:    qx = (int *)malloc(sizeof(perm_5));
               memcpy (qx, perm_5, sizeof(perm_5));      break;
    default:   break;                                          }

    for (i=0,iqx=0;i<ifactorial(im->ncomp);i++,iqx+=im->ncomp)
    {
        dist=0.0;
        for (j=0;j<im->ncomp;j++)
	    dist+=hypot(om.ra[j] -im->ra [qx[iqx+j]],
                        om.dec[j]-im->dec[qx[iqx+j]]);
        if (mindist>dist)
        {
            imindist = iqx ;
	    mindist=dist;
	}
    }
    for (i=0;i<im->ncomp;i++)
	imcopy (&imtemp, i, im, qx[imindist+i]) ;

    for (i=0;i<im->ncomp;i++)
    {
    	imcopy (im, i, &imtemp, i) ;
        rat1 += fabs(im->magtemp[i])*om.flux[i] / (om.fluxerr[i]*om.fluxerr[i]) ;
        rat2 += im->magtemp[i]*im->magtemp[i] / (om.fluxerr[i]*om.fluxerr[i]) ;
    }

    for (i=0;i<im->ncomp;i++)
    {
        xdist = im->ra[i]-om.ra[i] ;
	ydist = im->dec[i]-om.dec[i] ;
	dist = hypot (xdist, ydist) ;
	pgood = (om.errmaj[i]/om.errmin[i]<1.01) ?
	         dist*dist/(om.errmaj[i]*om.errmaj[i]) :
                 errellip(xdist,ydist,om.errmaj[i],om.errmin[i],om.errpa[i]) ;
        goodness += pgood ;
        im->magtemp[i] *= rat1/rat2 ;
        if(h->doopt == IMOPT)
        {
            fgood = pow ((fabs(im->magtemp[i])-om.flux[i])/om.fluxerr[i], 2) ;
            goodness += fgood ;
        }
        if (h->noisy>1)
           printf ("(%+.4f,%+.4f) -> (%+.4f,%+.4f)+/-(%g,%g) X2(%.1f,%.1f) %.1f->%.1f\n",
           h->a*(om.ra[i]-h->ims/2.0),  h->a*(om.dec[i]-h->ims/2.0), 
           h->a*(im->ra[i]-h->ims/2.0),  h->a*(im->dec[i]-h->ims/2.0), 
           h->a*om.errmaj[i], h->a*om.errmin[i], 
	   pgood, fgood,fabs(im->magtemp[i]),om.flux[i]);
    }
    return goodness ;
}

void imcopy (Obs *oout, int nout, Obs *oin, int nin)
{
    oout->iscore[nout] = oin->iscore[nin] ;
    oout->ra[nout] = oin->ra[nin] ;
    oout->dec[nout] = oin->dec[nin] ;
    oout->xsa[nout] = oin->xsa[nin] ;
    oout->ysa[nout] = oin->ysa[nin] ;
    oout->sno[nout] = oin->sno[nin] ;
    oout->parity[nout] = oin->parity[nin] ;
    oout->type[nout] = oin->type[nin] ;
    oout->td[nout] = oin->td[nin] ;
    oout->errtd[nout] = oin->errtd[nin] ;
    oout->tdpred[nout] = oin->tdpred[nin] ;
    oout->mag[nout] = oin->mag[nin] ;
    oout->magtemp[nout] = oin->magtemp[nin] ;
    oout->flux[nout] = oin->flux[nin] ;
    oout->errmaj[nout] = oin->errmaj[nin] ;
    oout->errmin[nout] = oin->errmin[nin] ;
    oout->errpa[nout] = oin->errpa[nin] ;
    oout->fluxerr[nout] = oin->fluxerr[nin] ;
}

int loadfromp (double *p, int doplot) 
{
    int i=0, j=0 ;
    double xcoord, ycoord ;

    if (p)
    {
        for (i=0;i<h->os.nos;i++)
        {
            switch(h->os.sorg[i])
            {
            case'S':
                s[h->os.num[i]].par[h->os.ipar[i]] = p[i] ;
                if (h->interactive && doplot)
                   pfill (&s[h->os.num[i]].p[h->os.ipar[i]],p[i],
                           s[h->os.num[i]].p[h->os.ipar[i]].status) ;
                if (p[i]>s[h->os.num[i]].ulim[h->os.ipar[i]] ||
                    p[i]<s[h->os.num[i]].llim[h->os.ipar[i]])
		{
  		    printf("Lim error, S[%d], %f, %f, %f\n",
			   h->os.num[i],s[h->os.num[i]].llim[h->os.ipar[i]],
		      p[i],s[h->os.num[i]].ulim[h->os.ipar[i]]) ;
                    return 1 ;
	        }
                break ;
            case'G':
                g[h->os.num[i]].par[h->os.ipar[i]] = p[i] ;
                if (h->interactive && doplot)
                    pfill (&g[h->os.num[i]].p[h->os.ipar[i]],p[i],
                            g[h->os.num[i]].p[h->os.ipar[i]].status) ;
                if (p[i]>g[h->os.num[i]].ulim[h->os.ipar[i]] ||
                    p[i]<g[h->os.num[i]].llim[h->os.ipar[i]])
 		{
  		    printf("Lim error, G[%d].par[%d], %f, %f, %f\n",
		    h->os.num[i],h->os.ipar[i],g[h->os.num[i]].llim[h->os.ipar[i]],
		      p[i],g[h->os.num[i]].ulim[h->os.ipar[i]]);
                    return 1 ;
	        }
                break ;
            case'R':
                h->reg = p[i] ;
                if (h->interactive && doplot)
                    pfill (&h->preg, h->reg, BROWN) ;
                break ;
            default: 
                break ;
            }
        }
    }

    if (h->interactive && doplot)
    {
	for (i=0;i<h->nsrc;i++)
        {
	    pfill (&s[i].p[NSX],s[i].par[NSX],s[i].p[NSX].status) ;
	    pfill (&s[i].p[NSY],s[i].par[NSY],s[i].p[NSY].status) ;
	}

        g2image () ;
        gplot () ;

	screen (WPLOT) ;
	for (j=0; j<h->o.ncomp; j++)
	{
	    xcoord = h->o.ra[j] - h->o.ivecx[j] ;
	    ycoord = h->o.dec[j] - h->o.ivecy[j] ;
	    pg_sci (PURPLE) ;
	    pg_dpoint (1, &xcoord, &ycoord, 14) ;
	    pg_move (xcoord, ycoord) ;
	    pg_draw (h->o.ra[j], h->o.dec[j]) ;
	    pg_updt () ;
	}
	screen (FULL) ;
    }
    return 0 ;
}

void loadtop ()
{
    int j ;
    double gstep[10] = {1.0,1.0,1.0,4.0,0.04,1.0,0.3,0.1,0.1,0.0} ;
    double sstep[7] = {1.0,1.0,0.1,0.1,4.0,0.1,0.1} ;
    for (j=0; j<h->os.nos; j++)
    {
    	switch (h->os.sorg[j])
    	{
    	    case 'S':
    	        h->prm[0][j] = s[h->os.num[j]].par[h->os.ipar[j]] ;
    	        h->prm[1][j] = sstep[h->os.ipar[j]] ;
    	        break ;
    	    case 'G':
    	        h->prm[0][j] = g[h->os.num[j]].par[h->os.ipar[j]] ;
    	        h->prm[1][j] = gstep[h->os.ipar[j]] ;
    	        break ;
    	    case 'R':
    	        h->prm[0][j] = h->reg ;
    	        h->prm[1][j] = h->step*h->prm[0][j] ;
    	        break ;
    	    default: break ;
    	}
    }
}

int optcheck (Opt *os, int iz, int ipar, char sorg, double *err)
{
    int i ;

    *err = 0.0 ;
    for (i=0;i<os->nos;i++)
    {
        if (sorg==os->sorg[i] && sorg=='R') return 1 ;
        if (sorg==os->sorg[i] && iz==os->num[i] && ipar==os->ipar[i])
        {
            if (os->otype[i] == PURPLE) return 1 ;
	    if (os->otype[i] == BLUE) { *err = os->err[i] ; return 2 ; }
	    if (os->otype[i] == BLACK) { *err = os->err[i] ; return 3 ; }
	    if (os->otype[i] == RED) printf ("Eurgh\n") ;
	}
    }
    return 0 ;
}

void optsrc (int code)
{
    int i ;
    for (i=0;i<h->nsrc;i++)
    {
    	optdel (i, NSX, 'S') ;
    	optdel (i, NSY, 'S') ;
    	if (code) optadd (i, NSX, 'S', PURPLE, 0.0, 0.0) ;
    	if (code) optadd (i, NSY, 'S', PURPLE, 0.0, 0.0) ;
    }
}

void optadd (int iz, int ipar, char sorg, int otype, double refval, double err)
{
    double junk ;
    
    if (optcheck (&h->os, iz, ipar, sorg, &junk)) return ;
    h->os.sorg[h->os.nos] = sorg ;
    h->os.num[h->os.nos] = iz ;
    h->os.ipar[h->os.nos]= ipar ;
    h->os.otype[h->os.nos] = otype ;
    h->os.refval[h->os.nos] = refval ;
    h->os.err[h->os.nos] = err ;
    h->os.nos++ ;
    if (sorg=='S')
    {
    	s[iz].p[ipar].status = otype ;
    	if (h->interactive) pfill (&s[iz].p[ipar], s[iz].par[ipar], otype) ;
    }
    else if (sorg=='G')
    {
    	g[iz].p[ipar].status = otype ;
    	if (h->interactive) pfill (&g[iz].p[ipar], g[iz].par[ipar], otype) ;
    }
}

void optdel (int iz, int ipar, char sorg)
{
    int i,j ;

    for (i=0;i<h->os.nos;i++)
    {
        if (sorg==h->os.sorg[i] && iz==h->os.num[i] && ipar==h->os.ipar[i])
        {
            if (sorg=='S')
            {
         	s[iz].p[ipar].status = RED ;
    	        if (h->interactive) pfill (&s[iz].p[ipar], s[iz].par[ipar], RED) ;
            }
            else if (sorg=='G')
            {
    	        g[iz].p[ipar].status = RED ;
         	if (h->interactive) pfill (&g[iz].p[ipar], g[iz].par[ipar], RED) ;
            }

            for(j=i;j<h->os.nos-1;j++)
            {
                h->os.sorg[j]=h->os.sorg[j+1] ;
                h->os.num[j]=h->os.num[j+1] ;
                h->os.ipar[j]=h->os.ipar[j+1] ;
                h->os.otype[j]=h->os.otype[j+1] ;
                h->os.refval[j]=h->os.refval[j+1] ;
                h->os.err[j]=h->os.err[j+1] ;
            }
            h->os.nos-- ;
            break ;
        }
    }
}

void opt_identify (double x, double y, char c, int loadvos)
{
    int iz, ipar, otype=RED ;
    double err=0.0, refval=0.0 ;
    char sorg ;

    if (c=='B'||c=='G')
    {
        printf ("op: enter the reference value ---> ") ;
        scanf ("%lf", &refval) ;
        printf ("op: enter the error ---> ") ;
        scanf ("%lf", &err) ;
        if (c=='G') otype = BLUE ; else otype = BLACK ;
    }
    if (c=='A') otype = PURPLE ;
    if (c=='D') otype = RED ;
    
    switch (c)
    {
    case 'X': 
        break ;
    case 'A':
    case 'D':
    case 'B':
    case 'G':
        if (XSTA<x && x<XSTA+NSPARM*BS && YSTA-h->nsrc*BS<y && y<YSTA)
        {
            iz = (int) ((YSTA-y)/BS) ;
            ipar = (int) ((x-XSTA)/BS) ;
            sorg = 'S' ;
            if (c!='D')  optadd (iz, ipar, 'S', otype, refval, err)  ;
                  else optdel (iz, ipar, 'S') ;
        }
        if (XGSTA<x && x<XGSTA+NGPARM*BS && YGSTA-h->ngal*BS<y && y<YGSTA)
        {
            iz = (int) ((YGSTA-y)/BS) ;
            ipar = (int) ((x-XGSTA)/BS) ;
            sorg = 'G' ;
            if (c!='D') optadd (iz, ipar, 'G', otype, refval, err) ;
                  else optdel (iz, ipar, 'G') ;
        }
        break ;
    }

    if (h->vos.nos && loadvos)
    {
    	h->vos.sorg[h->vos.nos-1] = sorg ;
    	h->vos.num[h->vos.nos-1] = iz ;
    	h->vos.ipar[h->vos.nos-1] = ipar ;
    }
}


double errellip (double x, double y, double emaj, double emin, double epa)
{
    double sinth = sin(epa*PI/180.0), costh = cos(epa*PI/180.0), ex, ey,
     r[4] = { -sinth, costh, -costh, -sinth }, rt[4] = { -sinth, -costh, costh, -sinth },
     sig[4] = { emaj*emaj, 0.0, 0.0, emin*emin }, scr1[4], scr2[4] ;

    mxmul (sig, r, scr1) ;
    mxmul (rt, scr1, scr2) ;
    mxinv (scr2, scr1) ;
    mxvec (scr1, x, y, &ex, &ey) ;
    return (x*ex + y*ey) ;
}


double normfac (int ng, int ns)
{
    double val = (8395.2/C) * (1.0+g[ng].par[NGZ]) * h->a * h->a
           * ddist (0.,s[ns].par[NSZ]) * ddist (0.,g[ng].par[NGZ])
           / ddist (g[ng].par[NGZ],s[ns].par[NSZ]) ;

    return (val) ;
}

void get_source_ellip (double xi, double yi, double ei, double *smaj, double *smin, double *spa)
{
    double ang, csrc, cenx, ceny, scenx, sceny ;
    *smaj = -VERYBIG; *smin = VERYBIG ;

    gcsm (xi, yi, s[0].par[NSZ]) ;
    scenx = xi - h->xoff ; sceny = yi - h->yoff ;
    
    for (ang=0.0; ang<=180.0; ang+=10.0)
    {
    	gcsm (xi+ei*cos(ang*PI/180.), yi+ei*sin(ang*PI/180.), s[0].par[NSZ]) ;
    	cenx = xi - h->xoff; ceny = yi - h->yoff ;
    	csrc = hypot(cenx-scenx, ceny-sceny) ;
    	if (*smin>csrc)   *smin = csrc ;
    	if (*smaj<csrc) { *smaj = csrc ; *spa = ang ; }
    }
    *spa += 90 ; /* convert to standard PA system */
}

int ifactorial(int n)
{
  return (n == 1 || n == 0) ? 1 : ifactorial(n - 1) * n;
}
