#include "gdefs.h"
#include "gpgdefs.h"

static void SigHandler () ;
static jmp_buf env ;

Source s[MAXS] ;
Galaxy g[MAXG] ;
Handle allh, *h = &allh ;
double *a ;

main(int argc, char *argv[])
{
    int i, val ;
    char command[512] ;
    signal (SIGINT, SigHandler) ;

    h->o.ncomp = h->uca = h->os.nos = h->usep = h->usedim =
           h->docore = h->neval = h->zoom = h->vos.nos = h->debug = 0 ;
    h->svdwiggle = h->doupdate = h->aiter = 1 ;
    h->plcut = 0.0 ;
    h->pucut = 1.0 ;
    h->ims = IMS ;
    a = (double *) malloc (h->ims*h->ims*sizeof(double));
    h->zcx = h->zcy = 0.0 ;
    h->h0 = 70.0 ;
    h->omega = 0.30 ;
    h->lambda = 0.70 ;
    h->step = 0.001 ;
    h->divnum = 99 ;

    h->rng = gsl_rng_alloc (gsl_rng_mt19937) ;
    gsl_rng_set (h->rng, -time(NULL)) ;
    printf ("   ******************************************************************\n") ;
    printf ("   ***                     welcome to IGLOO                       ***\n") ;
    printf ("   ***               For help type ? in any button                ***\n") ;
    printf ("   ***         For a list of commands type @ in the plot          ***\n") ;    
    printf ("   ***         For information on credits type + in plot          ***\n") ;
    printf ("   ******************************************************************\n") ;
    printf ("   This is a stubbed version without cusps - gfortran problems\n");
    printf ("   Note that the format of the data file has changed recently. See the\n");
    printf ("   help on RMOD for more.\n\n\n") ;
    h->isbigend = getendian () ;
    for (i=0; i<MAXS; i++) sinit (&s[i], i) ;
    for (i=0; i<MAXG; i++) ginit (&g[i], i) ;

    strcpy (command, "cp /home/njj/root_overflow/igloo/ghelp.c .") ;
    system (command) ;    

    if (argc > 1)   /* use input file if there is one argument */
    {
	h->interactive = 0;
        if (argc > 2) sscanf (argv[2], "%c", &h->doopt) ;
        if (argc > 3) sscanf (argv[3], "%d", &h->aiter) ;
        if (argc > 5) sscanf (argv[5], "%d", &h->docore) ;
        pg_begin (1, "/null", 0, 0) ;
        pinit (&s[0],&g[0]) ;
	ginput (argv[1]);
        if (argc > 4) sscanf (argv[4], "%lf", &h->divnum) ;

        if (efunk(NULL)==VERYBIG_NIM)
	{
	    printf ("op: *** BEST CHI-SQ: 1350000000\n") ;
  	    exit(0);
	}

/* always optimize source position if non-interactive, unless doopt is 'N'*/

	if (h->doopt != 'N')
	{
	   optadd (0, NSX, 'S', PURPLE, 0.0, 0.0) ;
	   optadd (0, NSY, 'S', PURPLE, 0.0, 0.0) ;
	   gopt () ;
	}
	gtype ("findimz\0") ;
    }
    else
    {
	h->interactive = 1;
	if (pg_begin (1, "/xwin ", 0, 0)!=PG_OK) pg_begin (1,"/null",0,0);
        screen (FULL) ;
        pinit (&s[0],&g[0]) ;
        h->pxl = h->pyl = -h->a*(float)h->ims/2.0 ;
        h->pxu = h->pyu =  h->a*(float)h->ims/2.0 ;
	
        for (;;)
	{
	    setjmp (env) ;
            signal (SIGINT, SigHandler) ;
            val = pcurs() ;
	    if (!val) break ;
	    switch (val)
	    {
	      case TYPE:    gtype ("\0") ; break ;
	      case EVAL:    g2image () ; gplot () ; break ;
	      case OPT:     gopt () ;  break ;
	      case PLOT:    gplot () ; break ;
	      case CAUSTIC: gcrit () ;   break  ;
	      case VAR1:    var1 () ;  break ;
	      case VAR2:    var2 () ;  break ;
              case SVD:     gsvd () ;  break ;
	      default:                        break ;
	    }
	}
    pg_end () ;
    gsl_rng_free (h->rng) ;
    }
}

static void SigHandler (int signo)
{
    if (signo==SIGINT) longjmp (env, signo) ;
}

