#include "gdefs.h"
#include "gpgdefs.h"

IGDEF

char gpar[NGPARM][4] = { "xle","yle","cri","the","ell","rad","a1","a2","zle","typ","she","ang" } ;
int gnum[NGPARM] = { NGX, NGY, NGB, NGTH, NGE, NGS, NGA1, NGA2, NGZ, NGMT, SM, SA } ;


void ginput (char *filename)
{
    FILE *fp ;
    char line[132] ;
    int ipar, iepar, isopt=0, i=0, otype=RED ;
    double bigdist=0.0, ctot=0.0, prmt[9], dfl[2], mgnf[5],refval, err ;
    Tok *t ;
        
    if (!(fp = fopen (filename, "r")))
    {
        printf ("in: File %s not found\n", filename) ;
        return ;
    }

    h->ngal = h->o.ncomp = 0 ;
    h->a = 0.0 ;

    /* Empty the optimisation structure */

    h->os.nos = 0 ;
    mkrect (0.0, XGSTA+BS*NGPARM, 0.0, YGSTA-BS, 1, GREEN) ;

    while((t = gettok (fp)))
    {
        
        if (!strncmp (t->ct[0], "new", 3)) { h->ngal++ ; continue ; }
        if (t->n > 1 && t->n < 5)
	{
	    if (!strncmp (t->ct[0], "zs", 2)) 
                sscanf (t->ct[1], "%lf", &s[0].par[NSZ]) ;
            else if (!strncmp (t->ct[0], "opt", 3)) 
                sscanf (t->ct[1], "%c", &h->doopt) ;
            else if (!strncmp (t->ct[0], "spe", 3)) 
            {
                sscanf (t->ct[1],"%lf",&h->speed);
                pfill (&h->pspeed, h->speed, BROWN) ;
	    }
            else if (!strncmp (t->ct[0], "ite", 3)) 
            {
                sscanf (t->ct[1],"%d",&h->iter);
                pfill (&h->piter, h->iter, BROWN) ;
	    }
            else if (!strncmp (t->ct[0], "ait", 3)) 
            {
                sscanf (t->ct[1],"%d",&h->aiter);
                pfill (&h->paiter, h->aiter, BROWN) ;
	    }
            else if (!strncmp (t->ct[0], "ims", 3)) 
            {
                sscanf (t->ct[1],"%d",&h->ims);
                pfill (&h->pims, h->ims, BROWN) ;
                a = (double *)realloc(a,h->ims*h->ims*sizeof(double));
	    }
	    else if (!strncmp (t->ct[0], "sca", 3))
	    {
                sscanf (t->ct[1], "%lf", &h->a) ;
                pfill (&h->papix, 1000.*h->a, BROWN) ;
            }
            else
            {
                isopt = 0 ; ipar = -1 ; otype = RED; err=0.0 ;

                for (i=0;i<NGPARM;i++)
                {
                    if (!strncmp (t->ct[0], gpar[i], 2))
                    {
                    	ipar=gnum[i] ;
                    	break ;
                    }
                }
                if (ipar==-1) { printf ("in: ignored token %s\n", t->ct[0]) ; continue ; }
                
                sscanf (t->ct[1], "%lf", &g[h->ngal].par[ipar]) ;
                sscanf (t->ct[2], "%d", &isopt) ;
                if (t->n>3) sscanf (t->ct[3], "%lf", &err) ;

                if (isopt)
                {
                    if (isopt==1) otype = PURPLE ;
                    else if (isopt==2) otype = BLUE ;
                    else if (isopt==3) otype = BLACK ;
                    optadd (h->ngal, ipar, 'G', otype, g[h->ngal].par[ipar], err) ;
		}

		/* for the benefit of SVD, if the parameter is NGX, NGY, SM or SA
		   we additionally need to copy the error to NGXERR etc */

		if (ipar==NGX) g[h->ngal].par[NGXERR] = err ;
		if (ipar==NGY) g[h->ngal].par[NGYERR] = err ;
		if (ipar==SM) g[h->ngal].par[SMERR] = err ;
		if (ipar==SA) g[h->ngal].par[SAERR] = err ;
	    }
	}
        if (t->n>=8)
	{
            sscanf (t->ct[0], "%d", &h->o.sno[h->o.ncomp]) ;
            sscanf (t->ct[1], "%lf", &h->o.ra[h->o.ncomp]) ;
            sscanf (t->ct[2], "%lf", &h->o.errmaj[h->o.ncomp]) ;
            sscanf (t->ct[3], "%lf", &h->o.dec[h->o.ncomp]) ;
            sscanf (t->ct[4], "%lf", &h->o.errmin[h->o.ncomp]) ;
            sscanf (t->ct[5], "%lf", &h->o.flux[h->o.ncomp]) ;
            sscanf (t->ct[6], "%lf", &h->o.fluxerr[h->o.ncomp]) ;
            sscanf (t->ct[7], "%d", &h->o.parity[h->o.ncomp]) ;
            if (t->n>8) sscanf (t->ct[8], "%lf", &h->o.errpa[h->o.ncomp]) ;
               else h->o.errpa[h->o.ncomp] = 0.0 ;
            if (t->n>10)
            {
            	sscanf (t->ct[9], "%lf", &h->o.td[h->o.ncomp]) ;
            	sscanf (t->ct[10], "%lf", &h->o.errtd[h->o.ncomp]) ;
                if (h->o.td[h->o.ncomp] == 0.0)
		{
		    h->o.tdcomp = h->o.ncomp ;
		    printf ("Time delays ref cpt: %d\n",h->o.tdcomp) ;
		}
            }
            else h->o.td[h->o.ncomp] = h->o.errtd[h->o.ncomp] = -1.0 ;
            if (h->o.sno[h->o.ncomp] > h->nsrc) h->nsrc=h->o.sno[h->o.ncomp] ;
	    if (bigdist<fabs(h->o.ra[h->o.ncomp])) bigdist = fabs(h->o.ra[h->o.ncomp]) ;
	    if (bigdist<fabs(h->o.dec[h->o.ncomp])) bigdist = fabs(h->o.dec[h->o.ncomp]) ;
            h->o.ncomp++ ;   
	}
    }
    h->ngal++ ;
    if (bigdist > 1.0/VERYBIG && h->a<1.0/VERYBIG && h->a>-1.0/VERYBIG)
    {
        printf ("in: largest image separation %f -> pixscale %f\n", bigdist, (h->a = bigdist*3.0/h->ims)) ;
        pfill (&h->papix, h->a*1000.0, BROWN) ;
    }
    h->pxu = h->pyu =  h->a*(float)h->ims/2.0 ;
    h->pxl = h->pyl = -h->a*(float)h->ims/2.0 ;

    arc2pix (1) ;
    for (i=0;i<h->nsrc;i++) s[i].par[NSZ] = s[0].par[NSZ] ;
    efunk (NULL) ;
    for (i=0;i<h->nsrc;i++) sfill (&s[i]) ;
    for (i=0;i<h->ngal;i++) gfill (&g[i]) ;
}

Tok *gettok (FILE *fp)
{
    static Tok t ;
    char line[1024] ;
    int i=0,j=0 ;
    if (!(fgets (line, sizeof (line), fp))) return NULL ;
    for (i=0;i<strlen(line);i++) if (line[i]=='=') line[i]=' ';
    for (i=0;i<MAXTOK;i++) for (j=0;j<MAXLEN;j++) t.ct[i][j]='\0'; i=j=0 ;
    t.n = 1 ;
    while (line[i]==' ') i++ ;

    for(;;)
    {
        if (line[i]==' ')
	{
   	    t.n++ ; j=0 ; while (line[i]==' ')i++ ;
	}
        else if (line[i]=='\n'||line[i]=='#') 
        {
            if (!i||line[i-1]==' ')t.n-- ; break ;
	}
        else t.ct[t.n-1][j++] = line[i++] ;
    }
    return (&t) ;
}

void goutput (char *filename)
{
    FILE *fp, *fopen () ;
    int i, j, otype, otype_write=0 ;
    double err=0.0 ;

    if (!(fp=fopen (filename, "w")))
    {
        printf ("in: Could not open file %s for writing\n", filename) ;
        return ;
    }
    arc2pix (-1) ;
    fprintf (fp, "# Output file written by goutput\n#### Image parameters ####\n") ;
    fprintf (fp, "#  RA  errMaj DEC   errMin Flux  Flerr  parity  (errPA)\n%d\n",h->o.ncomp);
    for (i=0;i<h->o.ncomp;i++)
    {
        fprintf (fp, "%d %+.4f %.4f %+.4f %.4f %.2f %.2f %+d ",
	      h->o.sno[i], h->o.ra[i], h->o.errmaj[i], h->o.dec[i],
	      h->o.errmin[i], h->o.flux[i], h->o.fluxerr[i], h->o.parity[i]) ;
        if (h->o.errmaj[i]/h->o.errmin[i]<1.01) fprintf (fp, "%f", h->o.errpa[i]) ;
        fprintf (fp, "\n") ;
    }

    if (!h->o.ncomp)
    {
fprintf(fp,"1 +0.7222 0.0001 -0.2962 0.0001 11.2119852 0.90 -1 0.000000\n");
fprintf(fp,"1 +0.7322 0.0001 -0.2962 0.0001 11.2119852 0.90 -1 0.000000\n");
fprintf(fp,"1 -0.0327 0.0001 -0.8062 0.0001 2.66136648 0.50 +1 0.000000\n");
fprintf(fp,"1 -0.3898 0.0001 +0.3238 0.0001 0.6806776 0.10 -1 0.000000\n");
    }


    fprintf (fp, "#\n### Galaxy parameters ###\n#\n%d\n", h->ngal) ;
    fprintf (fp, "sca = %f\n",h->a) ;
    for (i=0;i<h->ngal;i++)
    {
    	if (i) fprintf (fp, "#\nnew\n#\n") ;

        for (j=0;j<NGPARM;j++)
        {
             err = 0.0 ;
             otype_write = optcheck(&h->os, i, gnum[j], 'G', &err) ;
             fprintf (fp, "%s = %f %d ", gpar[j], g[i].par[j], otype_write) ;
             if (otype_write) fprintf (fp, "%f\n", err) ; else fprintf (fp, "\n") ;
        }
    }
    fprintf (fp, "#\n### Redshift of Source \nzs = %f\n", s[0].par[NSZ]) ;
    fclose (fp) ;
    arc2pix (1) ;
}

void goutput_lm (char *filename)
{
    FILE *fp, *fopen () ;
    int i, ncomp_thissrc, j ;
    char mtype[32] ;
    double junk ;

    if (!(fp=fopen (filename, "w")))
    {
        printf ("in: Could not open file %s for writing\n", filename) ;
        return ;
    }
    arc2pix (-1) ;

    fprintf (fp, "%d\n", h->ngal) ;

    for (i=0;i<h->ngal;i++)
    {
    	if (g[i].par[NGXERR]>1.0E-6)
    	     fprintf (fp, "%f %f %f # gal pos\n", g[i].par[NGX], g[i].par[NGY], g[i].par[NGXERR]) ;
    	else fprintf (fp, "%f %f 1000 # gal pos\n", g[i].par[NGX], g[i].par[NGY]) ;
    	fprintf (fp, "%f 1000 #eff radius\n", g[i].par[NGB]) ; /* convert !*/
    	fprintf (fp, "%f 1000  #gal PA\n", g[i].par[NGTH]) ;
    	fprintf (fp, "%f 1000 #ellip\n", g[i].par[NGE]) ;
    }
    
    fprintf (fp, "%d\n", h->nsrc) ;
    for (i=0;i<h->nsrc;i++)
    {
    	ncomp_thissrc = 0 ;
    	for (j=0;j<h->o.ncomp;j++) if (h->o.sno[j]==i+1) ncomp_thissrc++ ;
    	
    	fprintf (fp, "%d\n", ncomp_thissrc+1) ;

    	for (j=0;j<h->o.ncomp;j++)
            if (h->o.sno[j]==i+1)
            	fprintf (fp, "%f %f %f %f %f 0.0 0.0\n",
            	    h->o.ra[j], h->o.dec[j], h->o.flux[j]*(float)h->o.parity[j],
                    h->o.errmaj[j],h->o.fluxerr[j]) ;

        fprintf (fp, "%f %f 1.0E-6 1000.0 1000.0 0.0 0.0\n", g[0].par[NGX], g[0].par[NGY]) ;
    }
    
    fclose (fp) ;

    /* Change this to do non-alpha models! */
    
    fp = fopen ("output.start", "w") ;
    {
    	fprintf (fp, "%d 1\n",h->ngal) ;
    	for (i=0;i<h->ngal;i++)
    	{
    	    switch ((int)(g[i].par[NGMT]+0.00001))
    	    {
    	    	 case 0: strcpy (mtype, "ptmass\0") ;
    	    	 case 1: strcpy (mtype, "alpha\0") ;
    	    	 case 2: strcpy (mtype, "alphapot\0") ;
    	    	 case 3: strcpy (mtype, "cusp\0") ;
    	    	 default: strcpy (mtype, "alpha\0") ;
    	    }
    	    fprintf (fp, "%s %f %f %f %f %f %f %f 0.0 0.0 1.0\n",
    	            mtype,
    	            g[i].par[NGB]/(sqrt( (1.+(1.-g[i].par[NGE])*(1.-g[i].par[NGE]))
                           / (2.*(1.-g[i].par[NGE]))  )),
    	            g[i].par[NGX], g[i].par[NGY], g[i].par[NGE], g[i].par[NGTH],
    	            g[i].par[SM], g[i].par[SA]) ;
    	}
    	for (i=0;i<h->ngal;i++)
    	    fprintf (fp, "%d %d %d %d %d %d %d 0 0 0\n",
    	            optcheck (&h->os, i, NGB, 'G', &junk),
    	            optcheck (&h->os, i, NGX, 'G', &junk),
    	            optcheck (&h->os, i, NGY, 'G', &junk),
    	            optcheck (&h->os, i, NGE, 'G', &junk),
    	            optcheck (&h->os, i, NGTH, 'G', &junk),
    	            optcheck (&h->os, i, SM, 'G', &junk),
    	            optcheck (&h->os, i, SA, 'G', &junk)) ;
    }
    fclose (fp) ;
    arc2pix (1) ;
}


void arc2pix (int whichway)
{
    int i ;
    
    if (whichway>0)   /* arcsec -> pix */
    {
        for(i=0;i<h->o.ncomp;i++)
        {
	    h->o.ra[i] = h->o.ra[i]/h->a+h->ims/2 ;
	    h->o.dec[i] = h->o.dec[i]/h->a+h->ims/2 ;
	    h->o.xsa[i] = h->o.xsa[i]/h->a+h->ims/2 ;
	    h->o.ysa[i] = h->o.ysa[i]/h->a+h->ims/2 ;
            h->o.errmaj[i] /= h->a ;
            h->o.errmin[i] /= h->a ;
        }
        for(i=0;i<h->ngal;i++)
        {
            g[i].par[NGX] = g[i].par[NGX]/h->a + h->ims/2 ;
            g[i].par[NGY] = g[i].par[NGY]/h->a + h->ims/2 ;
            g[i].par[NGXERR] /= h->a ;
            g[i].par[NGYERR] /= h->a ;
            g[i].par[NGB] /= h->a;
            g[i].llim[NGX] = g[i].par[NGX] - h->ims ;
            g[i].llim[NGY] = g[i].par[NGY] - h->ims ;
            g[i].ulim[NGX] = g[i].par[NGX] + h->ims ;
            g[i].ulim[NGY] = g[i].par[NGY] + h->ims ;
            g[i].ulim[NGB] = VERYBIG ;
        }
        for (i=0;i<h->os.nos;i++)
        {
            if (h->os.sorg[i]=='G'&&h->os.otype[i]!=RED)
            {
                if (h->os.ipar[i]==NGX||h->os.ipar[i]==NGY)
                {
                    h->os.refval[i] = h->os.refval[i]/h->a + h->ims/2 ;
                    h->os.err[i] /= h->a ;
                }
                if (h->os.ipar[i]==NGB)
                {
                    h->os.refval[i] /= h->a ;
                    h->os.err[i] /= h->a ;
                }
            }
        }
    }
    else            /* pix -> arcsec */
    {
        for(i=0;i<h->o.ncomp;i++)
        {
            h->o.ra[i] = h->a*(h->o.ra[i]-h->ims/2.0) ;
            h->o.dec[i] = h->a*(h->o.dec[i]-h->ims/2.0) ;
            h->o.xsa[i] = h->a*(h->o.xsa[i]-h->ims/2.0) ;
            h->o.ysa[i] = h->a*(h->o.ysa[i]-h->ims/2.0) ;
            h->o.errmaj[i] *= h->a ;
            h->o.errmin[i] *= h->a ;
        }

        for(i=0;i<h->ngal;i++)
        {
            g[i].par[NGX] = h->a*(g[i].par[NGX]-h->ims/2.0) ;
            g[i].par[NGY] = h->a*(g[i].par[NGY]-h->ims/2.0) ;
            g[i].par[NGXERR] *= h->a ;
            g[i].par[NGYERR] *= h->a ;
            g[i].par[NGB] *= h->a;
	    /*            g[i].llim[NGX] = g[i].llim[NGY] = -h->a*h->ims/2 ;
			  g[i].ulim[NGX] = g[i].ulim[NGY] = h->a*h->ims/2 ;*/
            g[i].ulim[NGB] = VERYBIG ;
        }
        for (i=0;i<h->os.nos;i++)
        {
            if (h->os.sorg[i]=='G'&&h->os.otype[i]!=RED)
            {
                if (h->os.ipar[i]==NGX||h->os.ipar[i]==NGY)
                {
                    h->os.refval[i] = h->a*(h->os.refval[i]-h->ims/2.0) ;
                    h->os.err[i] *= h->a ;
                }
                if (h->os.ipar[i]==NGB)
                {
                    h->os.refval[i] *= h->a ;
                    h->os.err[i] *= h->a ;
                }
            }
        }
    }
}

