#include "gdefs.h"
#include "gpgdefs.h"

IGDEF

void ghelp (int code, int coord)
{
    int i = code*100+coord, doprint=0, mark ;
    FILE *fp, *fopen () ;
    char c ;

    if (!(fp = fopen ("ghelp.c", "r")))
       printf ("Cannot find help file\n") ;
    
    while ((c=getc(fp))!=EOF)
    {
    	if (doprint) putchar (c) ;
        if (c=='#')
        {
            if (doprint) doprint=0 ;
            else
            {
                fscanf (fp, "%d", &mark) ;
                if (mark==i) doprint=1 ;
            }
        }
    }
}

/*

#-2

Credits and algorithms
----------------------

This software needs to be linked with three packages provided by others:

1. Graphics are handled by calls to PGPLOT routines. PGPLOT is copyrighted by the
   California Institute of Technology and no source code is distributed with the
   IGLOO application. For further details and to obtain the PGPLOT libraries needed
   to compile IGLOO consult http://www.astro.caltech.edu/~tjp/pgplot.

2. Cusp models are implemented by calls to the fast algorithm described by Chae
   (2002, MNRAS 346, 746) to which reference should be made on use. The FORTRAN
   code required can be obtained in the files spleFS.f and cuspFS.f from
   www.jb.man.ac.uk/~chae.

3. Numerical computations are done using the Gnu Software Library (GSL).
   To obtain a copy go to www.gnu.org/software/gsl/ .

It also uses algorithms and software provided by others - please reference these
sources on use of the appropriate parts of IGLOO:
   
4. The image-finding algorithm is based on the description published by Keeton
   (2001, astro-ph/0102342). The SIE is based on the description of Kormann et
   al. (A&A 284, 285).

5. gsvd.c is based on the algorithm of Evans & Witt 2003, MNRAS 345, 1351
   to whom reference should be made on use.
   
6. gwd.c is based on the algorithm of Warren & Dye 2003, ApJ 590, 673
   and Dye & Warren 2005, ApJ 623, 31, to whom reference should be made on use.

7. gcrit.c and parts of gopt.c were written by Martin Norbury.
   
8. The pgplot wrapper routines were written by Simon Garrington, University of
   Manchester, Jodrell Bank Observatory.

Neal Jackson, 28/04/2006.

#-1

List of commands - for more detail type ? in the button
-------------------------------------------------------

  addG     add a new galaxy
  addS     add a new source
  crit     plot the critical curve, cut and caustic for current model
  eval     plot image plane from the current model
  funk     evaluate current model against current observation set
  opt      optimise the current model
  plot     plot various parameters across the image plane
  prec     not used at present
  prin     prints current image plane to a postscript file
  rmod     read a new observation set and model from igloo file
  svd      Evans & Witt (2003) angular decomposition
  tdel     plot time delay contours
  var1     plot chi-squared as a function of a parameter
  var2     plot chi-squared as a function of two parameters
  wd       Warren & Dye (2003) semi-linear inversion
  writ     writes current observation set and model to igloo file

List of control variables - for more detail type ? in the button
----------------------------------------------------------------

  aite     controls the number of restarts in an optimisation
  apix     scale used for image plane
  core     logical variable controlling search for core images
  div      division of plane into tiles - too small and it can miss images!
  doh0     logical variable controlling whether chi2 includes delays
  doop     controls the type of chi-squared calculated in optimisation
  dtem     not used at present
  ims      adjust the number of pixels in the image plane grid
  iter     controls number of simplex iterations in each optimisation
  look     lookup table type for grey-scale plots
  maga     magnification level for pixel splitting in WD inversion
  reg      regularisation parameter for WD inversion
  spee     speedup factor for potential calculation of cusp models
  spix     number of source plane pixels for Warren & Dye deconvolution
  ssca     size of pixels used in Warren & Dye deconvolution
  svs      controls singularity level in decompositions for svd/wd

List of source and galaxy parameters
------------------------------------

  X        x-coordinate in pixels of source or galaxy
  Y        y-coordinate in pixels of source or galaxy
  maj      major axis of source, in pixels
  min      minor axis of source, in pixels
  th       position axis of source ellipse
  F        flux of source
  z        redshift of source or galaxy
  b        mass parameter of galaxy, in pixels
  th       position angle of galaxy, E of N
  ell      ellipticity of galaxy
  S        break radius, in arcseconds, used in cusp models
  a1       inner power-law slope in cusp models
  a2       outer power-law slope in cusp models
  MT       model type (0=point, 1=SIE, 2=ellip.pot, 3=cusp)
  SM       external shear dimensionless magnitude
  SA       external shear position angle

To increase a value, left-click in the box.
To increase by a larger increment, middle-click in the box.
To increase by a smaller increment, hit 'S' in the box.
To reverse the sense of the above buttons, right-click in the box.

#0

Plot window
===========


  The plot window is divided by default into a 128x128 grid. It
  contains a green dot at the position of each galaxy and a red
  dot for each source.

  The left-hand mouse button moves the nearest source to the mouse
  position and the middle button moves the nearest galaxy to the
  mouse position. The right hand button cycles the zoom at the
  current mouse position by factors of 5, 25 and back to the whole
  screen. 


  Notes:
  1. The new zoom is implemented on the next call to EVAL.  
  2. The zoom factor is set by the ZFAC parameter in gdefs.h
     (default 5). The grid size is set by IMS in gdefs.h
     (default 128.


#100

ADDG

  Adds a galaxy to the current model, initialised with default
  parameters. The maximum number of galaxies may not be exceeded
  and will generate an error message.

  Notes:
    The maximum number of galaxies is set by MAXG in gdefs.h. It
    is not currently possible to delete galaxies; set b=0 to
    effectively remove them.

#101

ADDS

  Adds a source to the current model, initialised with default
  parameters. The maximum number of sources may not be exceeded
  and will generate an error message.

  Notes:
    The maximum number of sources is set by MAXS in gdefs.h. It
    is not currently possible to remove sources.


#102

EXIT

  Closes the PGPLOT window and exits the program, losing the
  current model in the process.

#110

TYPE

  This button escapes to the text window and provides commands
  which do not have their own button. Currently these are

      findsrc: Prompts for a position (in arcseconds) in the
               image plane and outputs its projection in the
               source plane.
      findimX: If X=g, prompts for a position (in arcseconds)
               in the source, plane, and outputs the corres-
               ponding images. If X!=g, uses the position of
               the first source.
      magt:    Prompts for a position in the image plane, and
               calculates and prints the magnification tensor.
      sim:     Simulates the image plane with the current
               parameters and a point-spread function FITS file
               which is prompted for. Writes out a FITS file
               with the resulting image.

  Notes:
  1.  For finding images from sources, it is important to set
      core to 1 if core images are to be found properly.
  2.  For finding images, the image grid is divided into
      triangles (see Keeton 2001) which are further subdivided
      in regions of high magnifications. This is controlled by
      the div parameter; if images are missing, 
      then this may need increasing.

#111

EVAL

  Takes the current sources and plots the resulting image grid
  for the current lens model.

  Notes:
    The size of source is important for this process. Each image
    pixel is projected back to the source grid and given a value
    according to an Fexp(-r^2/r_0^2) function, where r_0 is the
    distance between its projected position and a source, and F
    is the source flux.

#112

OPT

Starts off an optimization using the current value of doop. This
may be any of the following:

 N changes the parameters to be optimized without optimizing
 F a pseudo-image plane optimization with positions and fluxes
 P a PIP optimization with positions only
 I an image-plane optimization with positions and fluxes,
   using the core parameter to decide whether to locate core
   images accurately
 H does an IP optimization with positions only
 W does an optimization of the Warren & Dye model to force the
   best agreement of the calculated image plane with an image and
   psf supplied by the user. See the remarks on the wd button.
 S source-plane optimization with positions and fluxes
 R source-plane optimization with positions only

See help on doopt for more details.

  The user is invited to set parameters to be optimized using the
  left-hand (A) mouse button to select a parameter, middle button
  (D) to deselect and right-hand button (X) to begin the optimiz-
  ation.

  There are two alternative forms of optimization you can use, apart
  from the free-optimization selected by A. These are an optimisation
  constrained by a Gaussian penalty (selected by the G key on the
  parameter) and a brick-wall penalty function (selected by the B
  key). This is very useful for cases in which, for example, the
  radio-to-optical astrometric registration is not known precisely.
  In this case the X and Y position of the galaxy can be optimised
  with a Gaussian penalty, and the image positions will be allowed
  to change with respect to the galaxy position, but the image
  positions relative to each other will be constrained to a different,
  generally much higher, accuracy. B will turn the button black and
  G turns it blue.

  ** NOTE THAT IN ORDER TO CHANGE THE FORM OF OPTIMIZATION OF A
     PARAMETER, YOU NEED TO FIRST DESELECT IT WITH 'D' AND THEN
     CHANGE IT TO WHAT YOU WANT - THIS IS A "FEATURE"!!           **

Notes:

1.By default the source position is NOT optimized unless
  explicitly requested; otherwise the program takes the weighted
  average of the back-projected source positions. The weighting
  is either done by the inverse square of the data errors or
  using the magnification matrix; changing the mode requires a
  change in the gopt.c code.

2.The optimization will be restarted from the best-fit a
  total of aiter times. Each optimization stops if the simplex
  is smaller than FTOL in gdefs.h, or if the total number of
  iterations exceeds iter which is settable by the user.

3.Plotting of the magnification is useful before
  beginning optimisation, because the critical curve
  should enclose negative-parity images (coloured in
  brown). See the help on the plot button.

4.By default, if aiter is greater than 1, the first iteration is
  run without optimization of source positions unless this has
  already been selected by the user; subsequent iterations
  are done with optimization.


#120

RMOD

  Reads a model from a model file. The format of the model file
  is as follows:

  (i) Lines describing each observed image of the observation
      set. These lines contain the following columns:

      1. Source number producing image (starting with 1)
      2. x-coordinate of image in arcseconds (increasing to right)
      3. Error in x-coordinate in arcseconds
      4. y-coordinate of image in arcseconds (increasing to top)
      5. Error in y-coordinate in arcseconds
      6. Flux of this image in arbitrary units
      7. Error in flux in the same units
      8. Image parity (either +1 or -1)

      The remaining columns are optional, but if provided for
      one image must be provided for all
      
      9. Position angle of major axis of position error
      10. Time delay in days: must be >=0.0, -1 means none measured
      11. Error in time delay

  (ii) Lines describing parameters of the model galaxy. In all the following,
      d is the optimization type required (0=no optimization, 1=free
      optimization, 2=Gaussian constraints, 3=brick-wall constraints) -
      see the help on OPT for further discussion of this point. The last
      argument (err) is optional except for d>1, when it represents the
      allowed error for calculating penalties. For use of the Evans & Witt
      method, errors on galaxy position, shear magnitude and angle are
      required.

      type n  [n=integer, 0=point, 1=SIE, 2=ellip.pot, 3=cusp]
      xlens x d err [x=x position of galaxy in arcsec from centre]
      ylens y d err [y=y position of galaxy in arcsec from centre]
      crit b d err [b=critical radius in arcsec]
      ellip e d err [e=ellipticity, d as above]
      theta t d err [t=position angle of major axis E of N, d as above]
      shear s d err [s=shear magnitude, d as above]
      angle a d err [a=shear angle, d as above]
      zl l [l=redshift of lens]
      zs s [s=redshift of source]
      iter i [i=number of iterations in optimization; negative means
                use abs(iter) but turn off parity checking]

      The command "next" on a line on its own will add a new
      galaxy. Subsequent parameters are applied to this new
      galaxy.

      

  Notes:
      1. If you want Gaussian or brick-wall constraints for
         parameter optimization
      2. Equal signs may be inserted but are ignored.
      3. Lines beginning with hash are treated as comments.
      4. Lines with an unrecognised number of columns are ignored.
      5. Galaxy parameters are updated on the screen as they
           are read.
      6. The image scale is set automatically on reading the
          observation set in order to fit on the plot.
      


#121

PLOT

  Plots grey-scale pictures of various useful parameters across
  the image plane. Which parameter is plotted depends on the
  key pressed to select the plot button:

    m  magnification
    1  shear component 1
    2  shear component 2
    g  total shear
    k  total convergence
    d  deflection angle
    x  x-component of deflection
    y  y-component of deflection
    p  potential

Notes:

  1. Time delay has its own button.
  2. Either upper or lower case letters may be used.
  3. The lookup table for the plot may be changed using
       the "look" button.
  4. Plotting of the magnification is useful before
       beginning optimisation, because the critical curve
       should enclose negative-parity images (coloured in
       brown).

#122

WD

  Performs semi-linear inversion according to the prescription
  of Warren & Dye (2003) and Dye & Warren (2005).

  The program prompts for an image FITS file, a FITS file of
  the PSF and a model file (for format see the help on RMOD). The
  outputs are a plot of the input image and reconstructed image
  at the bottom, and the source plane at the top. The matrix
  inverted is plotted at the bottom left.

  Notes:

    1. The weighting is currently just the square root of the
       data. This is almost certainly not what you want, and
       requires a change in the gwd.c code at the point commented
       "set weighting".
    2. The procedure requires a matrix inversion which may produce
       singular values. The logarithm of the SVS parameter sets
       the fraction of the maximum eigenvalue for an eigenvalue
       which is regarded as singular. -6 to -9 often works well.
    3. The source plane pixel scale is set using SPIX. The compu-
       tation speed goes approximately as SPIX^6, so there is a
       large penalty for a large source grid.
    4. The SSCA parameter sets the scale to be used for the source
       plane pixel scale.
    5. The program has the option from Dye & Warren 2005 of an
       adaptive grid in regions of high magnification. The MAGA
       parameter sets the minimum magnification for splitting to
       be carried out.
    6. Especially without an adaptive grid, the inversion needs
       regularising. This is done using a constant regularisation
       controlled by the logarithm of the REG parameter. Over-
       regularisation leads to an unacceptably smooth solution with
       no source; under-regularisation gives a noisy mess in the
       source plane.

  The algorithm for this is taken directly from the papers of

    Warren & Dye 2003, ApJ 590, 673
    Dye & Warren 2005, ApJ 623, 31   

  and does *not* contain many subtleties described therein.

#130

FUNK

  Evaluates the current model and compares it to the current
  observation set which has been read in using RMOD. Prints
  the observed and predicted positions of all images, the
  observed and predicted fluxes, and the predicted time delays
  (in days, with an arbitrary offset).

  Notes:
     1. A chi-squared of 1.0E+9 usually indicates a parity
        error or a mismatch in the number of observed and
        predicted images. Check by plotting the magnification
        (see PLOT) that the parities are correct.
     2. If the core images are given in the observation set,
        then DOCORE should be set to 1.

#131

CAUS

  Plots the cut, caustic and critical curve for the current
  model. This is done by an iterative method; the cut is searched
  for by searching for points where the magnification is a local
  minimum, the critical curve by searching for points where the
  magnification reverses sign, and the caustics are the projections
  of the critical curve in the source plane.

  Notes
  1. This can be very slow for complicated models, especially
     cusps. It can be speeded up by changing the value of the
     INCREMENT parameter in gdefs.h and recompiling.
  
#132

TDEL

  Plots contours of time delay for the current model.

#140

WRIT

  Writes the current observation set and model to a file which
  can later be read using RMOD. The file is left on disk with
  the name "output.txt". Note that any old file with this name
  will be overwritten.

  Notes
  1. Using the "l" key in this window writes a data file output.lm
     and a startup file output.start in the format of the Lensmodel
     code of C. Keeton.

#141

PREC

  Not used at present.

#142

PRIN

  Plots the current model and observation set to the postscript
  file pgplot.ps. A grey-scale of the image plane is plotted
  together with time-delay surfaces, cut and caustic, and a
  snapshot of the buttons with source and galaxy parameters.

  Notes
  1. Because the routine uses an iterative algorithm to calculate
     the cut and caustic, it can be slow.

#150

VAR1

  Varies a specified optimized parameter between specified limits,
  and optimizes all other optimized parameters at each iteration
  using the currently specified optimization method. Produces an
  output file pgplot.ps of the resulting chi^2 as a function of
  the varied parameter.

  Notes
  1. You will be prompted to specify one of the optimized parameters
     and give a starting and ending value and a step value between
     these. For each of these values, an optimization over all the
     other optimizable parameters is done.
  2. See the help on opt and doop for information about details of
     optimization methods.


#151

VAR2

  Varies 2 specified optimized parameters between specified limits,
  and optimizes all other optimized parameters at each iteration
  using the currently specified optimization method. Produces an
  output file pgplot.ps of the resulting chi^2 as a function of
  the varied parameters.

  Notes
  1. You will be prompted to specify both the optimized parameters
     and give a starting and ending value and a step value between
     these. For each of these values, an optimization over all the
     other optimizable parameters is done.
  2. See the help on opt and doop for information about details of
     optimization methods.


#152

SVD

  Performs a linear inversion to find the galaxy which will exactly
  fit the data, using the method described by Evans & Witt (2003).
  The model should have been optimized to fit the observation set
  reasonably well before using this method, otherwise the galaxy
  may have a highly non-physical shape. The fit may be optimized to
  give the smoothest possible galaxy by allowing the image positions
  and fluxes to vary within the observational errors.

  Notes
  1. The SVS parameter is used to determine which eigenvalues are
     singular if they are less than a fraction log(SVS) of the
     largest eigenvalue. -3 to -6 often works well.
  2. Use of the left-hand mouse button on SVD requires an exact fit
     to the data. The middle and right buttons will force an
     optimization to get the smoothest possible galaxy, by allowing
     the image positions and fluxes to vary within 3 sigma of the
     central value.
  3. The initial step-sizes for optimization are set as 30% of the
     1-sigma errors in position and flux.

  Reference: Evans N. & Witt H., 2003, MNRAS 345, 1351

#200

SPIX

  Controls the size of source plane pixel to be used in the semi-
  linear reconstruction of Warren & Dye 2003 (WD).

  See WD for discussion of this parameter.
  
#201

DOCORE

  In many applications, IGLOO searches for images in the image
  plane which result from a source in the source plane. This is
  normally done by a root-finder algorithm which finds the zeroes
  in the deflection angle (first derivative of potential) resulting
  from local Fermat minima in the Fermat potential of the lens.

  Core images are hard to find this way as the Fermat surface
  contains a very small sharp maximum. For DOCORE=0 the program
  does not bother to localise the core image, but simply reports its
  presence. This mode is fast, but both the position and flux of
  the core image will be wrong.

  For DOCORE=1 the program will divide the area around each galaxy
  into chunks with successively smaller pixels and look for the
  core image. It will stop either when it finds the core image
  significantly (i.e. several divided pixels) away from the galaxy,
  or when the limit on the magnification of the core image is less
  than MINCOREMAG in gdefs.h (currently 1.0E-6).

#202

IMS

  Adjusts the number of pixels in the image plane grid. 128 is the
  current maximum (set by MAXIMS in gdefs.h). This is automatically
  adjusted by WD because it re-grids the image plane to be consistent
  with the data read in for modelling.

#203

SVS

  In cases where linear equations are solved using singular
  value decomposition, singular values are identified using the
  SVS parameter. A value is regarded as singular if it is less
  than log(SVS) times the largest value.

  Notes
  1. This parameter is used both for Warren & Dye (2003) inversion
     and for Evans & Witt (2003) inversion (WD and SVD).

#204

SPEE

  Controls the speed of the calculation of potential when considering
  cusp models. The calculation speed is increased by the square of
  SPEE at the cost of accuracy.

  Notes
  1. See the help on MT for further details of cusps.
  2. The cusp model deflections and magnifications are calculated
     using the algorithm of Chae (2003). However, the potential is
     calculated by a crude method involving the calculation of
     deflection angle over a grid and then doing a point-by-point
     integratino to get the potential. SPEE controls the size of
     this grid.
  3. In many applications involving cusp calculation the potential
     is not needed; the only cases where it is needed is if the
     user specifically requests a plot of potential or time delay.

  Reference: Chae 2003, MNRAS 346, 746.

#205

DIV

  Controls the division of the plane into tiles which is used to find
  images for a given source. Important for doopt=H or I. If this is
  too small, the algorithm will fail to find images which are close
  together - particularly important for merging images and for images
  close to the core. Use this as high as your machine can stand.
  
#210

SSCA

  Controls the pixel scale of the source plane in the semi-linear
  inversion method of Warren & Dye (2003). See this paper for
  further discussion. Too small will give a large computation
  time; too large will not work well in regions of high magnification.

  Notes
  1. Units of this parameter are milliarcseconds.

#211

AITE

  Controls the number of times that the optimization is
  restarted on finding the best fit. This can sometimes
  help to drive towards the lowest chi2.

  By default, if aiter is greater than 1, the first
  iteration is run without optimization of source positions
  unless this has been selected by the user; subsequent
  iterations are done with source position optimization.

#212

DTEM

  Not used at present.

#213

MAGA

  In the Warren & Dye semi-linear inversion, the source
  pixel grid may be subdivided in regions of high mag-
  nification, to avoid the need for regularisation. This
  is done if the magnification at a point is greater than
  MAGA.

  Notes
  1. See Dye & Warren 2005 for discussion of this parameter.
  2. The pixel is subdivided into 4 if the magnification is
     greater than MAGA, and into 16 if it is greater than
     MAGA*MAGA.
  3. Dye & Warren perform an extra loop to account for the
     variation between sources landing on centres and edges
     of pixels. This program does not do this.

#214

REG

  Applies regularisation to inversion problems to prevent
  them degenerating into a noisy solution which fits the
  inversion properly. Used for the WD (Warren & Dye 2003)
  algorithm; the regularisation applied is log(REG). In
  practice experimentation is needed to avoid too little
  regularisation (noisy source plane reconstruction) or
  too much (removal of genuine sources).

  Notes
  1. See Warren & Dye 2003 for discussion of this parameter.

#220

APIX

  Controls the pixel scale of the image plane.

  Notes
  1. Units are milliarcseconds.
  2. This parameter is set automatically by RMOD to get the
     whole observation set onto the image grid with space at
     the edges.
  3. Initial default is 25mas; this is hard-wired into the
     code.

#221

DOOP

  Controls how the goodness of fit of the current model to the
  observation set is determined. There are three methods
  available:

  Source-plane optimization. Each image is projected back to
  the source plane, and an error-circle in the image plane is
  projected back to an error-ellipse in the source plane. The
  goodness is determined by the distance of each source from
  the current source position. This option is selected by typing
  R in the DOOP button for the use of positions only, or S for
  positions and fluxes. See e.g. Kochanek 2004 for why this is
  in general not a good idea.

  Pseudo-image-plane optimization. Each image is projected
  back to the source plane, these source positions are averaged,
  a vector from the average source position to each individual
  source position is determined, these vectors are then projected
  back to the image plane and the size of these image plane vectors
  gives the goodness of fit. This option is selected using P for
  positions only, or F for positions and fluxes.

  Image-plane optimization. The image plane is searched for all
  images corresponding to the current source position using the
  algorithms described in Keeton (2001). The goodness of fit is
  assessed by comparing these positions with the positions in the
  observing set. Since this involves a root-finding step it is the
  slowest of the three, but it is the most accurate and reliable.
  The option is selected using H for positions only (the default)
  and I for positions and fluxes.

  Notes:
  1. To include core images in the optimization if they are present
     in the observing set, you must set DOCORE to 1.
  2. Images may occasionally be missed if they are very close to
     each other, because the first stage is a search of the image
     plane. If this happens, increase divnum.

  Reference: Keeton, C., astro-ph/0102340

#222

ITER

  Controls the number of iterations to be performed in optimisations
  using simplexes. Several thousand may be necessary if the simplex
  is to converge in complex regions or long "valleys" in chi-squared
  space.

  Notes:
  1. The parameter may be reset by the user on the buttons, or it may
     be set by RMOD when a new model is read in.

  2. If ITER<0, abs(iter) is used, and parity checking is turned off.
     Use with caution and check the results.

#223

DOH0

  This parameter controls whether goodnesses of fit between the current
  model and observation set calculated using FUNK or optimized using OPT
  include the comparison of observed and predicted time delays. It should
  only be used if the current observation set read in by RMOD contains time
  delays.

  Notes:
  1. By default, IGLOO assumes a (70, 0.3, 0.7) cosmology. Changing
     this requires a change to glens.c and recompilation.
  2. See the help on RMOD for details of how to include time delay
     information.
  3. All possible combinations of time delays are used; e.g. if time
     delays A-B and A-C have been measured, the comparison will be done
     between three pairs A-B, A-C and B-C.
  4. If optimising using cusp models (MT=3) it is STRONGLY recommended
     to have dOh0 set to zero. Calculating time delays requires the
     calculation of the potential, which is very slow for this mode.

#224

LOOK

  Tweaks the lookup table for grey-scale plots. Left-hand, middle and
  right-hand mouse buttons correspond to values of 0, 1 and 2 in the
  PGPLOT routine pg_sitf.

#300

SOURCE - X

  Controls the source X position in PIXELS. The number of milliarcseconds
  per pixel is given by APIX.

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.

#301

SOURCE - Y

  Controls the source X position in PIXELS. The number of milliarcseconds
  per pixel is given by APIX.

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.

#302

SOURCE - MAJ

  Controls the source major axis in PIXELS. The number of milliarcseconds
  per pixel is given by APIX. Default is 3.

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.

#303

SOURCE - MIN

  Controls the source minor axis in PIXELS. The number of milliarcseconds
  per pixel is given by APIX. Default is 3.

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.

#304

SOURCE - TH

  Controls the source position angle in degrees for extended sources.

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.

#305

SOURCE - F

  Controls the source flux in arbitrary units.

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.
#306

SOURCE - Z

  Controls the source redshift. This can also be changed by reading in
  a file for the observation set: see RMOD for further information.

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.
#400

GALAXY - X

  Controls the galaxy X position in PIXELS. The number of milliarcseconds
  per pixel is given by APIX. The position can also be changed by reading
  in an observation set from a file: see RMOD for more details.

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.

#401

GALAXY - Y

  Controls the galaxy Y position in PIXELS. The number of milliarcseconds
  per pixel is given by APIX. The position can also be changed by reading
  in an observation set from a file: see RMOD for more details.

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.

#402

GALAXY - B

  Controls the galaxy mass parameter in PIXELS. The number of milliarcsec
  per pixel is given by APIX. The position can also be changed by reading
  in an observation set from a file: see RMOD for more details.

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.

  Notes:
  1. There are two conventions for mass parameter in use. IGLOO uses
     the convention of Kormann et al. (1994) A&A 284, 285. Most other
     programs (e.g. lensmodel and the cusp algorithm of Chae 2003) use
     a parameter B which is related to IGLOO's b as:

     B = sqrt ( (1+(1-e)^2)/(2(1-e) )

#403

GALAXY - TH

  Controls the position angle of the galaxy in degrees (East of North).

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.
#404

GALAXY - ELL

  Controls the ellipticity of the galaxy mass distribution.

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.
  
  Notes:
  1. For the elliptical potential model, the ellipticity of the potential
     is related to the mass ellipticity, e, by

       epot = (1-E^2)/(1+E^2) where E=acos(1-e)/acosh(1/(1-e))

#405

GALAXY - S

  Controls a break radius in the galaxy mass distribution, in ARCSECONDS.
  This is used in particular in cusp models (see MT for details).

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.

#406

GALAXY - A1

  Controls an inner power-law slope in the model of the galaxy mass.
  This is used in particular in cusp models (see MT for details). A
  slope of 2 corresponds to isothermal.

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.

#407

GALAXY - A2

  Controls an outer power-law slope in the model of the galaxy mass.
  This is used in particular in cusp models (see MT for details). A
  slope of 2 corresponds to isothermal.

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.

#408

GALAXY - Z

  Controls the galaxy redshift. This can also be changed by reading in
  a file for the observation set: see RMOD for further information.

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.

#409

GALAXY - MT

  Controls the model type of the galaxy. This can be one of three types:

  0 - point source
  1 - singular isothermal model
  2 - elliptical potential
  3 - cusp

  The point source model has zero convergence, a total shear proportional
  to R^-4, a magnification of 1/(1-R^-4), and a potential of b^2 log R.

  The isothermal model parameters can be found in Kormann et al. (1994,
  A&A 284, 285).

  The elliptical potential is described by Blandford & Kochanek 1987. In
  general it gives similar results to the SIE, and is simpler to compute,
  but gives unphysical potential shapes at high ellipticity.

  The cusp routines use the fast cusp calculation code of Chae (2003);
  refer to this paper for full details. The 3D mass density profile is

  rho(r) = rho_o r^{-n} (1+r^2)^{-(m-n)/2}, r^2=(x/a)^2+(y/b)^2+(z/c)^2

  which is a broken power law with inner slope -n, an outer slope -m and
  a break radius a, b, c along each axis.

#410

GALAXY - SM

  Controls the external shear magnitude. This can also be changed by reading
  in a file for the observation set: see RMOD for further information.

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.

#411

GALAXY - SA

  Controls the external shear position angle, in DEGREES. This can also
  be changed by reading in a file for the observation set: see RMOD for
  further information.

  To increase the parameter by a small, medium and large increment, use
  the 'S' key, the left-hand mouse button and the middle mouse button
  respectively. Clicking the right-hand button changes the direction
  from an increase to a decrease applied by future clicks.
*/
