#include "gdefs.h"
#include "gpgdefs.h"

IGDEF

void getu (double x, double y, double zs, int ix, double *u, double *alpha)
{
    double xs, ys, xp, yp, b=g[ix].par[NGB], e=g[ix].par[NGE], mag, rs2,r2,
      a1=g[ix].par[NGA1], ss=g[ix].par[NGS], theta=g[ix].par[NGTH]*R2D, 
      shearmag=g[ix].par[SM], r=hypot(x,y), shearang=g[ix].par[SA]*R2D, 
      epot, phi, b0phi, b0phi3, phis, phixx, phiyy, phixy, axrat, axprime, 
      sqaxrat, d0, d1, d0p, d1p, qqr, qqa, sphis, cphis, fasin, fasinh,fratio,
      newprmt[5]={b,g[0].par[NGA1],g[0].par[NGA2], ss, e }, dfl[2]={0.0,0.0}, 
      mgnf[5], prmt[9] = {
            (double)g[0].par[NGB]*h->a/(2.0*PI*(double)g[0].par[NGS]),
            (double)g[0].par[NGA1],(double)g[0].par[NGA2],
            (double)g[0].par[NGS],(double)g[0].par[NGE],0.0,0.0,0.0,0.001},
	ample_psi[4],bpow ;
    static double oldprmt[5], oldspeed, phis0, r0 ;
    FILE *fdebug ;
    int i, cmax=0 ;

    if (e<0.0)    /* deal with neg ellipticities gracefully */
    {
        e*=-1.0 ;
        theta += 3.141592654/2.0 ;
    }

/* fdebug = fopen ("debug", "a") ;*/

    h->kappa=h->gamma=h->gamma1=h->gamma2=0 ;
    
    switch ((int)g[ix].par[NGMT])
    {
        case 0:              /* POINT SOURCE */
            phixx = b*b*(y*y-x*x)/(r*r*r*r) ;
            phiyy = -phixx ;
            phixy = -2.*b*b*x*y/(r*r*r*r) ;
            h->kappa = 0.0 ;
            h->gamma1 = 0.5*(phixx-phiyy) ;
            h->gamma2 = -phixy ;
            h->gamma = hypot (h->gamma1, h->gamma2) ;
            if (x!=0.0||y!=0.0) h->pot += b*b*log (r) ;

            xs = x * (1.0 - b*b/(r*r)) ;
            ys = y * (1.0 - b*b/(r*r)) ;
        break ;
        case 1:             /* ELLIPTICAL MASS DISTRIBUTION */
  	    rotate (&xp, &yp, x, y, -theta) ;
            phis = gatan (yp,xp) ;
            sphis = sin(phis) ;
            cphis = cos(phis) ;
            axrat = 1.-e ;
            sqaxrat = sqrt (axrat) ;
            axprime = sqrt (1.0-axrat*axrat) ;
            if (fabs(a1-2.0) < 0.01)
                h->kappa = 0.5*b*sqaxrat / hypot (xp, axrat*yp) ;
            else
   	        h->kappa = 0.5*pow(b,3.0-a1)*sqaxrat / 
		    pow((pow(xp,2.0)+pow(axrat*yp,2.0)),3.0-a1) ;
            h->gamma1 = h->kappa*(2.0*sphis*sphis-1.0) ;
            h->gamma2 = - h->kappa*2.0*sphis*cphis ;
            h->gamma = hypot (h->gamma1, h->gamma2) ;
            if (e < VERYSMALL)
            {
                if (fabs(a1-2.0) < 0.01)
		{
                    h->pot += r*b*sqaxrat*(sphis*sphis+cphis*cphis/axrat);
                    xs = xp - b*cphis ;
            	    ys = yp - b*sphis ;
		}
                else
		{
		    h->pot += pow(b,3-a1)*pow(r,a1-1)*sqaxrat*
                                          (sphis*sphis+cphis*cphis/axrat);
                    bpow = pow(b,3-a1)*pow(r,a1-2)/(a1-1) ;
                    xs = xp - bpow*cphis ;
            	    ys = yp - bpow*sphis ;
		}
            }
            else
            {
            	fasin = asin (axprime*sphis) ;
            	fasinh = asinh (axprime*cphis/axrat) ;
                fratio = sqaxrat/axprime ;
                if (fabs(a1-2.0) < 0.01)
		{
                    h->pot += r*b*fratio*(sphis*fasin + cphis*fasinh) ;
                    xs = xp - b*fratio*fasinh ;
                    ys = yp - b*fratio*fasin ;
		}
                else
		{
  	            h->pot += pow(r,a1-1)*pow(b,3-a1)*fratio*
                              (sphis*fasin + cphis*fasinh) ;
                    bpow = pow(b,3-a1)*pow(r,a1-2)/(a1-1) ;
                    xs = xp - bpow*fratio*fasinh ;
                    ys = yp - bpow*fratio*fasin ;
		}
            }
            rotate (&xp, &yp, xs, ys, theta) ;
            xs = xp; ys = yp ;
	    
        break ;

    case 2:            /* ELLIPTICAL POTENTIAL */

            rotate (&xp, &yp, x, y, -theta) ;
            phis = gatan (yp,xp) ;
            epot = acos(1.0-e)/acosh(1.0/(1.0-e)) ;
            epot = (1-epot*epot)/(1+epot*epot) ;
            phi = sqrt(ss*ss + ((1.-epot)*yp*yp) + ((1.+epot)*xp*xp)) ;
            b0phi = b/phi ;  b0phi3 = b0phi * b0phi * b0phi ;
            ys = yp * (1.0 - b0phi*(1-epot)) ;
            xs = xp * (1.0 - b0phi*(1+epot)) ;
            mag = 1.0/((1.0 - b0phi + b0phi3 * (epot*((xp*xp-yp*yp)/(b*b)+
                 epot*(xp*xp+yp*yp)/(b*b))-ss*ss*(1.0-b0phi*(1-epot*epot))))) ;
            h->gamma = h->kappa = 0.5*(1.0-1.0/mag) ;
            h->gamma2 = (xp*yp/(b*b)) * (1-epot*epot) * b0phi3 ;
            h->gamma1 = sqrt (h->gamma*h->gamma - h->gamma2*h->gamma2) ;
            h->pot += b*phi ;
            rotate (&xp, &yp, xs, ys, theta) ;
            xs = xp; ys = yp ;
	    break ;
    case 3:            /* CUSP */
            if (h->uca)
            {
                for (i=0;i<5;i++)
                    if (oldprmt[i]!=newprmt[i]||oldspeed!=h->speed)
                         {ucusp();break;}
                for (i=0;i<5;i++) oldprmt[i] = newprmt[i] ;
                oldspeed = h->speed ;

                rotate (&xp, &yp, x, y, -theta) ;
                phis = gatan (yp,xp) ;

                qqr = r*NCUSP/(h->ims*h->speed) ;
                qqa = phis / (R2D*h->speed) ;
                while (qqa>=360/h->speed) qqa-=360/h->speed ;
                while (qqa<0) qqa+= 360/h->speed ;

                if (qqr>=0 && qqr<NCUSP/h->speed)
                {
                    h->pot += linterp (h->pcusp, qqr, qqa, MAXNCUSP, MAXACUSP)/
            	                  (h->a*h->a) ;
                    d0 = linterp (h->a1cusp, qqr, qqa, MAXNCUSP, MAXACUSP) ;
                    d1 = linterp (h->a2cusp, qqr, qqa, MAXNCUSP, MAXACUSP) ;
                    rotate (&d0p, &d1p, d0, d1, g[0].par[NGTH]*R2D) ;

                    xs = x - d0p/h->a ;
                    ys = y - d1p/h->a ;

                    h->kappa = linterp (h->kcusp,qqr,qqa,MAXNCUSP,MAXACUSP) ;
                    h->gamma1 = linterp (h->g1cusp,qqr,qqa,MAXNCUSP,MAXACUSP) ;
                    h->gamma2 = linterp (h->g2cusp,qqr,qqa,MAXNCUSP,MAXACUSP) ;
                }
            }
            else
            {
                rotate (&xp, &yp, x, y, -theta) ;
                phis = gatan (yp,xp) ;
                prmt[0] /= sqrt( (1.+(1.-prmt[4])*(1.-prmt[4]))
                           / (2.*(1.-prmt[4]))  ) ;
                prmt[6] = (double)(xp*h->a) ;
                prmt[7] = (double)(yp*h->a) ;
/* for(i=0;i<9;i++)fprintf (fdebug,"%.3f ", prmt[i]);fprintf (fdebug,"\n") ;*/
/*                cuspfs_ (prmt, dfl, mgnf) ;*/
                while (!legal (dfl, 2) || !legal (mgnf, 5))
                {
/*if(!cmax){printf ("ge: illegal values from cuspfs_, input ") ;
  for (i=0;i<9;i++) printf ("%.3f ", prmt[i]); printf ("try again\n") ;}*/
/*if (!cmax) { fprintf (fdebug,"ge: illegal values from cuspfs_, input ") ;
for (i=0;i<9;i++) 
fprintf (fdebug,"%.3f ", prmt[i]); fprintf (fdebug,"try again\n") ; }  */
                   cmax++ ; if (cmax==10) { cmax=0; break ; }
		   /*                   cuspfs_ (prmt, dfl, mgnf) ;*/
                }
                rotate (&d0p, &d1p, dfl[0], dfl[1], g[0].par[NGTH]*R2D) ;

                h->kappa = 1.0-0.5*(mgnf[3]+mgnf[0]) ;
                h->gamma1 = 0.5*(mgnf[3]-mgnf[0]) ;
                h->gamma2 = -mgnf[1] ;
                xs = x - d0p/h->a ;
                ys = y - d1p/h->a ;
            }
            break ;
        case 4:                         /* NFW; symmetric model only */
	    r2=r*r*h->a*h->a/(ss*ss) ;
            ample_psi_NFW (ample_psi, r2) ;
            h->pot = 2.*ss*ss*b*h->a*ample_psi[0] ;
            h->kappa = 4.*b*h->a*(ample_psi[1]+
                          r*r*h->a*h->a*ample_psi[2]/(ss*ss)) ;
	    h->gamma1 = 4.0*ample_psi[2]*b*(y*y-x*x)*(h->a*h->a*h->a)/(ss*ss) ;
	    h->gamma2 = -8.0*ample_psi[2]*b*x*y*(h->a*h->a*h->a)/(ss*ss) ;
            xs = x * (1.0-4.0*ample_psi[1]*b*h->a) ;
            ys = y * (1.0-4.0*ample_psi[1]*b*h->a) ;

            break ;

        case 5:          /* NFW truncated; symmetric model only */
 /* nb a1 is the factor by which truncation radius EXCEEDS scale radius ss */
	    r2=r*r*h->a*h->a/(ss*ss) ;
   	    ample_psi_NFW_trunc (ample_psi, r2, a1) ;
            h->pot = 2.*ss*ss*b*h->a*ample_psi[0] ;
            h->kappa = 4.*b*h->a*(ample_psi[1]+
                          r*r*h->a*h->a*ample_psi[2]/(ss*ss)) ;
	    h->gamma1 = 4.0*ample_psi[2]*b*(y*y-x*x)*(h->a*h->a*h->a)/(ss*ss) ;
	    h->gamma2 = -8.0*ample_psi[2]*b*x*y*(h->a*h->a*h->a)/(ss*ss) ;
            xs = x * (1.0-4.0*ample_psi[1]*b*h->a) ;
            ys = y * (1.0-4.0*ample_psi[1]*b*h->a) ;

            break ;

        default: break ;
    }

    if (shearmag != 0.0)
    {
        cphis = cos(2*shearang) ;
        sphis = sin(2*shearang) ;
        xs += -shearmag * (x*cphis + y*sphis) ;
        ys += -shearmag * (x*sphis - y*cphis) ;
        if (!(int)g[ix].par[NGMT])
        {
            h->gamma1+=shearmag*cos(2.*shearang) ;
            h->gamma2-=shearmag*sin(2.*shearang) ;
        }
        else
        {
            h->gamma1+=shearmag*cos(2*(shearang-theta)); 
            h->gamma2+=shearmag*sin(2*(shearang-theta));
        }
    }
    h->gamma = hypot (h->gamma1, h->gamma2);

    u[0] = (h->kappa + h->gamma1);
    u[1] = u[2] = h->gamma2 ;
    u[3] = (h->kappa - h->gamma1);
   
    alpha[0] = (x - xs) ;
    alpha[1] = (y - ys) ;
   
    xs = x+g[ix].par[NGX]-s[0].par[NSX] ;
    ys = y+g[ix].par[NGY]-s[0].par[NSY] ;
    rs2 = xs*xs + ys*ys ;

    /* This routine is called once for each galaxy with an outer
       loop on pixels. On the first galaxy of the pixel, set to 0.5rs2
       For all galaxies, add the shear term
       On the last galaxy, subtract the accumulated potential */

    if (!ix) h->tdel=0.5*rs2 ;
    h->tdel += -0.5*r*r*shearmag*cos(2.*(phis-shearang+theta)) ;
    if (ix==h->ngal-1) h->tdel -= h->pot ;
/* fclose (fdebug) ;*/
}

void ucusp ()
{
    int i=0,ia=0,nloop=0, bugloop=0 ;
    double x,ctot, r, ang ;
    double dfl[2]={0.0,0.0}, mgnf[5], prmt[9] = {
            (double)g[0].par[NGB]*h->a/(2.0*PI*(double)g[0].par[NGS]),
            (double)g[0].par[NGA1],(double)g[0].par[NGA2],
            (double)g[0].par[NGS],(double)g[0].par[NGE],0.0,0.0,0.0,0.0001} ;

    prmt[0] /= sqrt( (1.+(1.-prmt[4])*(1.-prmt[4])) / (2.*(1.-prmt[4]))  ) ;
    
    if ((int)g[0].par[NGMT]==3)
    {
    	printf ("* Recalculating cusp") ; fflush (stdout) ;
        ctot = 0.0 ;
        for (ang=0.0,ia=0;ang<360.01;ia++,ang+=h->speed,nloop++)
        {
            ctot=0.0 ;
            if (nloop==36/h->speed) { nloop=0; printf (".") ; fflush(stdout);}

            for (i=0;i<(int)(NCUSP/h->speed);i++)
            {
                x=h->a*(double)i*h->speed*h->ims/NCUSP ;
                prmt[6] = (double)x*cos(ang*R2D) ;
                prmt[7] = (double)x*sin(ang*R2D) ;

		/*                cuspfs_ (prmt, dfl, mgnf) ;*/
                legal (dfl, 2) ;
                legal (mgnf, 5) ;

                ctot += sqrt(dfl[0]*dfl[0]+dfl[1]*dfl[1])
                        *cos(ang*R2D -gatan(dfl[1],dfl[0]))
                        *h->ims*h->speed*h->a/NCUSP ;
                        
                h->pcusp[ia*MAXNCUSP+i] = ctot ;
                h->a1cusp[ia*MAXNCUSP+i] = dfl[0] ;
                h->a2cusp[ia*MAXNCUSP+i] = dfl[1] ;
                h->kcusp[ia*MAXNCUSP+i] = 1.0-0.5*(mgnf[0]+mgnf[3]) ;
                h->g1cusp[ia*MAXNCUSP+i] = 0.5*(mgnf[3]-mgnf[0]) ;
                h->g2cusp[ia*MAXNCUSP+i] = -mgnf[1] ;
                h->mcusp[ia*MAXNCUSP+i] = mgnf[4] ;
            }
        }
        printf ("\n") ;
    }
}

double rotate (double *xp, double *yp, double x, double y, double theta)
{
    double c=cos(theta), s=sin(theta) ;
    *xp = x*c - y*s ;
    *yp = x*s + y*c ;
}

double linterp (double *array, double x, double y, int nx, int ny)
{
    int ix=(int)x, iy=(int)y, ii=iy*nx+ix ;
    double tt=x-(double)ix, uu=y-(double)iy ;

    if (ix<0||ix>=nx-1||iy<0||iy>=ny-1) return 0.0 ;
    
    return ((1.0-tt)*(1.0-uu)*array[ii] + tt*(1.0-uu)*array[ii+1] +
             uu*(1.0-tt)*array[ii+nx] + tt*uu*array[ii+nx+1]) ;
}

int legal (double *arr, int nelm)
{
    int i,j,islegal=1 ;
    for (i=0;i<nelm;i++)
    {
    	if (!(arr[i]>-VERYBIG&&arr[i]<VERYBIG))
    	{
    	    for (j=0;j<nelm;j++) arr[j]=0.0 ; islegal=0; break ;
    	}
    }
    return islegal ;
}
