/* ********************************* */
/*   System definitions for IGLOO v7 */
/* ********************************* */
#define PI 3.14159265359
#define E 2.7182818284
#define R2D 0.01745329252
#define C 299790
#define FTOL 1.0e-7 /* fractional criterion for simplex */
#define MAXPL 200
#define MAXS 8       /* maximum number of sources allowed */
#define MAXOPT 50    /* maximum optimizable parms for simplex */
#define MAXG 200       /* maximum number of galaxies allowed */
#define MAXP 10000   /* points cor plotting caustics */
#define CINC 0.5  /* increment for caustics */
#define MAXTOK 100   /* maximum number of words on lines in input files */
#define MAXLEN 32    /* maximum length of each word on input files */
#define MINCOREMAG 1.0e-6
#define NGPARM 12    /* number of optimizable galaxy parms for display */
#define NGTPARM 16   /* number of galaxy parms including non-displayed */
#define NSPARM 7     /* number of optimizable source parms for display */
#define MAXCOMP 100  /* max number of observed components allowed */
#define MAXITER 100  /* max number of iterations in chi-sq plot */
#define MAXNCUSP 256 /* max number of steps in r for cusp arrays */
#define MAXACUSP 361 /* max number of steps in theta for cusp arrays */
#define TYPE 1       /* code for type instruction */
#define EVAL 2       /* code for image-plane evaluation instruction */
#define OPT 'F'      /* code for PIP optimization instruction incl fluxes */
#define NFOPT 'P'    /* code for doing PIP optimization with positions only */
#define SOPT 'S'      /* code for source-plane opt. instruction incl fluxes */
#define NFSOPT 'R'    /* code for doing source-plane opt with positions only */
#define NOPT 'N'     /* code for changing opt parameters without optimization*/
#define NFIMOPT 'H'  /* code for image-plane optimization */
#define IMOPT 'I'    /* code for image-plane optimization */
#define WDOPT 'W'
#define SVOPT 'V'
#define DO_NOTHING -1 /* null code */
#define PLOT 5       /* code for plot image-plane instruction */
#define CAUSTIC 6    /* code for plot caustic instruction */
#define TDELAY 7     /* code for plot time delay instruction */
#define PRINT 8      /* code for dumping model to a postscript file */
#define VAR1 11
#define VAR2 12
#define SVD 13
#define DIVNUM 99
#define IGNORECORE 4
#define PSFBLOCK 20
#define PSFLIM 0.001
#define PIXTOT 10000
#define NCUSP 256
#define NO_ACT -1000.0    /* null code */
#define VERYBIG 1.0E+9    /* large number for simplex penalty functions */
#define VERYBIG_NIM 1.35E+9 /* large number for wrong no of images */
#define NOIMG 2           /* multiplication factor for no images penalty */
#define VERYSMALL 0.0001  /* small ellipticity */
#define FULL 1       /* set the viewport to whole-screen */
#define WPLOT 2      /* set the viewport to the image-plane screen only */
#define WPLOTP 20
#define WPRINT 3     /* set the viewport appropriate for printing */
#define WPLOT1 4     /* small inset viewport */
#define WPLOT2 5
#define WPLOT3 6
#define WPLOT4 7
#define WPLOT5 8
#define BLACK 0      /* PGPLOT black code */
#define WHITE 1      /* PGPLOT yellow code */
#define RED 2
#define GREEN 3
#define BLUE 4
#define PURPLE 6
#define YELLOW 7
#define BROWN 8
#define PG_OK 0
#define BS 0.045      /* screen button box size                   */
#define IMS 128      /* image plane dimensions                   */
#define XSTA 0.00    /* source panel start coordinates           */
#define YSTA 0.98    /*         ditto                            */
#define XGSTA 0.00   /* galaxy panel start coordinates           */
#define YGSTA 0.5    /*         ditto                            */
#define XMSTA 0.32   /* miscellaneous panel start coordinates    */
#define YMSTA 0.98
#define BMS 0.07     /* miscellaneous panel button size          */
#define XPSTA 0.54   /* control button panel start coordinates   */
#define YPSTA 0.34   /*         ditto                            */
#define BPS 0.076     /* control button size                      */
#define XZSTA 0.57   /* display panel start coordinates          */
#define YZSTA 1.00   /*         ditto                            */
#define BZS 0.43      /* display panel size                       */
#define X2YRATIO 1.37    /* x/y ratio of all buttons             */
#define ZFAC 5       /* zoom-in factor for zoom button           */
#define NGX 0        /* number in galaxy parms array of X-coord  */
#define NGY 1        /*  ditto of Y-coordinate                   */
#define NGB 2        /*  ditto of Einstein ring radius in pixels */
#define NGTH 3       /*  ditto of galaxy position angle (E of N) */
#define NGE 4        /*  ditto of ellipticity (1-b/a)            */
#define NGS 5        /*  ditto of core radius in arcseconds      */
#define NGA1 6       /*  ditto of spare parameter                */
#define NGA2 7       /*  ditto of spare parameter                */
#define NGZ 8        /*  ditto of redshift                       */
#define NGMT 9       /*  ditto of model type (0=pt, 1=SIE)       */
#define SM 10        /*  ditto of shear magnitude                */
#define SA 11        /*  ditto of shear angle                    */
#define SMERR 12     /*  ditto of shear magnitude                */
#define SAERR 13     /*  ditto of shear angle                    */
#define NGXERR 14    /*  ditto of error in galaxy position (X)   */
#define NGYERR 15    /*  ditto of error in galaxy position (Y)   */
#define NSX 0        /*  no. in source parms array of X-coord    */
#define NSY 1        /*  ditto of Y-coord                        */
#define NSMAJ 2      /*  ditto of size of major axis in pixels   */
#define NSMIN 3      /*  ditto of size of minor axis in pixels   */
#define NSTH 4       /*  ditto of position angle of ellipse      */
#define NSF 5        /*  ditto of unused parameter               */
#define NSZ 6        /*  ditto of source redshift                */
#define NUM_CONT 30  /* Number of contour levels                 */
#define IF(expr) printf(#expr "= %f\n", expr)
#define SVALPHA 50
#define SVAHAT 51
#define SVBETA 52
#define SVBHAT 53
#define SVGAMMA 54
#define SVDELTA 55
#define SVRCOST 56
#define SVRSINT 57
#define SVFR 58
#define IRAN 2.0*((float)gsl_rng_uniform(h->rng)-0.5)
#define IGDEF extern Source s[MAXS] ; extern Galaxy g[MAXG] ; extern Handle *h ; extern double *a ;
            
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <signal.h>
#include <string.h>
#include <setjmp.h>
#include "gsl/gsl_rng.h"

struct psflist
{
    int nframe ;
    int bufsiz ;
    int *ip ;
    double *val ;
} ;
typedef struct psflist Psflist ;


struct plot        /* contains information on a parameter button */
{
    float xl ;     /* physical coordinates on the screen         */
    float xu ;
    float yl ;
    float yu ;
    char de[4] ;   /* button label                               */
    int status ;   /* 1 for currently being optimised, 0 not     */
} ;
typedef struct plot Plot ;

struct tok
{
  int n ;
  char ct[MAXTOK][MAXLEN] ;
} ;
typedef struct tok Tok ;

struct galaxy
{
    double par[NGTPARM] ;   /* parameter values - includes X,Y error  */
    double ulim[NGPARM] ;   /* upper and lower limits on each param    */
    double llim[NGPARM] ;
    Plot p[NGPARM] ;       /* associated plot structure               */
} ;
typedef struct galaxy Galaxy ;

struct source
{
    double par[7] ;
    double ulim[7] ;
    double llim[7] ;
    Plot p[7] ;
} ;
typedef struct source Source ;

struct opt
{
    char sorg[MAXOPT] ;   /* 'S' if source parameter, 'G' galaxy  */
    int num[MAXOPT] ;     /* which number S or G if multiple s,g  */
    int ipar[MAXOPT] ;    /* which parameter number               */
    int otype[MAXOPT] ;   /* RED for non-opt, PURPLE for free, BLUE for
                             by Gaussian error, BLACK for hard limit */
    double refval[MAXOPT] ; /* for constrained opt, reference value */
    double err[MAXOPT] ;  /* for constrained opt, is the error */
    int nos ;             /* total number of optimised parms      */
} ;
typedef struct opt Opt ;

struct obs
{
  int ncomp ;
  int tdcomp ;         /* which component is the TD reference (0.0+/-0.0) */
  int iscore[MAXCOMP] ;
  double ra[MAXCOMP] ;
  double dec[MAXCOMP] ;
  double xsa[MAXCOMP] ;
  double ysa[MAXCOMP] ;
  int sno[MAXCOMP] ;     /* which source does it belong to? */
  int parity[MAXCOMP] ;
  int type[MAXCOMP] ;
  double td[MAXCOMP] ;
  double errtd[MAXCOMP] ;
  double tdpred[MAXCOMP] ;
  double weight[MAXCOMP] ;
  double ivecxtemp[MAXCOMP] ;
  double ivecytemp[MAXCOMP] ;
  double ivecx[MAXCOMP] ;
  double ivecy[MAXCOMP] ;
  double mag[MAXCOMP] ;
  double magtemp[MAXCOMP] ;
  double flux[MAXCOMP] ;
  double errmaj[MAXCOMP];
  double errmin[MAXCOMP];
  double errpa[MAXCOMP];
  double fluxerr[MAXCOMP];
  
  /* the ivecTEMP structures store for each component the current offset
       in the image plane for each component from the observed value.
       Whenever the amoeba+anneal algorithm detect a new best fit these
       are copied into the ivecx and ivecy arrays and plotted */
} ;
typedef struct obs Obs ;

struct handle
{
  double h0 ;
  double omega ;
  double lambda ;
  int isbigend ;
  int ismultiplane ;
  double bigger ;
  int nsrc ;
  int ngal ;
  int nx ;
  int ny ;
  int lookup ;
  int debug ;
  gsl_rng *rng ;
  Plot pspix ;
  Plot psscale ;
  Plot pipix ;
  Plot papix ;
  Plot pdocore ;
  Plot paiter ;
  Plot pdoopt ;
  Plot pims ;
  Plot pord ;
  Plot piter ;
  Plot psvsing ;
  Plot pmaga ;
  Plot pdoh0 ;
  Plot pweight ;
  Plot perror ;
  Plot pspeed ;
  Plot pdiv ;
  Plot plook ;
  Plot preg ;
  Plot prmod ;
  Plot pplot;
  Plot peval ;
  Plot popt;
  Plot ptype ;
  Plot pexit ;
  Plot paddg ;
  Plot padds ;
  Plot pwd ;
  Plot pfunk ;
  Plot pcaus;
  Plot ptdel ;
  Plot pwrite ;
  Plot pprec ;
  Plot pprint ;
  Plot pvar1 ;
  Plot pvar2 ;
  Plot psvd ;
  Obs o ;
  Opt os ;
  Opt vos ;
  double kappa ;
  double gamma1 ;
  double gamma2 ;
  double gamma ;
  double magn ;
  double pot ;
  double tdel ;
  double xoff ;
  double yoff ;
  int aiter ;
  int docore ;
  int spix ;
  int im_expect ;
  int im_got ;
  double weight[4] ;
  double reg ;
  int ord; 
  double maga ;
  int doh0 ;
  int docont ;
  int zoom ;
  double svsing ;
  int chucksing ;
  int svdwiggle ;
  float zcx ;
  float zcy ;
  float pxl ;
  float pxu ;
  float pyl ;
  float pyu ;
  float plcut ;
  float pucut ;
  double a;
  int ims ;
  double sscale ;
  double divnum ;
  int interactive;
  int noisy ;
  int doupdate ;
  char doopt ;
  int usep ;
  double prm[2][MAXOPT] ;
  int usedim ;
  int dim ;
  double step ;
  double speed ;
  int uca ;
  double pcusp[MAXNCUSP*MAXACUSP];
  double mcusp[MAXNCUSP*MAXACUSP];
  double a1cusp[MAXNCUSP*MAXACUSP];
  double a2cusp[MAXNCUSP*MAXACUSP];
  double kcusp[MAXNCUSP*MAXACUSP] ;
  double g1cusp[MAXNCUSP*MAXACUSP] ;
  double g2cusp[MAXNCUSP*MAXACUSP] ;
  double dtemp;
  int iter;
  int neval;
  double stemp;
} ;
typedef struct handle Handle ;

int    aix (int, int) ;
double amotry (double [][MAXOPT],double *,double *,double *,double *,
          int,int *,double *,double,double,
          double (*afunk)(double *), int) ;
/*
void   amoeba_calc (double [][], double [], double *, double *, double,
          double, int *, int *, double, double (*afunk)(double *), int) ;
*/
void   arc2pix (int) ;
void   butinit (Plot *, int, int, char *) ;
double calcsvd (double *) ;
void   cmxmul (double, double *, double *) ;
double compare_td () ;
void   convolve (Obs *, double *, double *, double, int) ;
void   oconvolve (Obs *, double *, Psflist *, double, int, int, int, double) ;
void   cuspfs_ (double *, double *, double *) ;
double dist (double) ;
double ddist (double, double) ;
double dr (double, void *) ;
Obs   *duplicate_im (Obs *) ;
double efunk (double *) ;
double errellip (double, double, double, double, double) ;
int    fac (int) ;
int    ifactorial (int) ;
double factorial (int) ;
double *fitsin (char *, int *, double *) ;
void   fitsout (char *, int, int, double *) ;
double gatan (double, double) ;
void   g2image () ;
double gamoeba (double (*afunk)(double *)) ;
double *gcsm (double, double, double) ;
double getbeta (double, int, int) ;
int    getsvd (double *, double *, int *, int , double *) ;
Tok   *gettok (FILE *) ;
int    getendian () ;
void   get_source_ellip (double, double, double, double *, double *, double *) ;
void   getu (double, double, double, int, double *, double *) ;
void   gfill (Galaxy *) ;
void   ghelp (int, int) ;
void   ginit (Galaxy *, int) ;
void   ginput (char *);
void   goutput (char *) ;
void   goutput_lm (char *) ;
void   gopt () ;
void   gplot () ;
void   gprint () ;
Obs   *groot (double, double) ;
Obs   *groot_old (double, double) ;
double gsvd () ;
void   gtype (char *) ;
double gwd (double *) ;
double gwds (double *) ;
double gwdp (double *) ;
double *gwds_lens (double *, double , double , int, int) ;
double *gwds_convolve (double *, double *) ;
double *gwdp_convolve (double *, double *) ;
double *getweight (double *,int,char *,double,double) ;
void herm_image (double *, int, int, double, int, int, double, double) ;
double hermite (int, double, double[]) ;
void   igread (double *, FILE *, int) ;
void   igwrite (double, FILE *) ;
double imageplane (Obs *, int) ;
void   imcopy (Obs *, int, Obs *, int) ;
int    imident (double, double *) ;
void   iminit (Obs *) ;
int   *imn (int, int) ;
void   imsquash (Obs *) ;
int    legal (double *, int) ;
double linterp (double *, double, double, int, int) ;
int    loadfromp (double *, int) ;
void   loadtop () ;
void   mbutinit (Plot *, int, int, char *) ;
void   mkrect (float, float, float, float, int, int) ;
void   minmax (double *, int, double *, double *, int *, int *) ;
void   mxadd (double *, double *, double *) ;
void   mxinv (double *, double *) ;
void   mxmul (double *, double *, double *) ;
void   mxsub (double *, double *, double *) ;
void   mxrot (double *, double) ;
void   mxvec (double *, double, double , double *, double *) ;
double normfac (int, int) ;
void   optadd (int , int , char, int, double, double) ;
int    optcheck (Opt *, int, int, char, double *) ;
void   optdel (int , int , char ) ;
void   opt_identify (double, double, char, int) ;
void   optsrc (int) ;
void   permute (int *, int, int) ;
void   permute_swap (int *, int *) ;
void   pfill (Plot *, double, int) ;
void   pifill (Plot *, int, int) ;
void   pcfill (Plot *, char *, int) ;
void   pinit (Source *, Galaxy *) ;
void   plinit (Psflist *) ;
double plotget (double) ;
void   plotpl (Psflist *, int ) ;
void   plotvar (double *, double *, double *, int *, int, int, int) ;
void   plotthings (char *) ;
void   refine_im (Obs *, double, double, int) ;
void   rescale (double) ;
double rotate (double *, double *, double, double, double) ;
void   screen (int) ;
void   sfill (Source *) ;
double *shapelet (double *, double, int, int , double, double) ;
void   sinit (Source *, int) ;
void   splefs_ (double *, double *, double *) ;
int    sort_comp (const void *, const void *) ;
int    sort_compf (const void *, const void *) ;
int    sortindex (double, int *) ;
double sourceplane (int) ;
double svg1 (double *, int, int, int, int) ;
void   ucusp () ;
void   update (double *) ;
void   varopt (double *, double *, int *) ;


