#include "gdefs.h"
#include "gsl/gsl_integration.h"

IGDEF

double *gcsm (double xgrid, double ygrid, double zs)
{
    static double atot[4] = {0.0,0.0,0.0,0.0}, zfac1, zfac2,s1,s2,g1,g2  ;
    double aa[MAXG][4],u[MAXG][4],xix[MAXG],xiy[MAXG],imx[4] = {1.0,0.0,0.0,1.0},
    scr1[4],scr2[4],eta[2],scr3[4]={0.0,0.0,0.0,0.0},scr4[4],alpha[MAXG][2],
    xi[MAXG][2], zfac, rot[4], gam[4], kap=0.0 ;
    int i=0, j=0, index[MAXG], k, ixi, ixj, ismultiplane=0 ;
    static int n ;

    h->pot = 0.0 ;
    for (i=0;i<h->ngal;i++)
    {
    	xi[i][0] = xgrid ;
    	xi[i][1] = ygrid ;
        for (j=0;j<h->ngal;j++)
            if (g[i].par[NGZ]!=g[j].par[NGZ]) ismultiplane = 1 ;
    }

    if (!ismultiplane)
    {
    	for (i=0;i<4;i++) atot[i] = (i==0||i==3) ? 1 : 0 ;
    	h->xoff = h->yoff = 0.0 ;
    	
        for (i=0;i<h->ngal;i++)
        {
    	    getu (xi[i][0]-g[i].par[NGX], xi[i][1]-g[i].par[NGY], 
                               zs, i, u[i], alpha[i]) ;

            kap = 0.5*(u[i][0]+u[i][3]) ;
            u[i][0]-=kap ;
            u[i][3]-=kap ;
            mxrot (u[i], -2.0*g[i].par[NGTH]) ;
            u[i][0]+=kap ;
            u[i][3]+=kap ;

            for (j=0;j<4;j++) atot[j] -= u[i][j] ;
            h->xoff += alpha[i][0] ;
            h->yoff += alpha[i][1] ;
            h->magn = 1.0/(atot[0]*atot[3]-atot[1]*atot[2]) ;
            if (h->magn<VERYBIG && h->magn>-VERYBIG) ; else h->magn=0.0 ;
        }
        
        /* get kappa and the gammas back from atot */

        h->kappa = 1.0-0.5*(atot[0]+atot[3]) ;
        h->gamma1 = -0.5*(atot[0]-atot[3]) ;
        h->gamma2 = -atot[1] ;
        h->gamma = hypot (h->gamma1, h->gamma2) ;
        
        h->neval++ ;
        return atot ;
    }

    n = sortindex (zs, index) ;

    for (i=0;i<h->ngal; i++)
    {
        aa[i][0]=aa[i][3]=1.0;  
        aa[i][1]=aa[i][2]=0.0;
    }
    
    for (i=0;i<n;i++)
    {
        ixi = index[i] ;
   	getu (xi[i][0]-g[ixi].par[NGX], xi[i][1]-g[ixi].par[NGY], 
                               zs, ixi, u[i], alpha[i]) ;

        zfac = ddist(0.,s[0].par[NSZ]) / ddist (g[ixi].par[NGZ], s[0].par[NSZ]) ;
        alpha[i][0] *= zfac ;
        alpha[i][1] *= zfac ;

        for (j=i+1;j<n;j++)
	{
	    ixj=index[j] ;
	    zfac = ddist(g[ixi].par[NGZ],g[ixj].par[NGZ])/ddist(0.,g[ixj].par[NGZ]) ;
	    xi[j][0] -= alpha[i][0] * zfac ;
	    xi[j][1] -= alpha[i][1] * zfac ;
        }
    	for (j=0;j<i;j++)
    	{
            mxmul (u[j], aa[j], scr1) ;
            cmxmul (getbeta (zs, ixi,index[j]), scr1, scr2) ;
            mxadd (scr3, scr2, scr3) ;
        }
        mxsub (imx, scr3, aa[i]) ;
    }

    for (i=0;i<4;i++) scr3[i]=0.0 ;
    for (i=0;i<4;i++) scr4[i]=0.0 ;
    eta[0] = xi[0][0] ;
    eta[1] = xi[0][1] ;
    
    for (i=0;i<n;i++)
    {
    	for (j=0;j<i;j++)
    	{
            mxmul (u[j], aa[j], scr1) ;
            cmxmul (getbeta (zs, index[i],index[j]), scr1, scr2) ;
            mxadd (scr3, scr2, scr3) ;
    	}
    	mxsub (imx, scr3, scr1) ;
    	mxmul (u[i], scr1, scr2) ;
    	mxadd (scr4, scr2, scr4) ;
        zfac = ddist(g[index[i]].par[NGZ],zs) / ddist(0.,zs) ;
        eta[0] -= alpha[i][0]*zfac ;
        eta[1] -= alpha[i][1]*zfac ;
    }
    mxsub (imx, scr4, atot) ;
    h->magn = 1.0/(atot[0]*atot[3]-atot[1]*atot[2]) ;
    if (h->magn < VERYBIG && h->magn > -VERYBIG) ; else h->magn=0.0 ;
    h->xoff = xgrid-eta[0] ;
    h->yoff = ygrid-eta[1] ;
    h->neval++ ;
    return atot ;
}

int sortindex (double zs, int *index)
{
  /* sorts an index of galaxies with z<z(s) into redshift order */
    int i, j, n=0, ng=h->ngal, ix=0, iz[MAXG] ;
    double gmin, z[MAXG] ;

    for (i=0; i<h->ngal; i++) { z[i] = g[i].par[NGZ] ; iz[i]=i ; }

    for (i=0; i<h->ngal; i++)
    {
        gmin = VERYBIG ;
        for (j=0; j<ng; j++)
	{
            if (z[j] <= gmin)
	    {
                index[i] = iz[j] ;
                gmin = z[j] ;
            }
	}
        for (j=index[i]; j<ng-1; j++)
	{
            z[j] = z[j+1] ;
            iz[j] = iz[j+1] ;
	}
        ng-- ;
        if (gmin < zs) n++ ;
    }
    return n ;
}
void cmxmul (double c, double *mx, double *output)
{
    int i; for (i=0;i<4;i++) output[i] = c*mx[i] ;
}
void mxinv (double *mx1, double *output)
{
    double det = 1.0/(mx1[0]*mx1[3]-mx1[1]*mx1[2]) ;
    output[0] = mx1[3]*det ; output[1] = -mx1[1]*det;
    output[2] =-mx1[2]*det ; output[3] =  mx1[0]*det;
}
void mxvec (double *mx1, double xin, double yin, double *xout, double *yout)
{
    *xout = mx1[0]*xin + mx1[1]*yin ;
    *yout = mx1[2]*xin + mx1[3]*yin ;
}
void mxsub (double *mx1, double *mx2, double *output)
{
    int i; for (i=0;i<4;i++) output[i] = mx1[i] - mx2[i] ;
}
void mxadd (double *mx1, double *mx2, double *output)
{
    int i; for (i=0;i<4;i++) output[i] = mx1[i] + mx2[i] ;
}
void mxmul (double *mx1, double *mx2, double *output)
{
    output[0] = mx1[0]*mx2[0]+mx1[1]*mx2[2] ;
    output[1] = mx1[0]*mx2[1]+mx1[1]*mx2[3] ;
    output[2] = mx1[2]*mx2[0]+mx1[3]*mx2[2] ;
    output[3] = mx1[2]*mx2[1]+mx1[3]*mx2[3] ;
}
void mxrot (double *mx, double ang)
{
    double c = cos(3.141592654*ang/180.0),
           s = sin(3.141592654*ang/180.0),
           t[4] = { c*mx[0]+s*mx[2], c*mx[1]+s*mx[3],
                   -s*mx[0]+c*mx[2], -s*mx[1]+c*mx[3] } ;
    int i=0;
    for (i=0;i<4;i++) mx[i] = t[i] ;
}


double getbeta (double zs, int i, int j)
{
    double dij = ddist (g[i].par[NGZ], g[j].par[NGZ]) ;
    double ds = ddist (0.,zs) ;
    double dj = ddist (0.,g[j].par[NGZ]) ;
    double dis = ddist (g[i].par[NGZ], zs) ;
    return (dij*ds/(dj*dis)) ;
}

double ddist (double z1, double z2)
{
    double dh,dm,aerr,oc[3] = {h->omega,h->lambda,0.0} ;
    size_t nev ;
    oc[2] = 1.0-oc[0]-oc[1] ;  /* omega_curvature */
    gsl_function F ;
    F.function = &dr ;
    F.params = &oc ;
    gsl_integration_qng (&F, z1, z2, 0.0, 1.e-4, &dh, &aerr, &nev) ;

    if (oc[2]>1.0/VERYBIG)       dm = sinh (oc[2]*dh) / oc[2] ;
    else if (oc[2]<-1.0/VERYBIG) dm = sin (oc[2]*dh) / oc[2] ;
    else                         dm = dh ;
    return (dm*(C/h->h0)/(1.+z2)) ;
}

double dr (double z, void *params)
{
    double om = *(double *) params,lambda = *((double *) params+1) ;
    return (1.0/sqrt((1.-om-lambda)*(1.+z)*(1.+z)+
                    om*(1.+z)*(1.+z)*(1.+z)+lambda)) ;
}
