#include "gdefs.h"
#include "gpgdefs.h"

IGDEF

void gcrit()
{
    double cutx[MAXP],cuty[MAXP],critx[MAXP],crity[MAXP],causx[MAXP],
    causy[MAXP],xt, yt, xk, yk, incr, mag, magold, zs, minmag=VERYBIG ;
    int i, j, points=0, cpoints=0 ;

    for (i=0;i<h->ims;i++)
    {
        for (j=0;j<h->ims;j++)
        {
            gcsm ((double)i,(double)j,s[0].par[NSZ]);
            a[j*h->ims+i] = fabs (h->magn) ;
        }
    }
    for (i=1;i<h->ims-1;i++)
    {
        for (j=1;j<h->ims-1;j++)
        {
	    if (a[j*h->ims+i]<a[(j+1)*h->ims+i] &&
                a[j*h->ims+i]<a[(j-1)*h->ims+i]&&
                a[j*h->ims+i]<a[j*h->ims+i+1]&&
                a[j*h->ims+i]<a[j*h->ims+i-1])
            {
            	for (xk=-0.5;xk<0.5;xk+=0.1)
            	{
            	    for (yk=-0.5;yk<0.5;yk+=0.1)
            	    {
                        gcsm ((double)i+xk,(double)j+yk,s[0].par[NSZ]);
                        if ((double)i+xk-h->xoff>0.0&&(double)i+xk-h->xoff<h->ims&&
                            (double)j+yk-h->yoff>0.0&&(double)j+yk-h->yoff<h->ims)
                        {
               	            cutx[cpoints] = (double)i+xk-h->xoff ;
            	            cuty[cpoints++] = (double)j+yk-h->yoff ;
            	            if (cpoints > MAXP) goto cz ;
            	        }
            	    }
            	}
            }
        }
    }

cz: xt=g[0].par[NGX]-10*g[0].par[NGB];
    yt=g[0].par[NGY]-10*g[0].par[NGB];
    mag=1;

    do 
    {
        do
        {
            yt+=CINC;
            gcsm(xt, yt, s[0].par[NSZ]);
            magold=mag;
            mag=h->magn;

            if(mag<0 && magold>0 || mag>0 && magold<0)
            {
                critx[points]=xt;
                crity[points]=yt;
                causx[points]=xt-h->xoff;
                causy[points]=yt-h->yoff;
                points++;
            }

        } while(yt<h->ims);

        xt+=CINC;
        yt=g[0].par[NGY]-10*g[0].par[NGB];

    } while(xt<h->ims);

    /* Now repeat but search in the x direction first*/
    mag=1;
    do 
    {
        do
        {
            xt+=CINC;
            gcsm(xt, yt, s[0].par[NSZ]);
            magold=mag;
            mag=h->magn;

            if(mag<0 && magold>0 || mag>0 && magold<0)
            {
                critx[points]=xt;
                crity[points]=yt;
                causx[points]=xt-h->xoff;
                causy[points]=yt-h->yoff;
                points++;
            }

        } while(xt<h->ims); /*Do loop to sweep through x values*/

        yt+=CINC;
        xt=g[0].par[NGX]-4*g[0].par[NGB];
    } while(yt<h->ims); /*Do loop to sweep through y values*/

    screen (WPLOTP) ;
    pg_sci(WHITE);
    pg_box("BC",0.0,0,"BC",0.0,0);
    pg_sci(GREEN);
    for(i=0;i<points;i++)
        pg_dpoint(1,&critx[i],&crity[i],1);

    pg_sci(RED);
    for(i=0;i<points;i++)
        pg_dpoint(1,&causx[i],&causy[i],1);

    pg_sci(BROWN);
    for(i=0;i<cpoints;i++)
        pg_dpoint(1,&cutx[i],&cuty[i],1);
    
    pg_sci(WHITE);
    screen (FULL) ;
}
