#include "gdefs.h"
#include "gpgdefs.h"
#include "gsl/gsl_multimin.h"

IGDEF
double toefunk (const gsl_vector *, void *) ;

double gamoeba (double (*funk)(double *))
{
    size_t niter = 0 ;
    double amosize, chi, oldchi=VERYBIG ;
    const gsl_multimin_fminimizer_type *T = gsl_multimin_fminimizer_nmsimplex ;
    gsl_vector *ss, *x ;
    gsl_multimin_fminimizer *S = NULL ;
    double par[MAXOPT] = { 1.0, 2.0 } ;
    gsl_multimin_function my_func ;
    int i,j,status,ndim = (h->usedim) ? h->dim : h->os.nos ;
    
    if (!h->usep) loadtop () ;
    if (!ndim) return ((h->doopt==WDOPT)?gwd(h->prm[0]):efunk(h->prm[0])) ;
    ss = gsl_vector_alloc (ndim) ;
    x = gsl_vector_alloc (ndim) ;
    for (i=0;i<ndim;i++)
    {
        gsl_vector_set (x, i, h->prm[0][i]) ;
        if (h->prm[1][i] != 0.0) gsl_vector_set (ss, i, h->prm[1][i]) ;
        else gsl_vector_set (ss, i, h->step*h->prm[0][i]) ;
    }

    my_func.f = &toefunk ;
    my_func.n = ndim ;
    my_func.params = (void *)&par ;

    S = gsl_multimin_fminimizer_alloc (T, ndim) ;
    gsl_multimin_fminimizer_set (S, &my_func, x, ss) ;
    niter = 0 ;

    do
    {
    	niter++ ;
    	if (status = gsl_multimin_fminimizer_iterate (S)) break ;
    	amosize = gsl_multimin_fminimizer_size (S) ;
    	status = gsl_multimin_test_size (amosize, FTOL) ;
    	if ((chi=S->fval)<oldchi)
    	{
    	    oldchi = chi ;
       	    for (i=0;i<ndim;i++) printf ("%.2f ", gsl_vector_get (S->x,i)) ;
    	    printf ("->%.2f (SS=%.2g)\n", chi, amosize) ;
    	    if (h->doupdate && !h->usep)
    	    {
    	    	for (j=0;j<h->o.ncomp;j++)
    	    	{
    	    	    h->o.ivecx[j] = h->o.ivecxtemp[j] ;
    	    	    h->o.ivecy[j] = h->o.ivecytemp[j] ;
    	            h->o.mag[j] = h->o.magtemp[j] ;
    	        }
    	        loadfromp (S->x->data, 1) ;
    	    }
    	}
    }
    while (status==GSL_CONTINUE && niter<abs(h->iter)) ;

    h->noisy = 2 ;
    for (i=0;i<ndim;i++) h->prm[0][i] = gsl_vector_get (S->x, i) ;
    for (i=0;i<h->o.ncomp;i++)
        printf ("%.2f ",h->o.magtemp[i]) ;
    printf ("\n") ;
    printf ("*** BEST chi-sq: %f\n", chi = funk (h->prm[0])) ;
    h->noisy = 0 ;
    if (!h->usep) loadfromp (h->prm[0], 0) ;
    
    gsl_vector_free (x) ;
    gsl_vector_free (ss) ;
    gsl_multimin_fminimizer_free (S) ;
    return chi ;
}

double toefunk (const gsl_vector *v, void *pp)
{
    double *p = (double *) pp ;

    switch (h->doopt) {
    	case SVOPT: return calcsvd (v->data) ;
    	case WDOPT: return gwd (v->data) ;
    	default: return efunk (v->data) ;
    }
}

