#include "gdefs.h"
#include "gpgdefs.h"

IGDEF

void pfill (Plot *p, double f, int col)
{
    char thing[30] ;
    sprintf (thing, "%5f", f) ;  thing[4]='\0';
    mkrect (p->xl, p->xu, p->yl, p->yu, 1, col) ;
    mkrect (p->xl, p->xu, p->yl, p->yu, 2, 1) ;
    pg_text (p->xl+0.1*(p->xu-p->xl), p->yl+0.65*(p->yu-p->yl), p->de) ;
    if (f!=NO_ACT) pg_text (p->xl+0.1*(p->xu-p->xl), p->yl+0.1*(p->yu-p->yl), thing) ;
}

void pifill (Plot *p, int f, int col)
{
    char thing[30] ;
    sprintf (thing, "%5d", f) ;  thing[5]='\0';
    mkrect (p->xl, p->xu, p->yl, p->yu, 1, col) ;
    mkrect (p->xl, p->xu, p->yl, p->yu, 2, 1) ;
    pg_text (p->xl+0.1*(p->xu-p->xl), p->yl+0.65*(p->yu-p->yl), p->de) ;
    if (f!=NO_ACT) pg_text (p->xl+0.1*(p->xu-p->xl), p->yl+0.1*(p->yu-p->yl), thing) ;
}

void pcfill (Plot *p, char *c, int col)
{
    mkrect (p->xl, p->xu, p->yl, p->yu, 1, col) ;
    mkrect (p->xl, p->xu, p->yl, p->yu, 2, 1) ;
    pg_text (p->xl+0.1*(p->xu-p->xl), p->yl+0.65*(p->yu-p->yl), p->de) ;
    pg_text (p->xl+0.1*(p->xu-p->xl), p->yl+0.1*(p->yu-p->yl), c) ;
}

int pcurs ()
{
    static float xr, yr ;
    double x, y, fi, dist, olddist, wantx, wanty, *p=NULL, val,
    sbig[NSPARM] = { 10.0,10.0,10.0,10.0,10.0,10.0,1.0 },
    ssmall[NSPARM] = { 1.0,1.0,1.0,1.0,1.0,1.0,0.1 },
    gbig [NGPARM] = { 10.0,10.0,10.0,10.0,0.1,1.0,1.0,1.0,1.0,1.0,0.1,10.0 },
    gsmall [NGPARM] = { 1.0,1.0,1.0,1.0,0.01,0.1,0.1,0.1,0.1,0.1,0.01,1.0 };
    char c, command[10], filename[128] ;
    int i, j, wno, ipar, coord ;

    pg_curse (&xr, &yr, &c) ; 
    c = toupper (c) ; x = (double) xr ; y = (double) yr ;
    if (c=='@') { ghelp (0, -1) ; return DO_NOTHING ; }
    if (c=='+') { ghelp (0, -2) ; return DO_NOTHING ; }
    
    if (XZSTA<x && x<XZSTA+BZS && YZSTA-X2YRATIO*BZS<y && y<YZSTA)/* in plot */
    {
    	if (c=='?') { ghelp (0, 0) ; return DO_NOTHING ; } 
        if (c=='D')   /* middle button, move the galaxy around */
        {
            olddist = h->ims*h->ims ;
            for (i=0; i<h->ngal; i++)
            {
                dist = hypot (g[i].par[NGX]-h->ims*(x-XZSTA)/BZS,
                g[i].par[NGY]-h->ims*(y-(YZSTA-X2YRATIO*BZS))/(X2YRATIO*BZS));
                if (dist < olddist)
                {
                    wno = i ;
                    olddist = dist ;
                    wantx = h->ims*(x-XZSTA)/BZS ;
                    wanty = h->ims*(y-(YZSTA-X2YRATIO*BZS))/(X2YRATIO*BZS) ;
                }
            }
            g[wno].par[NGX] = wantx ;
            pfill(&g[wno].p[NGX],g[wno].par[NGX],g[wno].p[NGX].status) ;
            g[wno].par[NGY] = wanty ;
            pfill(&g[wno].p[NGY],g[wno].par[NGY],g[wno].p[NGY].status) ;
        }
        if (c=='A')   /* LH button, move the source around */
        {
            olddist = h->ims*h->ims ;
            for (i=0; i<h->nsrc; i++)
            {
                dist = hypot (s[i].par[NSX]-h->ims*(x-XZSTA)/BZS,
                s[i].par[NSY]-h->ims*(y-(YZSTA-X2YRATIO*BZS))/(X2YRATIO*BZS));
                if (dist < olddist)
                {
                    wno = i ;
                    olddist = dist ;
                    wantx = h->ims*(x-XZSTA)/BZS ;
                    wanty = h->ims*(y-(YZSTA-X2YRATIO*BZS))/(X2YRATIO*BZS) ;
                }
            }
            s[wno].par[NSX] = wantx ;
            pfill (&s[wno].p[NSX], s[wno].par[NSX], s[wno].p[NSX].status) ;
            s[wno].par[NSY] = wanty ;
            pfill (&s[wno].p[NSY], s[wno].par[NSY], s[wno].p[NSY].status) ;
        }
        if (c=='X')    /* RH button, cycle the zoom */
        {
            if (h->zoom == 3)
            {
            	h->zoom = 0 ;
            	h->pxl = h->pyl = -h->a*(float)h->ims/2.0 ;
            	h->pxu = h->pyu =  h->a*(float)h->ims/2.0 ;
            	h->zcx = h->zcy =  0.0 ;
            	printf ("Zoom reset to whole screen\n") ;
            }
            else
            {
/*
                wantx = (-h->a*(float)h->ims/2.0)+h->a*(x-XZSTA)/BZS ;
                wanty = (-h->a*(float)h->ims/2.0)+h->a*(y-(YZSTA-X2YRATIO*BZS))/(X2YRATIO*BZS) ;
                h->zcx += (wantx-0.5*h->ims)/pow(ZFAC,(double)h->zoom) ;
                h->zcy += (wanty-0.5*h->ims)/pow(ZFAC,(double)h->zoom) ;
*/
            	h->zoom++ ;
            	h->zcx = h->pxl + (h->pxu-h->pxl)*(x-XZSTA)/BZS ;
            	h->zcy = h->pyl + (h->pyu-h->pyl)*(y-(YZSTA-X2YRATIO*BZS))/(X2YRATIO*BZS) ;
            	h->pxl = h->zcx-h->a*h->ims/pow(ZFAC,(float)h->zoom) ;
            	h->pxu = h->zcx+h->a*h->ims/pow(ZFAC,(float)h->zoom) ;
            	h->pyl = h->zcy-h->a*h->ims/pow(ZFAC,(float)h->zoom) ;
            	h->pyu = h->zcy+h->a*h->ims/pow(ZFAC,(float)h->zoom) ;
            	printf ("Zoom in to (%f %f), (%f %f)\n",h->pxl,h->pyl,h->pxu,h->pyu) ;
            }
        }
        return DO_NOTHING ;
    }
    if (x>XPSTA && y<YPSTA)     /* in the buttons region */
    {
    	coord = 10*((int)((x-XPSTA)/BPS)) + (int)((YPSTA-y)/BPS) ;
    	if (c=='?') { ghelp (1, coord) ; return DO_NOTHING ; }

    	switch (coord)
    	{
   	case 00:
            if (h->ngal == MAXG) { 
                printf ("Too many galaxies\n");
                return DO_NOTHING ;
            };
            gfill (&g[h->ngal++]) ;
            return DO_NOTHING ;
        case 01:
            if (h->nsrc == MAXS) { 
                printf ("Too many sources\n");
                return DO_NOTHING;
            };
            sfill (&s[h->nsrc++]) ;
            return DO_NOTHING ;
        case 02:   return 0 ;
        case 10:   return TYPE ;
        case 11:   return EVAL ;
        case 12:   return OPT ;
        case 20:   printf ("Enter filename: ") ;
                   scanf ("%s", filename) ;
                   ginput (filename) ;
                   return DO_NOTHING ;
        case 21:
	    if (c=='M') strcpy (command, "magn") ;
	    if (c=='1') strcpy (command, "gamm1") ;
	    if (c=='2') strcpy (command, "gamm2") ;
	    if (c=='G') strcpy (command, "gamma") ;
	    if (c=='K') strcpy (command, "kappa") ;
	    if (c=='D') strcpy (command, "defl") ;
	    if (c=='T') strcpy (command, "tdel") ;
	    if (c=='P') strcpy (command, "potn") ;
	    if (c=='X') strcpy (command, "xdefl") ;
	    if (c=='Y') strcpy (command, "ydefl") ;
            plotthings (command) ;
            return DO_NOTHING ;           
        case 22:
	  if (c=='S') gwds(NULL); else if (c=='P')gwdp(NULL) ; else gwd(NULL) ;
            return DO_NOTHING ;
        case 30:
            if (h->o.ncomp)
            {
                h->noisy = 2 ;
                printf ("Current value is %f\n", (val=efunk (p))) ;
                if (val==VERYBIG_NIM)
                {
                   printf ("Wrong number of images (expect %d, got %d) : try setting docore=1\n",h->im_expect,h->im_got) ;
                   printf ("or alternatively adjust your Einstein radius to get a different number\n") ;
                }
                h->noisy = 0 ;
            }
            else printf ("Need to read in a model first\n") ;
            return DO_NOTHING ;
        case 31:
            return CAUSTIC;
        case 32:
            strcpy (command, "tdel") ;
            h->docont = 1 ;
            plotthings (command) ;
            h->docont = 0 ;
            return DO_NOTHING ;
        case 40:
            if (c=='L')
            {
            	printf ("Writing lensmodel output file output.lm\n") ;
            	printf ("Writing lensmodel startup file output.start\n") ;
            	goutput_lm ("output.lm") ;
            }
            else
            {
                printf ("Writing parameters to new file output.txt\n") ;
                goutput ("output.txt") ;
            }
            fitsout ("igloo_out.fits", h->ims, h->ims, a) ;
            return DO_NOTHING ;
        case 41:
            gprec () ;
            return DO_NOTHING ;
        case 42:
            printf ("Plotting output to Postscript file pgplot.ps...") ;
            fflush (stdin) ; fflush (stdout) ;
            gprint () ;
            printf ("done\n") ;
            return DO_NOTHING ;
        case 50:     return VAR1 ;
        case 51:     if (c=='W'||c=='w') h->doopt=WDOPT ; else h->doopt=NFOPT;
                     return VAR2 ;
        case 52:     
            if (c=='D') h->svdwiggle = 1 ;
            else if (c=='X') h->svdwiggle = 2 ;
            else h->svdwiggle = 0 ;
            return SVD ;
        }
    }

    if (c=='X')  /* RH button anywhere apart from buttons or plot */
    {
        h->bigger = (h->bigger==1.0) ? -1.0 : 1.0 ;
        return DO_NOTHING ;
    }

    if (x>XMSTA && x<XMSTA+3*BMS && y<YMSTA && y>YMSTA-6*BMS)     /* in the miscellaneous-parameters region */
    {
    	coord = 10*((int)((x-XMSTA)/BMS)) + (int)((YMSTA-y)/BMS) ;
    	if (c=='?') { ghelp (2, coord) ; return DO_NOTHING ; }

    	switch (coord)
    	{
    	case 00: if (c=='A') h->spix += (int)(h->bigger) ;
          	 if (c=='D') h->spix += (int)(h->bigger)*10 ;
          	 pifill (&h->pspix, h->spix, BROWN) ;  return (DO_NOTHING);
    	case 10: if (c=='A') h->sscale += h->bigger/1000.0 ;
          	 if (c=='D') h->sscale += h->bigger/100.0 ;
          	 if (c=='S') h->sscale += h->bigger/10000.0 ;
          	 pfill (&h->psscale, h->sscale*1000.0, BROWN) ;  return (DO_NOTHING);
    	case 20: if (c=='A') h->a += h->bigger/1000.0 ;
          	 if (c=='D') h->a += h->bigger/100.0 ;
                 h->pxl = h->pyl = -h->a*h->ims/2.0 ;
                 h->pxu = h->pyu =  h->a*h->ims/2.0 ;
          	 pfill (&h->papix, h->a*1000.0, BROWN) ;  return (DO_NOTHING);
    	case 01: if (c=='A') h->docore = 1 ;
          	 if (c=='D') h->docore = 0 ;
          	 pifill (&h->pdocore, h->docore, BROWN) ;  return (DO_NOTHING);
    	case 11: if (c=='A') h->aiter += h->bigger ;
          	 if (c=='D') h->aiter += h->bigger*10 ;
          	 pifill (&h->paiter, h->aiter, BROWN) ;  return (DO_NOTHING);
    	case 21: h->doopt = c ;
    	         if (c=='A') h->doopt = NOPT ;
    	         if (c=='P') h->doopt = NFOPT ;
    	         if (c=='F') h->doopt = OPT ;
    	         if (c=='R') h->doopt = NFSOPT ;
    	         if (c=='S') h->doopt = SOPT ;
    	         if (c=='W') h->doopt = WDOPT ;
    	         if (c=='I') h->doopt = IMOPT ;
    	         if (c=='H') h->doopt = NFIMOPT ;
          	 pcfill (&h->pdoopt, &h->doopt, BROWN) ;  return (DO_NOTHING);
    	case 02: if (c=='A') {
                      h->ims += h->bigger*1.0 ;  
                      a = (double *)realloc(a,h->ims*h->ims*sizeof(double));
		 }
 	         if (c=='D') {
                      h->ims += h->bigger*10.0 ;
                      a = (double *)realloc(a,h->ims*h->ims*sizeof(double));
		 }
                 h->pxl = h->pyl = -h->a*(float)h->ims/2.0 ;
                 h->pxu = h->pyu =  h->a*(float)h->ims/2.0 ;
          	 pifill (&h->pims, h->ims, BROWN) ;  return (DO_NOTHING);
    	case 12: if (c=='A') h->ord += (int)h->bigger ;
          	 if (c=='D') h->ord += (int)h->bigger ;
          	 pifill (&h->pord, h->ord, BROWN) ;  return (DO_NOTHING);
    	case 22: if (c=='A') h->iter += (int)(h->bigger)*10 ;
          	 if (c=='D') h->iter += (int)(h->bigger)*100 ;
          	 if (c=='S') h->iter += (int)h->bigger ;
          	 pifill (&h->piter, h->iter, BROWN) ;  return (DO_NOTHING);
    	case 03: if (c=='A') h->svsing += h->bigger*0.1 ;
          	 if (c=='D') h->svsing += h->bigger ;
          	 pfill (&h->psvsing, h->svsing, BROWN) ;  return (DO_NOTHING);
    	case 13: if (c=='A') h->maga += h->bigger ;
          	 if (c=='D') h->maga += h->bigger*10.0 ;
          	 if (c=='S') h->maga += h->bigger*0.1 ;
          	 pfill (&h->pmaga, h->maga, BROWN) ;  return (DO_NOTHING);
    	case 23: if (c=='A') h->doh0 = h->uca = 1 ;  /* for tdel need to compute potl */
          	 if (c=='D') h->doh0 = h->uca = 0 ;
          	 pifill (&h->pdoh0, h->doh0, BROWN) ;  return (DO_NOTHING);
    	case 04: if (c=='A') h->speed += h->bigger ;
          	 if (c=='D') h->speed += h->bigger*10.0 ;
          	 pfill (&h->pspeed, h->speed, BROWN) ;  return (DO_NOTHING);
    	case 14: if (c=='A') h->reg += h->bigger*0.1 ;
          	 if (c=='D') h->reg += h->bigger ;
          	 pfill (&h->preg, h->reg, BROWN) ;  return (DO_NOTHING);
    	case 24: if (c=='A') h->lookup += h->bigger*1 ;
          	 pfill (&h->plook, h->lookup, BROWN) ;  return (DO_NOTHING);
    	case 05: if (c=='A') h->divnum += h->bigger*1 ;
          	 if (c=='D') h->divnum += h->bigger*10.0 ;
          	 pfill (&h->pdiv, h->divnum, BROWN) ;  return (DO_NOTHING);
        default: return (DO_NOTHING) ;
    	}
    }

    for (i=0;i<h->nsrc;i++)
    {
        fi = (float) i ;
        if (YSTA-(fi+1.0)*BS<y && y<YSTA-fi*BS)
        {
            ipar = (int) ((x-XSTA)/BS) ;
    	    if (c=='?') { ghelp (3, ipar) ; return DO_NOTHING ; }
            if (ipar>=0 && ipar<NSPARM)
            {
                if (c=='D') s[i].par[ipar] += h->bigger * sbig[ipar] ;
                if (c=='A') s[i].par[ipar] += h->bigger * ssmall[ipar] ;
                if (c=='s'||c=='S') s[i].par[ipar] += h->bigger * ssmall[ipar]/10.0 ;
                pfill (&s[i].p[ipar], s[i].par[ipar], s[i].p[ipar].status) ;
            }
            return DO_NOTHING ;
        }
    }

    for (i=0;i<h->ngal;i++)
    {
        fi = (float) i ;
        if (YGSTA-(fi+1.0)*BS<y && y<YGSTA-fi*BS)
        {
            ipar = (int) ((x-XGSTA)/BS) ;
    	    if (c=='?') { ghelp (4, ipar) ; return DO_NOTHING ; }
            if (ipar>=0 && ipar<NGPARM)
            {
                if (c=='D') g[i].par[ipar] += h->bigger * gbig[ipar] ;
                if (c=='A') g[i].par[ipar] += h->bigger * gsmall[ipar] ;
                if (c=='s'||c=='S')g[i].par[ipar] += h->bigger * gsmall[ipar]/10.0 ;
                pfill (&g[i].p[ipar], g[i].par[ipar], g[i].p[ipar].status) ;
            }
        }
    }
    return DO_NOTHING ;
}

void pinit (Source *ss, Galaxy *gg)
{
    h->nx = h->ny = h->ims ;
    h->nsrc = h->ngal = 1 ;
    h->lookup = h->docont = h->noisy = 0 ;
    h->bigger = 1.0 ;

    if (!h->interactive) return ;

    mkrect (0.0,1.0,0.0,1.0,1,GREEN) ;
    pg_sci (1) ;
    sfill (ss) ;
    gfill (gg) ;
 
    mbutinit (&h->pspix, 0, 0, "spix") ;
    pifill (&h->pspix, 80, BROWN) ;   h->spix = 80 ;
    mbutinit (&h->psscale, 1, 0, "ssca") ;
    pifill (&h->psscale, 10, BROWN) ;   h->sscale = 0.010 ;
    mbutinit (&h->papix, 2, 0, "apix") ;
    pfill (&h->papix, 25, BROWN) ; h->a = 0.025 ;
    mbutinit (&h->pdocore, 0, 1, "core") ;
    pifill (&h->pdocore, 0, BROWN) ;   h->docore = 0 ;
    mbutinit (&h->paiter, 1, 1, "aite") ;
    pifill (&h->paiter, 1, BROWN) ;   h->aiter = 1 ;
    mbutinit (&h->pdoopt, 2, 1, "doop") ;
    pcfill (&h->pdoopt, "H", BROWN) ; h->doopt = NFIMOPT ;
    mbutinit (&h->pims, 0, 2, "ims") ;
    pifill (&h->pims, 128, BROWN) ;  h->ims = 128 ;
    mbutinit (&h->pord, 1, 2, "ord") ;
    pifill (&h->pord, 1, BROWN) ; h->ord = 1 ;
    mbutinit (&h->piter, 2, 2, "iter") ;
    pifill (&h->piter, 40, BROWN) ;  h->iter = 40 ;
    mbutinit (&h->psvsing, 0, 3, "svs") ;
    pfill (&h->psvsing, -9, BROWN) ;  h->svsing = -9 ;
    mbutinit (&h->pmaga, 1, 3, "maga") ;
    pfill (&h->pmaga, 20.0, BROWN) ;  h->maga = 2.0E1 ;
    mbutinit (&h->pdoh0, 2, 3, "doh0") ;
    pifill (&h->pdoh0, 0, BROWN) ;   h->doh0 = 0 ;
    mbutinit (&h->pspeed, 0, 4, "spee") ;
    pfill (&h->pspeed, 1, BROWN) ;      h->speed = 1.0 ;
    mbutinit (&h->preg, 1, 4, "reg") ;
    pfill (&h->preg, 5, BROWN) ;        h->reg = 5.0 ;
    mbutinit (&h->plook, 2, 4, "look") ;
    pifill (&h->plook, 0, BROWN) ;   h->lookup = 0 ;
    mbutinit (&h->pdiv, 0, 5, "div") ;
    pfill (&h->pdiv, 99, BROWN) ;      h->divnum = 99.0 ;
    butinit (&h->paddg, 0, 0, "addG") ;
    butinit (&h->padds, 0, 1, "addS") ;
    butinit (&h->pexit, 0, 2, "exit") ;
    butinit (&h->ptype, 1, 0, "type") ;
    butinit (&h->peval, 1, 1, "eval") ;
    butinit (&h->popt,  1, 2, "opt") ;
    butinit (&h->prmod, 2, 0, "rmod") ;
    butinit (&h->pplot, 2, 1, "plot") ;
    butinit (&h->pwd, 2, 2, "wd") ;
    butinit (&h->pfunk, 3, 0, "funk") ;
    butinit (&h->pcaus, 3, 1, "caus") ;
    butinit (&h->ptdel, 3, 2, "tdel") ;
    butinit (&h->pwrite,4, 0, "writ") ;
    butinit (&h->pprec, 4, 1, "prec") ;
    butinit (&h->pprint,4, 2, "prin") ;
    butinit (&h->pvar1, 5, 0, "var1") ;
    butinit (&h->pvar2, 5, 1, "var2") ;
    butinit (&h->psvd,  5, 2, "svd") ;
}

void sinit (Source *ss, int is)
{
    int ipar ;
    char deinit[NSPARM][7] = { "X", "Y", "maj", "min", "th", "F", "z" };
    double valinit[NSPARM]={ 0.5*h->ims, 0.5*h->ims, 3.0, 3.0, 0.0, 1.0, 1.0 },
    uliminit[NSPARM] = {100.*h->ims,100.*h->ims,1000.,1000.,1000.,1000.,10.0},
    lliminit[NSPARM] = {-100.*h->ims,-100.*h->ims,0.0,0.0,-1000.0,0.0, 0.0 };

    for (ipar=0;ipar<NSPARM;ipar++)
    {
        ss->p[ipar].xl = XSTA + BS*(double)(ipar) ;
        ss->p[ipar].yl = YSTA - BS*(double)(is+1) ;
        ss->p[ipar].xu = ss->p[ipar].xl+BS ;
        ss->p[ipar].yu = ss->p[ipar].yl+BS ;
        strcpy (ss->p[ipar].de, deinit[ipar]) ;
        ss->par[ipar] = valinit[ipar] ;
        ss->ulim[ipar] = uliminit[ipar] ;
        ss->llim[ipar] = lliminit[ipar] ;
        ss->p[ipar].status = RED ;
    }
}

void ginit (Galaxy *gg, int ig)
{
    int ipar ;
    char deinit[NGPARM][11]={"X","Y","b","th","ell","S","a1","a2","z","MT","SM","SA"};
    double valinit[NGPARM] = {0.5*h->ims,0.5*h->ims,24.,0.,0.6,5.,2.,2.,0.5,1.,0.,0.};
    double uliminit[NGPARM] = {100.*h->ims,100.*h->ims,VERYBIG,3600.,1.0,1000.,10.,10.,10.,10.,100.,3600.};
    double lliminit[NGPARM] = {-100.*h->ims, -100.*h->ims, 0, -3600.0, -1.0, 0., -10., -10., 0., 0., 0., -3600.};

    for (ipar=0;ipar<NGPARM;ipar++)
    {
        gg->p[ipar].xl = XGSTA + BS*(double)(ipar) ;
        gg->p[ipar].yl = YGSTA - BS*(double)(ig+1) ;
        gg->p[ipar].xu = gg->p[ipar].xl+BS ;
        gg->p[ipar].yu = gg->p[ipar].yl+BS ;
        strcpy (gg->p[ipar].de, deinit[ipar]) ;
        gg->par[ipar] = valinit[ipar] ;
        gg->ulim[ipar] = uliminit[ipar] ;
        gg->llim[ipar] = lliminit[ipar] ;
        gg->p[ipar].status = RED ;
    }
}

void butinit (Plot *p, int ix, int iy, char *label)
{
    p->xl = XPSTA+ix*BPS ;
    p->xu = XPSTA+(ix+1)*BPS ;
    p->yl = YPSTA-(iy+1)*BPS ;
    p->yu = YPSTA-iy*BPS ;
    strcpy (p->de, label) ;
    pfill (p, NO_ACT, (ix==0&&iy==2) ? RED : BLUE) ;
}
 
void mbutinit (Plot *p, int ix, int iy, char *label)
{
    p->xl = XMSTA+ix*BMS ;
    p->xu = XMSTA+(ix+1)*BMS ;
    p->yl = YMSTA-(iy+1)*BMS ;
    p->yu = YMSTA-iy*BMS ;
    strcpy (p->de, label) ;
    pfill (p, NO_ACT, BROWN) ;
}

void sfill (Source *ss)
{
    int i ;
    for (i=0; i<NSPARM; i++)
        pfill (&ss->p[i], ss->par[i], ss->p[i].status) ;
}

void gfill (Galaxy *gg)
{
    int i, colour ;
    for (i=0; i<NGPARM; i++)
        pfill (&gg->p[i], gg->par[i], gg->p[i].status) ;
}

double gatan (double y, double x)
{
    if (x==0.0&&y>=0.0) return PI/2.0 ;
    if (x==0.0&&y<0.0) return -PI/2.0 ;
    return ((x<0.0) ? atan(y/x)+PI : atan(y/x));
}

void fitsout (char *fitsfile, int nx, int ny, double *data)
{
    int i=0 ;
    float cdelt1=-h->a/3600.0, cdelt2=h->a/3600.0 ;
    char ccdelt1[12],ccdelt2[12] ;
    FILE *fp, *fopen () ;

    sprintf (ccdelt1, "%g", cdelt1) ;
    sprintf (ccdelt2, "%g", cdelt2) ;
    fp = fopen (fitsfile, "w") ;
    fprintf (fp,"SIMPLE  =                    T /                                                ") ;
    fprintf (fp,"BITPIX  =                  -32 /                                                ") ;
    fprintf (fp,"NAXIS   =                    2 /                                                ") ;
    fprintf (fp,"NAXIS1  =               %6d /                                                ",nx) ;
    fprintf (fp,"NAXIS2  =               %6d /                                                ",ny) ;
    fprintf (fp,"CDELT1  =         %12s /                                                ",ccdelt1) ;
    fprintf (fp,"CDELT2  =         %12s /                                                ",ccdelt2) ;
    fprintf (fp,"EXTEND  =                    F /                                                ") ;
    fprintf (fp,"ORIGIN  =              'igloo' /                                                ") ;
    fprintf (fp,"END                                                                             ") ;
    while (ftell(fp)<2880) fprintf (fp," ") ;
    for (i=0;i<nx*ny;i++) igwrite (data[i], fp);
    for (;;)
    {
    	i=ftell (fp) ; if ((i/2880)*2880==i) break ;
        fwrite ("\0", sizeof (char),1,fp) ;
    }
    fclose (fp) ;
}

int getendian ()
{
    char systype[128] ;
    FILE *fp, *fopen () ;
    system ("rm -f igloo_junk") ;
    system ("uname -s >igloo_junk") ;
    fp = fopen ("igloo_junk", "r") ;
    fscanf (fp, "%s", systype) ;
    fclose (fp) ;
    system ("rm -f igloo_junk") ;
    if (systype[0]=='L') return 0 ; else return 1 ;
}

void igwrite (double df, FILE *fp)
{
    int i, sf=sizeof(float), sc=sizeof(char) ; char c[8] ;
    float f = (float) df ;
    if (h->isbigend) fwrite (&f, sf, 1, fp) ;
    else
    {
    	for (i=0;i<sf;i++) memcpy (&c[i],(char *)(&f)+i,sc);
    	for (i=0;i<sf;i++) fwrite (&c[sf-i-1],sc,1,fp) ;
    }
}

void igread (double *df, FILE *fp, int bitpix)
{
    int i, sf=sizeof(float), sc=sizeof(char), sd=sizeof (double) ;
    char c[8], cd[16] ;
    float f ;
    if (bitpix!=-64)
    {
        if (h->isbigend) fread (&f, sf, 1, fp) ;
        else
        {
       	    for (i=0;i<sf;i++) fread (&c[i],sc,1,fp);
            for (i=0;i<sf;i++) memcpy ((char *)(&f)+i, &c[sf-i-1], sc);
        }
        *df = (double) f ;
    }
    else
    {
        if (h->isbigend) fread (df, sd, 1, fp) ;
        else
        {
       	    for (i=0;i<sd;i++) fread (&cd[i],sc,1,fp);
            for (i=0;i<sd;i++) memcpy ((char *)(df)+i, &cd[sd-i-1], sc);
        }
    }
}

void mkrect (float x1, float x2, float y1, float y2, int sfs, int col)
{
    pg_sci (col) ; pg_sfs (sfs) ; pg_rect (x1, x2, y1, y2) ;  pg_sfs (2) ; pg_sci (1) ;
}


