#include "gdefs.h"
#include "gpgdefs.h"
#define PSP 4

IGDEF

double gwd (double *p)
{
    Obs *im ;
    double *pl_v;
    int *pl_n,pl_b,pl_i;
    static double dscale, wscale, *psf, *data, *data_sort, *w ;
    static int been_here, d_siz, psf_siz, idmax, idmin, d_siz2, w_siz ;
    double sp_xpos[PIXTOT], sp_ypos[PIXTOT], fi, fj, mag, dist, xdist, ydist, 
      *ff, d[PIXTOT],swt[PIXTOT], dmax, dmin, pmax, pmin, xpos, ypos, *chisq,
      *model, goodness=0.0,stot, minv, maxv, x, y, lreg=pow(10.,h->reg),
      tr[6]={0.0,1.0,0.0,0.0,0.0,1.0}, galcenx, galceny, scenx, sceny ;
    float ftemp,sqpsp=sqrt(PSP),pinc=1.0/(2.0*PSP) ;
    int ss1=h->spix,ss2=ss1,isx,isy,ii,nsing,sing[PIXTOT],imin,imax,idx,
        idx1,jj,sp_npix=0,sp_size[PIXTOT],pix4=0,pix16=0,ix,iy,ixy ;
    char data_file[1024], psf_file[1024], dfile[1024]="\0", wfile[1024]="\0" ;

    for (ii=0; ii<PIXTOT; ii++) d[ii]=swt[ii]=0.0 ;

    if (!been_here || !p)
    {
      /*
        printf (" Enter name of data file: ") ;    scanf ("%s", data_file) ;
        printf (" Enter name of psf file: ") ;     scanf ("%s", psf_file) ;
	printf (" Model file name (or ^D for current model): ") ;scanf ("%s", dfile) ;
	printf (" Error file (or ^D to use crude estimate): ") ;scanf ("%s", wfile) ;
      */
        strcpy (data_file,"J0751_subim.fits") ;
        strcpy (psf_file, "J0751_psf.fits") ;
        strcpy (dfile, "0751.igl") ;
        strcpy (wfile, "") ;

        if (!(psf = fitsin (psf_file, &psf_siz, &dscale)) || 
            !(data = fitsin (data_file, &d_siz, &dscale))) 
            { printf ("Not found\n"); return VERYBIG ; }
        d_siz2 = d_siz * d_siz ;

        if (data_sort) free (data_sort) ;
	data_sort = (double *) malloc (d_siz2*sizeof (double)) ;
	for (ii=0;ii<d_siz2;ii++) 
            data_sort[ii]=(data[ii]>0.0)?data[ii]:-data[ii] ;
	qsort (data_sort, d_siz2, sizeof(double), sort_compf) ;


	if (strlen(dfile)>0) ginput (dfile) ;

	/*
        printf (" x coordinate (pixels) of the galaxy in the FITS file:") ;
	scanf ("%lf", &galcenx) ;
        printf (" y coordinate (pixels) of the galaxy in the FITS file:") ;
	scanf ("%lf", &galceny) ;
	*/
        galcenx = g[0].par[NGX] ;
        galceny = g[0].par[NGY] ;
        printf ("galaxy at %f,%f\n", galcenx, galceny);

        if (h->a/dscale < 1.0-1.0/VERYBIG || h->a/dscale > 1.0+1.0/VERYBIG)
            printf ("wd: rescaling image plane by %f\n", h->a/dscale) ;
        
        for (ii=h->ngal-1;ii>=0;ii--)
        {
            g[ii].par[NGX]=galcenx+(g[ii].par[NGX]-g[0].par[NGX])*h->a/dscale;
            g[ii].par[NGY]=galceny+(g[ii].par[NGY]-g[0].par[NGY])*h->a/dscale;
            g[ii].par[NGB] *= h->a/dscale ;
            printf ("Adjusted galaxy %i to (%f,%f), ER%f\n", ii, 
		    g[ii].par[NGX],g[ii].par[NGY],g[ii].par[NGB]);
            gfill (&g[ii]) ;
        }

        h->a = dscale ;
        pfill (&h->papix, h->a*1000.0, BROWN) ;
        h->ims = d_siz ;
        pifill (&h->pims, h->ims, BROWN) ;
        printf ("wd: setting plot grid to %dx%.2f\n", h->ims, h->a*1000.0) ;
        
        efunk (NULL) ;
        loadtop () ;
        pl_n = (int *)malloc(d_siz2*sizeof(int));
        pl_b = (int *)malloc(d_siz2*sizeof(int));
        pl_i = (int *)malloc(d_siz2*sizeof(int));
        pl_v = (double *)malloc(d_siz2*sizeof(double));

        if (!h->docore)
        {
            h->docore = 1 ;
            pifill (&h->pdocore, h->docore, BROWN) ;  
            printf ("wd: Note - setting docore to 1\n") ;
        }
        minmax (psf, psf_siz*psf_siz, &pmin, &pmax, &idmin, &idmax) ;
        minmax (data, d_siz2, &dmin, &dmax, &idmin, &idmax) ;

        printf ("wd: Image grid %d mas (%dx%d); source grid %d mas (%dx%d)\n",
             d_siz*(int)(1000.0*h->a), d_siz, (int)(1000.0*h->a),
             ss1*(int)(1000.0*h->sscale), ss1, (int)(h->sscale*1000.0)) ;
    }
    else
    {
        pl_n = (int *)malloc(d_siz2*sizeof(int));
        pl_b = (int *)malloc(d_siz2*sizeof(int));
        pl_i = (int *)malloc(d_siz2*sizeof(int));
        pl_v = (double *)malloc(d_siz2*sizeof(double));
    }

    if (p) loadfromp (p, 0) ;
    
    /* find brightest pixel in image, project back to source plane, determine 
   offset from source plane centre in arcseconds, convert to sp pixel size  */

    y = (double)(idmax/d_siz) ;
    x = (double)(idmax-d_siz*(idmax/d_siz)) ;
    gcsm (x, y, s[0].par[NSZ]) ;
    scenx = x - h->xoff ;
    sceny = y - h->yoff ;

    w = getweight (data, d_siz2, "", scenx, sceny) ;
    if (!p) printf ("wd: bright pix in image (%.1f,%.1f) -> (%.1f,%.1f)\n",
                    x,y,scenx,sceny) ;

    goutput ("output.txt");

    chisq = (double *) malloc (d_siz2*sizeof (double)) ;
    model = (double *) malloc (d_siz2*sizeof (double)) ;

    printf ("Source grid will extend from %.3f-%.3f, %.3f-%.3f\n",
	   scenx-(h->sscale/h->a)*(double)ss1/2.0,
	   scenx+(h->sscale/h->a)*(double)ss1/2.0,
	   sceny-(h->sscale/h->a)*(double)ss2/2.0,
	   sceny+(h->sscale/h->a)*(double)ss2/2.0) ;

    /*    --- Code to plot caustic if required ---
          FILE *fo;    fo=fopen("junk", "w");  for (isx=0;isx<128;isx++)
          for (isy=0;isy<128;isy++)
	  { im=groot((float)isx,(float)isy); fprintf(fo,"%d\n", im->ncomp);
	  }
          fclose(fo);
    */

    for (isy=0; isy<ss2; isy++)
    {
        for (isx=0; isx<ss1; isx++)
	{
            x = scenx+(h->sscale/h->a)*(double)(isx-ss1/2) ;
	    y = sceny+(h->sscale/h->a)*(double)(isy-ss2/2) ;
 	    im = groot (x,y) ;
            mag = 0.0 ; for (ii=0;ii<im->ncomp;ii++) mag += im->magtemp[ii] ;
            
            if (mag < h->maga)
            {
                sp_xpos[sp_npix] = (double)isx ;
                sp_ypos[sp_npix] = (double)isy ;
                sp_size[sp_npix] = 1 ;
                oconvolve (im, psf, pl_n, pl_b, pl_i, pl_v, psf_siz, 
                              (p)?0:1, sp_npix,d_siz,dscale) ;
                plotpl (pl_n, pl_b, pl_i, pl_v, sp_npix) ;
             	sp_npix++ ;
            }
            else if (mag >= h->maga && mag < h->maga*PSP)
            {
            	pix4++ ;
             	for (fi=-0.5+pinc;fi<=0.5001-pinc; fi+=2.*pinc)
             	{
             	    for (fj=-0.5+pinc; fj<=0.5001-pinc; fj+=2.*pinc)
             	    {
             	    	sp_xpos[sp_npix] = (double)isx + fj ;
             	    	sp_ypos[sp_npix] = (double)isy + fi ;
                        sp_size[sp_npix] = sqpsp ;
                        im = groot (scenx+(double)(isx-ss1/2)+fj, 
                                    sceny+(double)(isy-ss2/2)+fi) ;
                        for (ii=0;ii<im->ncomp;ii++) im->magtemp[ii] /= PSP ;
                        oconvolve (im, psf, pl_n, pl_b, pl_i, pl_v, psf_siz, 
                                   (p)?0:1, sp_npix, d_siz, dscale) ;
             	    	sp_npix++ ;
             	    }
                }
            }
            else
            {
             	for (fi=-0.5+pinc; fi<=0.5001-pinc; fi+=2.*pinc)
             	{
             	    for (fj=-0.5+pinc; fj<=0.5001-pinc; fj+=2.*pinc)
             	    {
             	    	pix16++ ;
             	    	sp_xpos[sp_npix] = (double)isx + fj ;
             	    	sp_ypos[sp_npix] = (double)isy + fi ;
                        sp_size[sp_npix] = PSP ;
                        im = groot (scenx+(double)(isx-ss1/2)+fj, 
                                    sceny+(double)(isy-ss2/2)+fi) ;
                        for (ii=0;ii<im->ncomp;ii++) im->magtemp[ii] /= 16.0 ;
                        oconvolve (im, psf, pl_n, pl_b, pl_i, pl_v, psf_siz, 
                                 (p)?0:1, sp_npix, d_siz, dscale) ;
             	    	sp_npix++ ;
             	    }
                }
            }
	}
    }

    ff = (double *) malloc (sp_npix*sp_npix*sizeof (double));
    for (ii=0;ii<sp_npix*sp_npix;ii++) ff[ii]=0.0 ;

    for (isx=0;isx<sp_npix;isx++) for (isy=0;isy<sp_npix;isy++)
    {
    	 ixy = isx - isy ;
         idx = isy*sp_npix+isx ;
         if (ixy<0) ixy *= -1 ;

    	 if (h->ord<=0)
    	 {
            if (!ixy) ff[idx]+=lreg;
         }
         else if (h->ord==1)
         {
             if (!ixy) ff[idx]+=4.0*lreg ;
             if (ixy==1||ixy==ss1) ff[idx]-=lreg;
	 }
	 else if (h->ord==2)
	 {
             if (!ixy) ff[idx]+=3.0*lreg ;
             if (ixy==1||ixy==ss1) ff[idx]-=lreg;
             if (ixy==2||ixy==ss1*2) ff[idx]+=0.25*lreg;
	 }
	 else
	 {
             if (!ixy) ff[idx]+=35.0*lreg/9.0 ;
             if (ixy==1||ixy==ss1) ff[idx]-= 14.0*lreg/9.0;
             if (ixy==2||ixy==ss1*2) ff[idx]+= 7.0*lreg/9.0;
             if (ixy==3||ixy==ss1*3) ff[idx]-= -2.0*lreg/9.0;
             if (ixy==4||ixy==ss1*4) ff[idx]+= 1.0*lreg/36.0;
         }
    }

    for (ii=0; ii<d_siz2; ii++)
    {
    	for (idx=0; idx<pl[ii].nframe; idx++)
    	{
    	    d[pl[ii].ip[idx]] += pl[ii].val[idx] * data[ii]*w[ii] ;
    	    for (idx1=0; idx1<pl[ii].nframe; idx1++)
    	    	ff[pl[ii].ip[idx]*sp_npix+pl[ii].ip[idx1]] +=
    	    	   pl[ii].val[idx]*pl[ii].val[idx1]*w[ii] ;
    	}
    }

    h->chucksing = 0 ;
    nsing=getsvd (ff, d, sing, sp_npix, swt) ;
    screen (FULL) ;

    if (nsing)
    {
    	if (p) for (ii=0;ii<h->os.nos;ii++) printf ("%.2f ", p[ii]) ;
        printf ("wd: warning: %d singular values\n", nsing) ;
    }

    for (ii=0;ii<d_siz*d_siz;ii++)
    {
        stot=0.0 ;
        for (isx=0; isx<pl[ii].nframe; isx++)
            stot += swt[pl[ii].ip[isx]]*pl[ii].val[isx] ;
        iy = ii/d_siz ;
        ix = ii - d_siz*iy ;
        xdist = (double)ix - g[0].par[NGX] ;
        ydist = (double)iy - g[0].par[NGY] ;
        dist = sqrt (xdist*xdist+ydist*ydist) ;
        chisq[ii]=0.0 ;
        chisq[ii] = (stot-data[ii])*(stot-data[ii])*w[ii] ;
        model[ii] = stot ;
        goodness += chisq[ii]*chisq[ii] ;
    }

    plotvar (swt, sp_xpos, sp_ypos, sp_size, sp_npix, ss1, ss2) ;

    h->pxu = h->pyu = d_siz ;
    screen (WPLOT2) ;
    minmax (chisq, d_siz*d_siz, &minv, &maxv, &imin, &imax) ;
    printf ("\nChisq: range %f %f\n", minv, maxv) ;
    pg_dgray (chisq,d_siz,d_siz,1,d_siz,1,d_siz,minv,maxv,tr)  ;
    pg_text(5.0,5.0,"Chi-sq");
    for (ii=0;ii<sp_npix*sp_npix;ii++) 
      if (ff[ii]!=0.0)
         ff[ii] = log10((ff[ii]>0.0)?ff[ii]:-ff[ii]) ;

    screen (WPLOT3) ;
    minmax (data, d_siz*d_siz, &minv, &maxv, &imin, &imax) ;
    printf ("\nData: range %f %f\n", minv, maxv) ;
    pg_dgray (data,d_siz,d_siz,1,d_siz,1,d_siz,minv,minv+0.7*(maxv-minv),tr) ;
    pg_text(5.0,5.0,"Data");
    screen (WPLOT4) ;
    minmax (model, d_siz*d_siz, &minv, &maxv, &imin, &imax) ;
    printf ("\nModel: range %f %f\n", minv, maxv) ;
    pg_dgray (model,d_siz,d_siz,1,d_siz,1,d_siz,minv,minv+0.7*(maxv-minv),tr);
    pg_text(5.0,5.0,"Model");
    screen (WPLOT5) ;
    ftemp = (float)sp_npix ;
    pg_window (0.0, ftemp, 0.0, ftemp) ;
    minmax (ff, sp_npix*sp_npix, &minv, &maxv, &imin, &imax) ;
    pg_dgray (ff, sp_npix, sp_npix, 1, sp_npix, 1, sp_npix, minv, maxv, tr);
    pg_text(5.0,5.0,"ff-array");

    h->pxu = h->pyu = h->ims ;
    screen (FULL) ;

    goodness /= (double)(d_siz*d_siz) ;
    if (!p) printf ("wd: goodness = %f - %d pixels\n", goodness, sp_npix) ;
    been_here++ ;
    fitsout ("gwd_chisq.fits", d_siz, d_siz, chisq) ;
    fitsout ("gwd_model.fits", d_siz, d_siz, model) ;
    if (chisq) free (chisq) ;
    if (model) free (model) ;
    if (ff) free (ff) ;
    return goodness ;
}

double *fitsin (char *filename, int *size, double *scale)
{
    FILE *fp, *fopen () ;
    char card[80], rfile[1024], line[1024] ;
    int fpos, i, foundscale = 0, bitpix=-32 ;
    static double *buf ;
    double rscale ;

    fp = fopen (filename, "r") ;
    if (!fp) return NULL ;
    for(;;)
    {
        if (!fread (card, 80*sizeof(char), 1, fp)) return 0 ;
	if (!strncmp (card, "END", 3)) break ;
        if (!strncmp (card, "NAXIS1", 6)) sscanf (&card[10], "%d", size) ;
        if (!strncmp (card, "CDELT1", 6))
        {
            sscanf (&card[10], "%lf", scale);
            *scale = fabs (*scale * 3600.0) ;
            foundscale = 1 ;
        }
        if (!strncmp (card, "BITPIX", 6))
	    sscanf (&card[10], "%d", &bitpix) ;
    }
    fpos = ftell (fp) ;
    fseek (fp, 0, 0) ;
    while (ftell (fp) < fpos) fseek (fp, 2880, 1) ;
    buf = (double *) malloc ((*size)*(*size)*sizeof(double)) ;
    for (i=0;i<(*size)*(*size);i++) igread (&buf[i], fp, bitpix) ;
    fclose (fp) ;

    if (!foundscale)   /* try and find it in a file igloo_scales */
    {
        fp = NULL; fp = fopen ("igloo_scales", "r") ;
        if (fp)
        {
	    while (fgets(line,sizeof(line),fp))
	    {
		sscanf (line, "%s %lf", &rfile, &rscale) ;
		if (!strcmp (rfile, filename))
                {
		    *scale=rscale ;
		    foundscale = 1 ;
		}
	    }
	    fclose (fp) ;
	}
	if (!foundscale)
	{
    	    fflush (stdout) ; fflush (stdin) ;
      	    printf ("\nfi: Can't find scale of %s, enter it: ", filename) ;
	    scanf ("%lf", scale) ;
            fp = fopen ("igloo_scales","a") ;   /* write it */
  	    fprintf (fp, "%s %lf\n", filename, *scale) ;
	    fclose (fp) ;
	}

    }
    return buf ;
}

void oconvolve (Obs *im, double *psf, Psflist *pl, double psf_siz, int doplot,
  int frameno, int d_siz, double dscale)
{
    int ix, iy, icomp=0, ps=(int)psf_siz, idx, jj,i ;
    double xdist, ydist, dist, xpos,ypos ;
    if (doplot) { screen (WPLOT) ; pg_sci (2) ; }

    for (ix=0;ix<d_siz;ix++)
    {
        for (iy=0;iy<d_siz;iy++)
        {
	    for (icomp=0; icomp<im->ncomp; icomp++)
	    {
	    	idx = iy*d_siz+ix ;
  	        xdist = (double)(ix+1) - im->ra[icomp] ;
                ydist = (double)(iy+1) - im->dec[icomp] ;
                dist = sqrt(xdist*xdist+ydist*ydist) ;
                
		if (dist<0.5*psf_siz)
		{
		    if (pl[idx].nframe && (pl[idx].nframe/PSFBLOCK)*PSFBLOCK == pl[idx].nframe)
                    {
          	        pl[idx].bufsiz += PSFBLOCK ;
                    	pl[idx].ip=realloc(pl[idx].ip,pl[idx].bufsiz*sizeof(int)) ;
			for (jj=pl[idx].bufsiz-PSFBLOCK;jj<pl[idx].bufsiz;jj++)
                            pl[idx].ip[jj] = 0 ;
                    	pl[idx].val = realloc (pl[idx].val, pl[idx].bufsiz*sizeof(double)) ;
			for (jj=pl[idx].bufsiz-PSFBLOCK;jj<pl[idx].bufsiz;jj++)
                            pl[idx].val[jj] = 0.0 ;
                    }
                    pl[idx].ip[pl[idx].nframe] = frameno ;
                    pl[idx].val[pl[idx].nframe] += fabs(im->magtemp[icomp]) *
                        linterp (psf, psf_siz/2.0+xdist, psf_siz/2.0+ydist, ps, ps) ;
		    if (pl[idx].val[pl[idx].nframe] > PSFLIM || 
                        pl[idx].val[pl[idx].nframe] < -PSFLIM)
                            pl[idx].nframe++ ;
                }
	    }
	}
    }
    if (doplot) screen (FULL) ;
}

void minmax (double *x, int ix,double *fmin,double *fmax,int *imin,int *imax)
{
    int i ; *fmin = VERYBIG ; *fmax = -VERYBIG ;
    for (i=0;i<ix;i++)
    {
        if (*fmin>x[i]) { *fmin=x[i] ; *imin=i ;}
        if (*fmax<x[i]&&x[i]!=VERYBIG) { *fmax=x[i] ; *imax=i ;}
    }
}

void plotvar (double *swt, double *sp_xpos, double *sp_ypos, int *sp_size,
              int sp_npix, int ss1, int ss2)
{
    double minv, maxv ;
    float cindex ;
    int imin, imax, i ;
    minmax (swt, sp_npix, &minv, &maxv, &imin, &imax) ;

    h->pxu = h->pyu = h->spix+1 ;
    screen (WPLOT1) ;
    h->pxu = h->pyu = h->ims ;
    pg_sfs (1) ;
    for (i=0; i<sp_npix; i++)
    {
        cindex = (maxv-swt[i])/(maxv-minv) ;
        pg_scr (1, cindex, cindex, cindex) ;
        pg_sci (1) ;
        pg_drect ((double)sp_xpos[i]-0.5/(double)sp_size[i],
                  (double)sp_xpos[i]+0.5/(double)sp_size[i],
                  (double)sp_ypos[i]-0.5/(double)sp_size[i],
                  (double)sp_ypos[i]+0.5/(double)sp_size[i]) ;
    }
    pg_scr (1, 1.0, 1.0, 1.0) ;
    pg_sfs (2) ;
}

void plotpl (Psflist *pl, int frameno)
{
    double grid[h->ims*h->ims], minv, maxv, tr[6] = {0.0,1.0,0.0,0.0,0.0,1.0} ;
    int ix, iy, ii, j, imin, imax ;

    for (iy=0;iy<h->ims;iy++)
    	for (ix=0;ix<h->ims;ix++)
    	    grid[iy*h->ims+ix] = 0.0 ;

    for (iy=0;iy<h->ims;iy++)
    {
    	for (ix=0;ix<h->ims;ix++)
    	{
    	    ii=iy*h->ims+ix ;
    	    for (j=0;j<pl[ii].nframe;j++)
    	    	if (pl[ii].ip[j] == frameno) grid[ii] += pl[ii].val[j] ;
    	}
    }
    h->pxu = h->pyu = h->ims ; h->pxl = h->pyl = 0.0 ;
    screen (WPLOT) ;
    minmax (grid, h->ims*h->ims, &minv, &maxv, &imin, &imax) ;
    pg_dgray (grid,h->ims,h->ims,1,h->ims,1,h->ims,minv-0.01,maxv+0.01,tr) ;
}
